/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.Mass;
import net.java.dev.joode.World;
import net.java.dev.joode.WorldObject;
import net.java.dev.joode.force.BodyForce;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.FastMath;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.PosRot;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.RK4;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector;
import net.java.dev.joode.util.Vector3;
import org.jagatoo.datatypes.DoublyChainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Body
extends WorldObject
implements DoublyChainable<Body> {
    private static final long serialVersionUID = -8999232346923178358L;
    private static final Vector3 irv = new Vector3();
    private static final Vector3 frv = new Vector3();
    private static final Vector3 tf1 = new Vector3();
    private static final Vector3 tf2 = new Vector3();
    private static final Vector3 crossResult = new Vector3();
    private static final Quaternion tmpq = new Quaternion();
    private static final Quaternion tmpq2 = new Quaternion();
    public static final Vector3 totalLinearForces = new Vector3();
    public static final Vector3 totalRotationForces = new Vector3();
    public static final int BODY_FLAG_FINITE_ROTATION = 1;
    public static final int BODY_FLAG_FINITE_ROTATION_AXIS = 2;
    public static final int BODY_FLAG_RK4_STEP = 4;
    public static final int BODY_FLAG_BODY_DISABLED = 8;
    public static final int BODY_FLAG_NO_FORCE = 16;
    public static final int BODY_FLAG_AUTO_DISABLE = 32;
    public static final int BODY_FLAG_GRAVITY = 64;
    private Body next = null;
    private Body previous = null;
    private Mass mass;
    private final ArrayList<Geom> geoms;
    private final ArrayList<Joint> joints;
    private final List<BodyForce> forces;
    private int flags;
    private final Vector3 pos = new Vector3();
    private final Quaternion quat = new Quaternion();
    public final Vector3 lmom = new Vector3();
    private final Vector3 amom = new Vector3();
    private final Vector3 facc = new Vector3();
    private final Vector3 tacc = new Vector3();
    private final Matrix3 rot = new Matrix3();
    private final Vector3 lvel = new Vector3();
    private final Vector3 avel = new Vector3();
    private final Vector3 finite_rot_axis = new Vector3();
    private final PosRot posRot = new PosRot(this.pos, this.rot);
    private final BodyState bodyState = new BodyState();
    private final BodyDifferential odeDifferential = new BodyDifferential(this);

    public Body(World world, Mass mass) {
        super(world);
        if (world != null) {
            this.getWorld().addBody(this);
        }
        this.mass = mass;
        this.flags = 64;
        this.rot.setIdentity();
        this.quat.m[0] = 1.0f;
        this.geoms = new ArrayList();
        this.joints = new ArrayList();
        this.forces = new ArrayList<BodyForce>();
    }

    private Body(Mass mass) {
        this(null, mass);
    }

    @Override
    public void destroy() {
        int i = 0;
        while (i < this.geoms.size()) {
            this.geoms.get(i).setBody(null);
            ++i;
        }
        i = 0;
        while (i < this.joints.size()) {
            Joint joint;
            joint.setBody(this == (joint = this.joints.get(i)).getBody(0) ? 0 : 1, null);
            joint.removeJointReferencesFromAttachedBodies();
            ++i;
        }
        this.getWorld().removeBody(this);
    }

    @Override
    public void setPrevious(Body o) {
        this.previous = o;
    }

    @Override
    public Body getPrevious() {
        return this.previous;
    }

    @Override
    public void setNext(Body o) {
        this.next = o;
    }

    @Override
    public Body getNext() {
        return this.next;
    }

    public final void setMass(Mass mass) {
        if (mass == null) {
            throw new NullPointerException("mass must not be null");
        }
        this.mass = mass;
        this.setLinearVel(this.getLinearVel());
        this.setAngularVel(this.getAngularVel());
        this.recalc();
    }

    public final Mass getMass() {
        return this.mass;
    }

    public final BodyState getState() {
        return this.bodyState;
    }

    public final BodyDifferential getDifferential() {
        return this.odeDifferential;
    }

    public void setPosition(float x, float y, float z) {
        this.pos.set(x, y, z);
    }

    public final void setPosition(Vector3 pos) {
        this.setPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public final Vector3 getPosition() {
        return this.pos;
    }

    public void setRotation(Matrix3 R) {
        this.rot.set(R);
        this.quat.set(R);
    }

    public void setRotation(float a, float b, float c, float w) {
        this.quat.m[1] = a;
        this.quat.m[2] = b;
        this.quat.m[3] = c;
        this.quat.m[0] = w;
        this.rot.set(this.quat);
    }

    public void setRotation(Quaternion q) {
        this.quat.set(q);
        this.rot.set(q);
    }

    public final Matrix3 getRotation() {
        return this.rot;
    }

    public final Quaternion getQuaternion() {
        return this.quat;
    }

    public final PosRot getPosRot() {
        return this.posRot;
    }

    public void step(float dt) {
        this.resetForces();
        if ((this.flags & 4) == 0) {
            this.quickStep(dt);
        } else {
            this.stepRK4(dt);
        }
    }

    private void quickStep(float dt) {
        Body b = this;
        if (!this.isEnabled()) {
            return;
        }
        int j = 0;
        while (j < 3) {
            int n = j;
            b.pos.m[n] = b.pos.m[n] + dt * b.lvel.m[j];
            ++j;
        }
        if ((b.flags & 1) != 0) {
            float s;
            float theta;
            if ((b.flags & 2) != 0) {
                float k = b.finite_rot_axis.dot(b.avel);
                Body.frv.m[0] = b.finite_rot_axis.m[0] * k;
                Body.frv.m[1] = b.finite_rot_axis.m[1] * k;
                Body.frv.m[2] = b.finite_rot_axis.m[2] * k;
                Body.irv.m[0] = b.avel.m[0] - Body.frv.m[0];
                Body.irv.m[1] = b.avel.m[1] - Body.frv.m[1];
                Body.irv.m[2] = b.avel.m[2] - Body.frv.m[2];
                theta = k * (dt *= 0.5f);
                Body.tmpq.m[0] = (float)Math.cos(theta);
                s = theta == 0.0f ? dt : (float)(Math.sin(theta) / (double)theta) * dt;
                Body.tmpq.m[1] = Body.frv.m[0] * s;
                Body.tmpq.m[2] = Body.frv.m[1] * s;
                Body.tmpq.m[3] = Body.frv.m[2] * s;
            } else {
                float wlen = this.avel.norm();
                theta = wlen * (dt *= 0.5f);
                Body.tmpq.m[0] = FastMath.cos(theta);
                s = theta == 0.0f ? dt : FastMath.sin(theta) / theta * dt;
                Body.tmpq.m[1] = b.avel.m[0] * s;
                Body.tmpq.m[2] = b.avel.m[1] * s;
                Body.tmpq.m[3] = b.avel.m[2] * s;
            }
            tmpq.mul(b.quat, tmpq2);
            j = 0;
            while (j < 4) {
                b.quat.m[j] = Body.tmpq2.m[j];
                ++j;
            }
            if ((b.flags & 2) != 0) {
                Quaternion dq = b.quat.mulScale(irv, 0.5f, tmpq);
                j = 0;
                while (j < 4) {
                    int n = j;
                    b.quat.m[n] = b.quat.m[n] + dt * dq.m[j];
                    ++j;
                }
            }
        } else {
            Quaternion dq = b.quat.mulScale(b.avel, 0.5f, tmpq);
            j = 0;
            while (j < 4) {
                int n = j;
                b.quat.m[n] = b.quat.m[n] + dt * dq.m[j];
                ++j;
            }
        }
        this.recalc();
        int i = 0;
        while (i < this.geoms.size()) {
            Geom geom = this.geoms.get(i);
            Space.onGeomMoved(geom);
            ++i;
        }
    }

    public void stepRK4(float stepsize) {
        RK4.intergrateAapative(this.bodyState, this.odeDifferential, 0.0f, stepsize, 0.1f, this.bodyState);
        this.recalc();
        int i = 0;
        while (i < this.geoms.size()) {
            Geom geom = this.geoms.get(i);
            Space.onGeomMoved(geom);
            ++i;
        }
    }

    public void recalc() {
        this.lvel.set(this.lmom);
        this.lvel.scale(this.mass.getInverseMass());
        this.quat.normalize();
        this.rot.set(this.quat);
        Mass m = this.mass.rotate(this.rot, Mass.pool.aquire());
        this.avel.setZero();
        m.invI.mulInc(this.amom, this.avel);
        Mass.pool.release(m);
    }

    public final void addGeom(Geom g) {
        this.geoms.add(g);
        g.setBody(this);
    }

    public final void removeGeom(Geom g) {
        if (this.geoms.remove(g)) {
            g.setBody(null);
        }
    }

    public final Geom getGeom() {
        return this.geoms.get(0);
    }

    public final int getNumGeoms() {
        return this.geoms.size();
    }

    public final Geom getGeom(int i) {
        return this.geoms.get(i);
    }

    public final void addForce(BodyForce dynamicForce) {
        this.forces.add(dynamicForce);
    }

    public final void removeForce(BodyForce dynamicForce) {
        this.forces.remove(dynamicForce);
    }

    public final int getNumForces() {
        return this.forces.size();
    }

    public final BodyForce getForce(int i) {
        return this.forces.get(i);
    }

    public final void addJoint(Joint joint) {
        this.joints.add(joint);
    }

    public final void removeJoint(Joint joint) {
        this.joints.remove(joint);
    }

    public final int getNumJoints() {
        return this.joints.size();
    }

    public final Joint getJoint(int i) {
        return this.joints.get(i);
    }

    public final void setFlag(int flag, boolean b) {
        this.flags = b ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setEnabled(boolean e) {
        this.flags = !e ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isEnabled() {
        return (this.flags & 8) != 8;
    }

    public final void enable() {
        this.setEnabled(true);
    }

    public final void disable() {
        this.setEnabled(false);
    }

    public void setAutoDisabled(boolean e) {
        this.flags = e ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean isAutoDisabled() {
        return (this.flags & 0x20) == 32;
    }

    public final void setGravityMode(boolean m) {
        this.flags = m ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean getGravityMode() {
        return (this.flags & 0x40) == 64;
    }

    public final void setFiniteRotations(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isFiniteRotations() {
        return (this.flags & 1) == 1;
    }

    public void setRK4Step(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public void setStepDisableThreshold(int i) {
    }

    public void setLinearVel(float fx, float fy, float fz) {
        this.lvel.set(fx, fy, fz);
        this.lmom.set(fx * this.mass.getMass(), fy * this.mass.getMass(), fz * this.mass.getMass());
    }

    public final void setLinearVel(Vector3 values) {
        this.setLinearVel(values.getX(), values.getY(), values.getZ());
    }

    public final Vector3 getLinearVel() {
        return this.lvel;
    }

    public final void getLinearVel(Vector3 v) {
        v.set(this.lvel.m[0], this.lvel.m[1], this.lvel.m[2]);
    }

    public void setAngularVel(float fx, float fy, float fz) {
        this.avel.set(fx, fy, fz);
        Mass m = this.mass.rotate(this.rot, Mass.pool.aquire());
        this.amom.setZero();
        m.getMomentOfInertia().mulInc(this.avel, this.amom);
        Mass.pool.release(m);
    }

    public final void setAngularVel(Vector3 values) {
        this.setAngularVel(values.getX(), values.getY(), values.getZ());
    }

    public Vector3 getAngularVel() {
        return this.avel;
    }

    public void getAngularVel(Vector3 v) {
        v.set(this.avel.getX(), this.avel.getY(), this.avel.getZ());
    }

    public final void getForce(Vector3 v) {
        v.set(this.facc.m[0], this.facc.m[1], this.facc.m[2]);
    }

    public final void getTorque(Vector3 v) {
        v.set(this.tacc.m[0], this.tacc.m[1], this.tacc.m[2]);
    }

    public void getVelocityAt(Vector3 globalCoords, Vector3 velocityPassback) {
        globalCoords.sub(this.pos);
        this.avel.cross(globalCoords, velocityPassback);
        velocityPassback.add(this.lvel);
        globalCoords.add(this.pos);
    }

    public void resetForces() {
        this.facc.set(0.0f, 0.0f, 0.0f);
        this.tacc.set(0.0f, 0.0f, 0.0f);
    }

    public final void setFACC(float x, float y, float z) {
        this.facc.set(x, y, z);
    }

    public final void setFACC(Vector3 tacc) {
        this.facc.set(tacc);
    }

    public final Vector3 getFACC() {
        return this.facc;
    }

    public final void setTACC(float x, float y, float z) {
        this.tacc.set(x, y, z);
    }

    public final void setTACC(Vector3 tacc) {
        this.tacc.set(tacc);
    }

    public final Vector3 getTACC() {
        return this.tacc;
    }

    public void getTotalForces(float t, Vector3 faccPassback, Vector3 taccPassback) {
        faccPassback.setZero();
        taccPassback.setZero();
        faccPassback.add(this.facc);
        taccPassback.add(this.tacc);
        Iterator<WorldForce> it = this.getWorld().getForces();
        while (it.hasNext()) {
            it.next().applyForce(this, t, faccPassback, taccPassback);
        }
        int i = 0;
        while (i < this.forces.size()) {
            this.forces.get(i).applyForce(t, faccPassback, taccPassback);
            ++i;
        }
    }

    public void addForce(float fx, float fy, float fz) {
        this.facc.m[0] = this.facc.m[0] + fx;
        this.facc.m[1] = this.facc.m[1] + fy;
        this.facc.m[2] = this.facc.m[2] + fz;
    }

    public void addTorque(float fx, float fy, float fz) {
        this.tacc.m[0] = this.tacc.m[0] + fx;
        this.tacc.m[1] = this.tacc.m[1] + fy;
        this.tacc.m[2] = this.tacc.m[2] + fz;
    }

    public void addRelForce(float fx, float fy, float fz) {
        Body.tf1.m[0] = fx;
        Body.tf1.m[1] = fy;
        Body.tf1.m[2] = fz;
        Body.tf1.m[3] = 0.0f;
        MathUtils.dMULTIPLY0_331((Real)tf2, this.rot, (Real)tf1);
        this.facc.m[0] = this.facc.m[0] + Body.tf2.m[0];
        this.facc.m[1] = this.facc.m[1] + Body.tf2.m[1];
        this.facc.m[2] = this.facc.m[2] + Body.tf2.m[2];
    }

    public void addRelTorque(float fx, float fy, float fz) {
        Body.tf1.m[0] = fx;
        Body.tf1.m[1] = fy;
        Body.tf1.m[2] = fz;
        Body.tf1.m[3] = 0.0f;
        MathUtils.dMULTIPLY0_331((Real)tf2, this.rot, (Real)tf1);
        this.tacc.m[0] = this.tacc.m[0] + Body.tf2.m[0];
        this.tacc.m[1] = this.tacc.m[1] + Body.tf2.m[1];
        this.tacc.m[2] = this.tacc.m[2] + Body.tf2.m[2];
    }

    public void addForceAtPos(float fx, float fy, float fz, float px, float py, float pz) {
        this.addForceAtPos(fx, fy, fz, px, py, pz, this.facc, this.tacc);
    }

    public void addForceAtPos(float fx, float fy, float fz, float px, float py, float pz, Vector3 forcePassback, Vector3 torquePassback) {
        forcePassback.m[0] = forcePassback.m[0] + fx;
        forcePassback.m[1] = forcePassback.m[1] + fy;
        forcePassback.m[2] = forcePassback.m[2] + fz;
        Body.tf1.m[0] = fx;
        Body.tf1.m[1] = fy;
        Body.tf1.m[2] = fz;
        Body.tf1.m[3] = 0.0f;
        Body.tf2.m[0] = px - this.pos.m[0];
        Body.tf2.m[1] = py - this.pos.m[1];
        Body.tf2.m[2] = pz - this.pos.m[2];
        Body.tf2.m[3] = 0.0f;
        torquePassback.add(tf2.cross(tf1, crossResult));
    }

    public void addForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        Vector3 prel = new Vector3();
        Vector3 f = new Vector3();
        Vector3 p = new Vector3();
        f.m[0] = fx;
        f.m[1] = fy;
        f.m[2] = fz;
        prel.m[0] = px;
        prel.m[1] = py;
        prel.m[2] = pz;
        MathUtils.dMULTIPLY0_331((Real)p, this.rot, (Real)prel);
        this.facc.m[0] = this.facc.m[0] + f.m[0];
        this.facc.m[1] = this.facc.m[1] + f.m[1];
        this.facc.m[2] = this.facc.m[2] + f.m[2];
        this.tacc.add(p.cross(f, crossResult));
    }

    public void addRelForceAtPos(float fx, float fy, float fz, float px, float py, float pz) {
        this.addRelForceAtPos(fx, fy, fz, px, py, pz, this.facc, this.tacc);
    }

    public void addRelForceAtPos(float fx, float fy, float fz, float px, float py, float pz, Vector3 forcePassback, Vector3 torquePassback) {
        Body.tf1.m[0] = fx;
        Body.tf1.m[1] = fy;
        Body.tf1.m[2] = fz;
        Body.tf1.m[3] = 0.0f;
        MathUtils.dMULTIPLY0_331((Real)tf2, this.rot, (Real)tf1);
        forcePassback.m[0] = forcePassback.m[0] + Body.tf2.m[0];
        forcePassback.m[1] = forcePassback.m[1] + Body.tf2.m[1];
        forcePassback.m[2] = forcePassback.m[2] + Body.tf2.m[2];
        Body.tf1.m[0] = px - this.pos.m[0];
        Body.tf1.m[1] = py - this.pos.m[1];
        Body.tf1.m[2] = pz - this.pos.m[2];
        Body.tf1.m[3] = 0.0f;
        torquePassback.add(tf1.cross(tf2, crossResult));
    }

    public void addRelForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        Vector3 prel = new Vector3();
        Vector3 p = new Vector3();
        Body.tf1.m[0] = fx;
        Body.tf1.m[1] = fy;
        Body.tf1.m[2] = fz;
        prel.m[0] = px;
        prel.m[1] = py;
        prel.m[2] = pz;
        MathUtils.dMULTIPLY0_331((Real)tf2, this.rot, (Real)tf1);
        MathUtils.dMULTIPLY0_331((Real)p, this.rot, (Real)prel);
        this.facc.m[0] = this.facc.m[0] + Body.tf2.m[0];
        this.facc.m[1] = this.facc.m[1] + Body.tf2.m[1];
        this.facc.m[2] = this.facc.m[2] + Body.tf2.m[2];
        this.tacc.add(p.cross(tf2, crossResult));
    }

    @Override
    public Body cloneState(ClonedReferences util) {
        Body clone = new Body((Mass)util.getClone(this.mass));
        this.partialCloneWorldObject(clone, util);
        clone.flags = this.flags;
        clone.pos.set(this.pos);
        clone.quat.set(this.quat);
        clone.rot.set(this.rot);
        clone.lvel.set(this.lvel);
        clone.avel.set(this.avel);
        clone.facc.set(this.facc);
        clone.tacc.set(this.tacc);
        clone.finite_rot_axis.set(this.finite_rot_axis);
        int i = 0;
        while (i < this.joints.size()) {
            clone.joints.add((Joint)util.getClone(this.joints.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.geoms.size()) {
            util.getClone(this.geoms.get(i));
            ++i;
        }
        clone.setTag(this.getTag());
        clone.setWorld((World)util.getClone(this.getWorld()));
        return clone;
    }

    public void getAngularMomentum(Vector3 passback) {
        passback.set(this.amom);
    }

    public void getLinearMomentum(Vector3 passback) {
        passback.set(this.lmom);
    }

    public void getAngularVelocityToTurn(Quaternion dq, float fps, Vector3 angularPassback) {
        float halfAngle = FastMath.acos(Math.max(Math.min(dq.m[0], 1.0f), -1.0f));
        float invSinHalfAngle = Real.epsilonEquals(halfAngle, 0.0f, 1.0E-4f) ? 1.0f : (float)Math.sin(halfAngle);
        angularPassback.setX(dq.get(1) / invSinHalfAngle);
        angularPassback.setY(dq.get(2) / invSinHalfAngle);
        angularPassback.setZ(dq.get(3) / invSinHalfAngle);
        angularPassback.scale(halfAngle * 2.0f * fps);
    }

    public String toString() {
        return "pos:" + this.pos + " rot:" + this.quat + " vel:" + this.lvel + " avel" + this.avel;
    }

    public static class BodyDifferential
    implements RK4.Differential {
        Body b;
        public boolean setBodyVariables = true;

        public BodyDifferential(Body b) {
            this.b = b;
        }

        public void updateBody(Vector state, float t) {
            int i = 0;
            while (i < state.size()) {
                this.b.bodyState.set(i, state.get(i));
                ++i;
            }
            this.b.recalc();
        }

        public void evaluate(Vector state, float t, float t_start, float t_end, Vector passback) {
            if (this.setBodyVariables) {
                this.updateBody(state, t);
            }
            this.b.getTotalForces(t, totalLinearForces, totalRotationForces);
            int i = 0;
            while (i < 3) {
                passback.set(i, totalLinearForces.get(i));
                ++i;
            }
            i = 0;
            while (i < 3) {
                passback.set(i + 3, totalRotationForces.get(i));
                ++i;
            }
            i = 0;
            while (i < 3) {
                passback.set(i + 6, this.b.lvel.get(i));
                ++i;
            }
            this.b.quat.dqdt(this.b.avel, tmpq);
            i = 0;
            while (i < 4) {
                passback.set(i + 9, tmpq.get(i));
                ++i;
            }
        }

        public int size() {
            return 13;
        }
    }

    private final class BodyState
    implements Vector {
        private BodyState() {
        }

        public void set(int index, float val) {
            if (index < 3) {
                Body.this.lmom.set(index, val);
            } else if (index < 6) {
                Body.this.amom.set(index - 3, val);
            } else if (index < 9) {
                Body.this.pos.set(index - 6, val);
            } else {
                assert (index < 13);
                Body.this.quat.set(index - 9, val);
            }
        }

        public float get(int index) {
            if (index < 3) {
                return Body.this.lmom.get(index);
            }
            if (index < 6) {
                return Body.this.amom.get(index - 3);
            }
            if (index < 9) {
                return Body.this.pos.get(index - 6);
            }
            assert (index < 13);
            return Body.this.quat.get(index - 9);
        }

        public int size() {
            return 13;
        }
    }
}

