/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.BoxBoxCollider;
import net.java.dev.joode.collision.collider.BoxPlaneCollider;
import net.java.dev.joode.collision.collider.CapsuleBoxCollider;
import net.java.dev.joode.collision.collider.CapsuleCapsuleCollider;
import net.java.dev.joode.collision.collider.CapsulePlaneCollider;
import net.java.dev.joode.collision.collider.CapsuleSphereCollider;
import net.java.dev.joode.collision.collider.CircleCircleCollider;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.CylinderPlaneCollider;
import net.java.dev.joode.collision.collider.GeomTransformCollider;
import net.java.dev.joode.collision.collider.RayBoxCollider;
import net.java.dev.joode.collision.collider.RayCapsuleCollider;
import net.java.dev.joode.collision.collider.RayCircleCollider;
import net.java.dev.joode.collision.collider.RayPlaneCollider;
import net.java.dev.joode.collision.collider.RayRectangleCollider;
import net.java.dev.joode.collision.collider.RaySphereCollider;
import net.java.dev.joode.collision.collider.RectangleCircleCollider;
import net.java.dev.joode.collision.collider.RectangleRectangleCollider;
import net.java.dev.joode.collision.collider.SpaceGeomCollider;
import net.java.dev.joode.collision.collider.SphereBoxCollider;
import net.java.dev.joode.collision.collider.SpherePlaneCollider;
import net.java.dev.joode.collision.collider.SphereSphereCollider;
import net.java.dev.joode.collision.collider.TriMeshBoxCollider;
import net.java.dev.joode.collision.collider.TriMeshCapsuleCollider;
import net.java.dev.joode.collision.collider.TriMeshSphereCollider;
import net.java.dev.joode.collision.collider.TriMeshTriMeshCollider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class Colliders {
    private static int[] avail = new int[8];
    private static float[] A2c = new float[8];
    public static final Colliders INSTANCE = new Colliders();
    public final ColliderEntry[][] colliders = new ColliderEntry[20][20];

    private void setCollider(int i, int j, Collider collider) {
        if (collider == null) {
            throw new NullPointerException("collider must not be null");
        }
        if (this.colliders[i][j] == null) {
            this.colliders[i][j] = new ColliderEntry(collider, false);
        }
        if (this.colliders[j][i] == null) {
            this.colliders[j][i] = new ColliderEntry(collider, true);
        }
    }

    private void setAllColliders(int i, Collider fn) {
        int j = 0;
        while (j < 20) {
            this.setCollider(i, j, fn);
            ++j;
        }
    }

    private Colliders() {
        int i = 11;
        while (i <= 15) {
            int j = 0;
            while (j < 20) {
                this.setCollider(i, j, SpaceGeomCollider.INSTANCE);
                ++j;
            }
            ++i;
        }
        this.setCollider(0, 0, SphereSphereCollider.INSTANCE);
        this.setCollider(0, 1, SphereBoxCollider.INSTANCE);
        this.setCollider(0, 4, SpherePlaneCollider.INSTANCE);
        this.setCollider(1, 1, BoxBoxCollider.INSTANCE);
        this.setCollider(1, 4, BoxPlaneCollider.INSTANCE);
        this.setCollider(2, 0, CapsuleSphereCollider.INSTANCE);
        this.setCollider(2, 1, CapsuleBoxCollider.INSTANCE);
        this.setCollider(2, 2, CapsuleCapsuleCollider.INSTANCE);
        this.setCollider(2, 4, CapsulePlaneCollider.INSTANCE);
        this.setCollider(5, 0, RaySphereCollider.INSTANCE);
        this.setCollider(5, 1, RayBoxCollider.INSTANCE);
        this.setCollider(5, 2, RayCapsuleCollider.INSTANCE);
        this.setCollider(5, 4, RayPlaneCollider.INSTANCE);
        this.setCollider(3, 4, CylinderPlaneCollider.INSTANCE);
        this.setCollider(9, 9, CircleCircleCollider.INSTANCE);
        this.setCollider(5, 9, RayCircleCollider.INSTANCE);
        this.setCollider(10, 10, RectangleRectangleCollider.INSTANCE);
        this.setCollider(10, 9, RectangleCircleCollider.INSTANCE);
        this.setCollider(5, 10, RayRectangleCollider.INSTANCE);
        this.setCollider(8, 8, TriMeshTriMeshCollider.INSTANCE);
        this.setCollider(8, 0, TriMeshSphereCollider.INSTANCE);
        this.setCollider(8, 1, TriMeshBoxCollider.INSTANCE);
        this.setCollider(8, 2, TriMeshCapsuleCollider.INSTANCE);
        this.setAllColliders(6, GeomTransformCollider.INSTANCE);
    }

    public static int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, boolean ignoreStatic) {
        int count;
        if (o1 == o2) {
            return 0;
        }
        if (o1.getBody() == o2.getBody() && o1.getBody() != null) {
            return 0;
        }
        if (ignoreStatic && (o1.getBody() == null && o2.getBody() == null || o1.getBody() != null && !o1.getBody().isEnabled() && !o1.getBody().isAutoDisabled() || o2.getBody() != null && !o2.getBody().isEnabled() && !o2.getBody().isAutoDisabled())) {
            return 0;
        }
        ColliderEntry ce = Colliders.INSTANCE.colliders[o1.getType()][o2.getType()];
        if (ce == null) {
            JOODELog.error("No collider defined between: ", o1, " & ", o2);
            return 0;
        }
        if (ce.getReverse()) {
            count = ce.getCollider().collide(o2, o1, contact, contactIndex, ignoreStatic ? 1 : 0);
            int i = 0;
            while (i < count) {
                ContactGeom c = contact[contactIndex + i];
                c.getNormal().negate();
                Geom tmp = c.getGeom1();
                c.setGeom1(c.getGeom2());
                c.setGeom2(tmp);
                ++i;
            }
        } else {
            count = ce.getCollider().collide(o1, o2, contact, contactIndex, ignoreStatic ? 1 : 0);
        }
        return count;
    }

    public static float[] lineClosestApproach(Vector3 pa, Vector3 ua, Vector3 pb, Vector3 ub) {
        float beta;
        float alpha;
        Vector3 P0minusP1 = Vector3.pool.aquire();
        P0minusP1.set(pa);
        P0minusP1.sub(pb);
        float a = ua.dot(ua);
        float b = ua.dot(ub);
        float c = ub.dot(ub);
        float d = ua.dot(P0minusP1);
        float e = ub.dot(P0minusP1);
        float denominator = a * c - b * b;
        if (Vector3.epsilonEquals(denominator, 0.0f, 1.0E-5f)) {
            alpha = 0.0f;
            beta = -d / a;
        } else {
            alpha = (b * e - c * d) / denominator;
            beta = (a * e - b * d) / denominator;
        }
        return new float[]{alpha, beta};
    }

    public static void closestPointLineSegments(Vector3 pa, Vector3 ua, Vector3 pb, Vector3 ub, Vector3 px, Vector3 ux) {
        float sDenom;
        float tDenom;
        float tNum;
        float sNum;
        Vector3 u = Vector3.pool.aquire();
        u.set(pa);
        u.sub(pb);
        float a = ua.dot(ua);
        float b = ua.dot(ub);
        float c = ub.dot(ub);
        float d = ua.dot(u);
        float e = ub.dot(u);
        float det = a * c - b * b;
        if (Vector3.epsilonEquals(det, 0.0f, 0.001f)) {
            sNum = 0.0f;
            tNum = e;
            tDenom = c;
            sDenom = det;
        } else {
            sNum = b * e - c * d;
            tNum = a * e - b * d;
        }
        sDenom = det;
        if (sNum < 0.0f) {
            sNum = 0.0f;
            tNum = e;
            tDenom = c;
        } else if (sNum > det) {
            sNum = det;
            tNum = e + b;
            tDenom = c;
        } else {
            tDenom = det;
        }
        if (tNum < 0.0f) {
            tNum = 0.0f;
            if (-d < 0.0f) {
                sNum = 0.0f;
            } else if (-d > a) {
                sNum = sDenom;
            } else {
                sNum = -d;
                sDenom = a;
            }
        } else if (tNum > tDenom) {
            tNum = tDenom;
            if (-d + b < 0.0f) {
                sNum = 0.0f;
            } else if (-d + b > a) {
                sNum = sDenom;
            } else {
                sNum = -d + b;
                sDenom = a;
            }
        }
        float s = sNum == 0.0f && sDenom == 0.0f ? 0.0f : sNum / sDenom;
        float t = tDenom == 0.0f && tNum == 0.0f ? 0.0f : tNum / tDenom;
        px.set(ua);
        px.scale(s);
        px.add(pa);
        ux.set(ub);
        ux.scale(t);
        ux.add(pb);
        ux.sub(px);
    }

    public static void closestLineSegmentPoints(Vector3 a1, Vector3 a2, Vector3 b1, Vector3 b2, Vector3 cp1, Vector3 cp2) {
        float k;
        float det;
        Vector3 n;
        Vector3 kb1b2;
        Vector3 n2;
        Vector3 ka1a2;
        float k2;
        Vector3 a1a2 = new Vector3(a2);
        a1a2.sub(a1);
        Vector3 b1b2 = new Vector3(b2);
        b1b2.sub(b1);
        Vector3 a1b1 = new Vector3(b1);
        a1b1.sub(a1);
        float da1 = a1a2.dot(a1b1);
        float db1 = b1b2.dot(a1b1);
        if (da1 <= 0.0f && db1 >= 0.0f) {
            cp1.set(a1);
            cp2.set(b1);
            return;
        }
        Vector3 a1b2 = new Vector3(b2);
        a1b2.sub(a1);
        float da2 = a1a2.dot(a1b2);
        float db2 = b1b2.dot(a1b2);
        if (da2 <= 0.0f && db2 <= 0.0f) {
            cp1.set(a1);
            cp2.set(b2);
            return;
        }
        Vector3 a2b1 = new Vector3(b1);
        a2b1.sub(a2);
        float da3 = a1a2.dot(a2b1);
        float db3 = b1b2.dot(a2b1);
        if (da3 >= 0.0f && db3 >= 0.0f) {
            cp1.set(a2);
            cp2.set(b1);
            return;
        }
        Vector3 a2b2 = new Vector3(b2);
        a2b2.sub(a2);
        float da4 = a1a2.dot(a2b2);
        float db4 = b1b2.dot(a2b2);
        if (da4 >= 0.0f && db4 <= 0.0f) {
            cp1.set(a2);
            cp2.set(b2);
            return;
        }
        float la = a1a2.lengthSquared();
        if (da1 >= 0.0f && da3 <= 0.0f) {
            k2 = da1 / la;
            ka1a2 = new Vector3(a1a2);
            ka1a2.scale(k2);
            n2 = new Vector3(a1b1);
            n2.sub(ka1a2);
            if (b1b2.dot(n2) >= 0.0f) {
                Vector3 t = new Vector3(a1);
                t.add(ka1a2);
                cp1.set(t);
                cp2.set(b1);
                return;
            }
        }
        if (da2 >= 0.0f && da4 <= 0.0f) {
            k2 = da2 / la;
            ka1a2 = new Vector3(a1a2);
            ka1a2.scale(k2);
            n2 = new Vector3(a1b2);
            n2.sub(ka1a2);
            if (b1b2.dot(n2) <= 0.0f) {
                Vector3 t = new Vector3(a1);
                t.add(ka1a2);
                cp1.set(t);
                cp2.set(b2);
                return;
            }
        }
        float lb = b1b2.lengthSquared();
        if (db1 <= 0.0f && db2 >= 0.0f) {
            float k3 = -db1 / lb;
            kb1b2 = new Vector3(b1b2);
            kb1b2.scale(k3);
            n = new Vector3(a1b1);
            n.scale(-1.0f);
            n.sub(kb1b2);
            if (a1a2.dot(n) >= 0.0f) {
                cp1.set(a1);
                Vector3 t = new Vector3(b1);
                t.add(kb1b2);
                cp2.set(t);
                return;
            }
        }
        if (db3 <= 0.0f && db4 >= 0.0f) {
            float k4 = -db3 / lb;
            kb1b2 = new Vector3(b1b2);
            kb1b2.scale(k4);
            n = new Vector3(a2b1);
            n.scale(-1.0f);
            n.sub(kb1b2);
            if (a1a2.dot(n) <= 0.0f) {
                cp1.set(a2);
                Vector3 t = new Vector3(b1);
                t.add(kb1b2);
                cp2.set(t);
                return;
            }
        }
        if ((det = la * lb - (k = a1a2.dot(b1b2)) * k) <= 0.0f) {
            cp1.set(a1);
            cp2.set(b1);
            return;
        }
        det = 1.0f / det;
        float alpha = (lb * da1 - k * db1) * det;
        float beta = (k * da1 - la * db1) * det;
        Vector3 aa1a2 = new Vector3(a1a2);
        aa1a2.scale(alpha);
        cp1.set(new Vector3(a1));
        cp1.add(aa1a2);
        Vector3 bb1b2 = new Vector3(b1b2);
        bb1b2.scale(beta);
        cp2.set(new Vector3(b1));
        cp2.add(bb1b2);
    }

    public static void closestLineBoxPoints(Vector3 p1, Vector3 p2, Vector3 c, Matrix3 R, Vector3 side, Vector3 lret, Vector3 bret) {
        Vector3 tmp = new Vector3(p1);
        tmp.sub(c);
        Vector3 s = new Vector3();
        MathUtils.dMULTIPLY1_331(s, R, tmp);
        tmp.set(p2);
        tmp.sub(p1);
        Vector3 v = new Vector3();
        MathUtils.dMULTIPLY1_331(v, R, tmp);
        int[] sign = new int[3];
        int i = 0;
        while (i < 3) {
            if (v.m[i] < 0.0f) {
                s.m[i] = -s.m[i];
                v.m[i] = -v.m[i];
                sign[i] = -1;
            } else {
                sign[i] = 1;
            }
            ++i;
        }
        Vector3 v2 = new Vector3();
        v2.m[0] = v.m[0] * v.m[0];
        v2.m[1] = v.m[1] * v.m[1];
        v2.m[2] = v.m[2] * v.m[2];
        float[] h = new float[]{0.5f * side.m[0], 0.5f * side.m[1], 0.5f * side.m[2]};
        int[] region = new int[3];
        float[] tanchor = new float[3];
        i = 0;
        while (i < 3) {
            if (v.m[i] > 0.0f) {
                if (s.m[i] < -h[i]) {
                    region[i] = -1;
                    tanchor[i] = (-h[i] - s.m[i]) / v.m[i];
                } else {
                    region[i] = s.m[i] > h[i] ? 1 : 0;
                    tanchor[i] = (h[i] - s.m[i]) / v.m[i];
                }
            } else {
                region[i] = 0;
                tanchor[i] = 2.0f;
            }
            ++i;
        }
        float t = 0.0f;
        float dd2dt = 0.0f;
        i = 0;
        while (i < 3) {
            dd2dt -= (region[i] != 0 ? v2.m[i] : 0.0f) * tanchor[i];
            ++i;
        }
        if (dd2dt < 0.0f) {
            boolean got_answer = false;
            do {
                float next_t = 1.0f;
                i = 0;
                while (i < 3) {
                    if (tanchor[i] > t && tanchor[i] < 1.0f && tanchor[i] < next_t) {
                        next_t = tanchor[i];
                    }
                    ++i;
                }
                float next_dd2dt = 0.0f;
                i = 0;
                while (i < 3) {
                    next_dd2dt += (region[i] != 0 ? v2.m[i] : 0.0f) * (next_t - tanchor[i]);
                    ++i;
                }
                if (next_dd2dt >= 0.0f) {
                    float m = (next_dd2dt - dd2dt) / (next_t - t);
                    t -= dd2dt / m;
                    got_answer = true;
                    continue;
                }
                i = 0;
                while (i < 3) {
                    if (tanchor[i] == next_t) {
                        tanchor[i] = (h[i] - s.m[i]) / v.m[i];
                        int n = i;
                        region[n] = region[n] + 1;
                    }
                    ++i;
                }
                t = next_t;
                dd2dt = next_dd2dt;
            } while (t < 1.0f && !got_answer);
            if (!got_answer) {
                t = 1.0f;
            }
        }
        i = 0;
        while (i < 3) {
            lret.m[i] = p1.m[i] + t * tmp.m[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            tmp.m[i] = (float)sign[i] * (s.m[i] + t * v.m[i]);
            if (tmp.m[i] < -h[i]) {
                tmp.m[i] = -h[i];
            } else if (tmp.m[i] > h[i]) {
                tmp.m[i] = h[i];
            }
            ++i;
        }
        MathUtils.dMULTIPLY0_331((Real)s, R, (Real)tmp);
        i = 0;
        while (i < 3) {
            bret.m[i] = s.m[i] + c.m[i];
            ++i;
        }
    }

    public static int intersectRectQuad(float[] h, float[] p, float[] ret) {
        int nq = 4;
        int nr = 0;
        float[] buffer = new float[16];
        float[] q = p;
        float[] r = ret;
        boolean done = false;
        int dir = 0;
        while (dir <= 1 && !done) {
            int sign = -1;
            while (sign <= 1 && !done) {
                float[] pq = q;
                float[] pr = r;
                int prIdx = 0;
                int pqIdx = 0;
                nr = 0;
                int i = nq;
                while (i > 0) {
                    float[] nextq;
                    if ((float)sign * pq[dir + pqIdx] < h[dir]) {
                        pr[prIdx] = pq[pqIdx];
                        pr[prIdx + 1] = pq[pqIdx + 1];
                        prIdx += 2;
                        if ((++nr & 8) != 0) {
                            q = r;
                            done = true;
                            break;
                        }
                    }
                    if (i > 1) {
                        int n = pq.length - pqIdx - 2;
                        nextq = new float[n];
                        System.arraycopy(pq, pqIdx + 2, nextq, 0, n);
                    } else {
                        nextq = q;
                    }
                    if ((float)sign * pq[pqIdx + dir] < h[dir] ^ (float)sign * nextq[dir] < h[dir]) {
                        pr[prIdx + 1 - dir] = pq[pqIdx + 1 - dir] + (nextq[1 - dir] - pq[pqIdx + 1 - dir]) / (nextq[dir] - pq[pqIdx + dir]) * ((float)sign * h[dir] - pq[pqIdx + dir]);
                        pr[prIdx + dir] = (float)sign * h[dir];
                        prIdx += 2;
                        if ((++nr & 8) != 0) {
                            q = r;
                            done = true;
                            break;
                        }
                    }
                    pqIdx += 2;
                    --i;
                }
                q = r;
                r = q == ret ? buffer : ret;
                nq = nr;
                sign += 2;
            }
            ++dir;
        }
        if (q != ret) {
            System.arraycopy(q, 0, ret, 0, nr * 2);
        }
        return nr;
    }

    public static void cullPoints(int n, float[] p, int m, int i0, int[] iret) {
        int i;
        float a;
        float cy;
        float cx;
        int iretIndex = 0;
        if (n == 1) {
            cx = p[0];
            cy = p[1];
        } else if (n == 2) {
            cx = 0.5f * (p[0] + p[2]);
            cy = 0.5f * (p[1] + p[3]);
        } else {
            float q;
            a = 0.0f;
            cx = 0.0f;
            cy = 0.0f;
            i = 0;
            while (i < n - 1) {
                q = p[i * 2] * p[i * 2 + 3] - p[i * 2 + 2] * p[i * 2 + 1];
                a += q;
                cx += q * (p[i * 2] + p[i * 2 + 2]);
                cy += q * (p[i * 2 + 1] + p[i * 2 + 3]);
                ++i;
            }
            q = p[n * 2 - 2] * p[1] - p[0] * p[n * 2 - 1];
            a = 1.0f / (3.0f * (a + q));
            cx = a * (cx + q * (p[n * 2 - 2] + p[0]));
            cy = a * (cy + q * (p[n * 2 - 1] + p[1]));
        }
        i = 0;
        while (i < n) {
            Colliders.A2c[i] = (float)Math.atan2(p[i * 2 + 1] - cy, p[i * 2] - cx);
            ++i;
        }
        i = 0;
        while (i < n) {
            Colliders.avail[i] = 1;
            ++i;
        }
        Colliders.avail[i0] = 0;
        iret[0 + iretIndex] = i0;
        ++iretIndex;
        int j = 1;
        while (j < m) {
            a = (float)((double)j * (Math.PI * 2 / (double)m) + (double)A2c[i0]);
            if ((double)a > Math.PI) {
                a = (float)((double)a - Math.PI * 2);
            }
            float maxdiff = 1.0E9f;
            iret[iretIndex] = i0;
            i = 0;
            while (i < n) {
                if (avail[i] != 0) {
                    float diff = Math.abs(A2c[i] - a);
                    if ((double)diff > Math.PI) {
                        diff = (float)(Math.PI * 2 - (double)diff);
                    }
                    if (diff < maxdiff) {
                        maxdiff = diff;
                        iret[iretIndex] = i;
                    }
                }
                ++i;
            }
            if (iret[iretIndex] == i0) {
                throw new IllegalArgumentException("Colliders.cullPoints: iret didn't get set!");
            }
            Colliders.avail[iret[iretIndex]] = 0;
            ++iretIndex;
            ++j;
        }
    }

    private class ColliderEntry {
        private final Collider collider;
        private final boolean reverse;

        public final Collider getCollider() {
            return this.collider;
        }

        public final boolean getReverse() {
            return this.reverse;
        }

        public ColliderEntry(Collider collider, boolean reverse) {
            this.collider = collider;
            this.reverse = reverse;
        }
    }
}

