/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.RaySphereCollider;
import net.java.dev.joode.geom.Capsule;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class RayCapsuleCollider
extends Collider {
    public static final RayCapsuleCollider INSTANCE = new RayCapsuleCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Ray ray = (Ray)o1;
        Capsule ccyl = (Capsule)o2;
        Vector3 rayPos = ray.getPosition();
        Matrix3 rayRot = ray.getRotation();
        Vector3 ccylPos = ccyl.getPosition();
        Matrix3 ccylRot = ccyl.getRotation();
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(ccyl);
        float lz2 = ccyl.getLength() * 0.5f;
        Vector3 cs = new Vector3(rayPos);
        cs.sub(ccylPos);
        float k = cs.dot(ccylRot.getColumn(2));
        Vector3 q = new Vector3();
        q.setX(k * ccylRot.m[2] - cs.getX());
        q.setY(k * ccylRot.m[6] - cs.getY());
        q.setZ(k * ccylRot.m[10] - cs.getZ());
        float C = q.lengthSquared() - ccyl.getRadius() * ccyl.getRadius();
        Vector3 r = new Vector3();
        boolean inside_ccyl = false;
        if (C < 0.0f) {
            if (k < -lz2) {
                k = -lz2;
            } else if (k > lz2) {
                k = lz2;
            }
            r.setX(ccylPos.getX() + k * ccylRot.m[2]);
            r.setY(ccylPos.getY() + k * ccylRot.m[6]);
            r.setZ(ccylPos.getZ() + k * ccylRot.m[10]);
            if ((rayPos.getX() - r.getX()) * (rayPos.getX() - r.getX()) + (rayPos.getY() - r.getY()) * (rayPos.getY() - r.getY()) + (rayPos.getZ() - r.getZ()) * (rayPos.getZ() - r.getZ()) < ccyl.getRadius() * ccyl.getRadius()) {
                inside_ccyl = true;
            }
        }
        if (!inside_ccyl && C < 0.0f) {
            k = k < 0.0f ? -lz2 : lz2;
        } else {
            float uv = ccylRot.getColumn(2).dot(rayRot.getColumn(2));
            r.setX(uv * ccylRot.m[2] - rayRot.m[2]);
            r.setY(uv * ccylRot.m[6] - rayRot.m[6]);
            r.setZ(uv * ccylRot.m[10] - rayRot.m[10]);
            float A = r.lengthSquared();
            float B = 2.0f * q.dot(r);
            k = B * B - 4.0f * A * C;
            if (k < 0.0f) {
                if (!inside_ccyl) {
                    return 0;
                }
                k = uv < 0.0f ? -lz2 : lz2;
            } else {
                int nsign;
                float alpha = (-B - (k = FastMath.sqrt(k))) * (A = 1.0f / (2.0f * A));
                if (alpha < 0.0f && (alpha = (-B + k) * A) < 0.0f) {
                    return 0;
                }
                if (alpha > ray.getLength()) {
                    return 0;
                }
                contact[contactIndex].getPosition().setX(rayPos.getX() + alpha * rayRot.m[2]);
                contact[contactIndex].getPosition().setY(rayPos.getY() + alpha * rayRot.m[6]);
                contact[contactIndex].getPosition().setZ(rayPos.getZ() + alpha * rayRot.m[10]);
                q.setX(contact[contactIndex].getPosition().getX() - ccylPos.getX());
                q.setY(contact[contactIndex].getPosition().getY() - ccylPos.getY());
                q.setZ(contact[contactIndex].getPosition().getZ() - ccylPos.getZ());
                k = q.dot(ccylRot.getColumn(2));
                int n = nsign = inside_ccyl ? -1 : 1;
                if (k >= -lz2 && k <= lz2) {
                    contact[contactIndex].getNormal().setX((float)nsign * (contact[contactIndex].getPosition().getX() - (ccylPos.getX() + k * ccylRot.m[2])));
                    contact[contactIndex].getNormal().setY((float)nsign * (contact[contactIndex].getPosition().getY() - (ccylPos.getY() + k * ccylRot.m[6])));
                    contact[contactIndex].getNormal().setZ((float)nsign * (contact[contactIndex].getPosition().getZ() - (ccylPos.getZ() + k * ccylRot.m[10])));
                    contact[contactIndex].getNormal().normalize();
                    contact[contactIndex].setDepth(alpha);
                    return 1;
                }
                k = k < 0.0f ? -lz2 : lz2;
            }
        }
        q.setX(ccylPos.getX() + k * ccylRot.m[2]);
        q.setY(ccylPos.getY() + k * ccylRot.m[6]);
        q.setZ(ccylPos.getZ() + k * ccylRot.m[10]);
        return RaySphereCollider.ray_sphere_helper(ray, q, ccyl.getRadius(), contact, contactIndex, inside_ccyl);
    }
}

