/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.geom.Rectangle;
import net.java.dev.joode.util.ParametricSegment2D;
import net.java.dev.joode.util.Vector2;
import net.java.dev.joode.util.Vector3;

public class RayRectangleCollider
extends Collider {
    public static final RayRectangleCollider INSTANCE = new RayRectangleCollider();
    public static final ParametricSegment2D ray2D = new ParametricSegment2D();
    public static final ParametricSegment2D[] e = new ParametricSegment2D[4];
    public static final Vector2[] pts = new Vector2[4];
    public static final Vector2[] intersections = new Vector2[4];

    static {
        int i = 0;
        while (i < 4) {
            RayRectangleCollider.pts[i] = new Vector2();
            RayRectangleCollider.e[i] = new ParametricSegment2D();
            ++i;
        }
    }

    private RayRectangleCollider() {
    }

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Ray ray = (Ray)o1;
        Rectangle rect = (Rectangle)o2;
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(rect);
        return this.collideRayRectangle(ray, rect, contact, contactIndex);
    }

    public int collideRayRectangle(Ray ray, Rectangle rect, ContactGeom[] contacts, int contacIndex) {
        Vector3 rayPos = ray.getPosition();
        float depth = rect.pointDepth(rayPos.getX(), rayPos.getY(), rayPos.getZ());
        if (depth > 0.0f) {
            contacts[contacIndex].setDepth(depth);
            contacts[contacIndex].setNormal(0.0f, 0.0f, 1.0f);
            contacts[contacIndex].setPosition(rayPos.getX(), rayPos.getY(), 0.0f);
            return 1;
        }
        return 0;
    }
}

