/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Sphere;
import net.java.dev.joode.util.Vector3;

public class SphereSphereCollider
extends Collider {
    public static final SphereSphereCollider INSTANCE = new SphereSphereCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Sphere sphere1 = (Sphere)o1;
        Sphere sphere2 = (Sphere)o2;
        contact[contactIndex].setGeom1(o1);
        contact[contactIndex].setGeom2(o2);
        return SphereSphereCollider.collideSpheres(o1.getPosition(), sphere1.getRadius(), o2.getPosition(), sphere2.getRadius(), contact, contactIndex, sphere1.hashCode(), sphere2.hashCode());
    }

    public static int collideSpheres(Vector3 p1, float r1, Vector3 p2, float r2, ContactGeom[] c, int contactIndex, int hash1, int hash2) {
        float d = p1.dist(p2);
        if (d > r1 + r2) {
            return 0;
        }
        if (d <= 0.0f) {
            c[contactIndex].setPosition(p1.m[0], p1.m[1], p1.m[2]);
            if (hash1 > hash2) {
                c[contactIndex].setNormal(1.0f, 0.0f, 0.0f);
            } else {
                c[contactIndex].setNormal(-1.0f, 0.0f, 0.0f);
            }
            c[contactIndex].setDepth(r1 + r2);
        } else {
            float d1 = 1.0f / d;
            c[contactIndex].getNormal().m[0] = (p1.m[0] - p2.m[0]) * d1;
            c[contactIndex].getNormal().m[1] = (p1.m[1] - p2.m[1]) * d1;
            c[contactIndex].getNormal().m[2] = (p1.m[2] - p2.m[2]) * d1;
            float k = 0.5f * (r2 - r1 - d);
            c[contactIndex].getPosition().m[0] = p1.m[0] + c[contactIndex].getNormal().m[0] * k;
            c[contactIndex].getPosition().m[1] = p1.m[1] + c[contactIndex].getNormal().m[1] * k;
            c[contactIndex].getPosition().m[2] = p1.m[2] + c[contactIndex].getNormal().m[2] * k;
            c[contactIndex].setDepth(r1 + r2 - d);
        }
        return 1;
    }
}

