/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.force;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.force.BodyForce;
import net.java.dev.joode.util.Vector3;

public class Spring
extends BodyForce {
    private static final long serialVersionUID = -5993228372532340253L;
    private static final Vector3 global_anchor = new Vector3();
    private static final Vector3 displacement = new Vector3();
    private static final Vector3 velocity = new Vector3();
    private static final Vector3 force = new Vector3();
    private static final Vector3 direction = new Vector3();
    private final Vector3 bodyRelAnchor = new Vector3();
    private final Vector3 spaceAnchor = new Vector3();
    private float k_spring;
    private float k_damp;

    public Spring(Body body, float k_spring, float k_damp) {
        super(body);
        this.k_damp = k_damp;
        this.k_spring = k_spring;
    }

    public final void setBodyRelAnchor(Vector3 value) {
        this.bodyRelAnchor.set(value);
    }

    public final void setBodyRelAnchor(float x, float y, float z) {
        this.bodyRelAnchor.set(x, y, z);
    }

    public final Vector3 getBodyRelAnchor() {
        return this.bodyRelAnchor;
    }

    public final void setSpaceAnchor(Vector3 value) {
        this.spaceAnchor.set(value);
    }

    public final void setSpaceAnchor(float x, float y, float z) {
        this.spaceAnchor.set(x, y, z);
    }

    public final Vector3 getSpaceAnchor() {
        return this.spaceAnchor;
    }

    public final float getKSpring() {
        return this.k_spring;
    }

    public final float getKDamp() {
        return this.k_damp;
    }

    public void applyForce(float t, Vector3 faccAccumulator, Vector3 taccAccumulator) {
        global_anchor.set(this.getBody().getPosition());
        this.getBody().getRotation().mulInc(this.bodyRelAnchor, global_anchor);
        displacement.set(global_anchor);
        displacement.sub(this.spaceAnchor);
        direction.set(displacement);
        direction.normalize();
        this.getBody().getVelocityAt(global_anchor, velocity);
        float velocityComponent = velocity.dot(direction);
        velocity.set(direction);
        velocity.scale(velocityComponent);
        displacement.scale(-this.k_spring);
        velocity.scale(-this.k_damp);
        force.set(displacement);
        force.add(velocity);
        this.getBody().addForceAtPos(force.getX(), force.getY(), force.getZ(), global_anchor.getX(), global_anchor.getY(), global_anchor.getZ(), faccAccumulator, taccAccumulator);
    }

    public Spring cloneState(ClonedReferences util) {
        Spring clone = new Spring(this.getBody(), this.k_spring, this.k_damp);
        util.addClone(this, clone);
        super.partialCloneWorldObject(clone, util);
        clone.bodyRelAnchor.set(this.bodyRelAnchor);
        return clone;
    }
}

