/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class Box
extends Geom {
    private static final long serialVersionUID = 6728403824541923859L;
    private Vector3 side;

    public Box(Space space, Vector3 side) {
        super(space, 1, true);
        assert (side.getX() > 0.0f) : "side.x must be greater than zero";
        assert (side.getY() > 0.0f) : "side.y must be greater than zero";
        assert (side.getZ() > 0.0f) : "side.z must be greater than zero";
        this.side = side;
        if (space != null) {
            space.add(this);
        }
    }

    private Box() {
        super(1, true);
    }

    public Box(Space space, float x, float y, float z) {
        this(space, new Vector3(x, y, z));
    }

    public final void setSide(Vector3 side) {
        this.side = side;
        Space.onGeomMoved(this);
    }

    public final void setSide(float x, float y, float z) {
        this.side.setX(x);
        this.side.setY(y);
        this.side.setZ(z);
        Space.onGeomMoved(this);
    }

    public final Vector3 getSide() {
        return this.side;
    }

    public void computeAABB() {
        Vector3 pos = this.getPosition();
        Matrix3 rot = this.getRotation();
        float xrange = 0.5f * (Math.abs(rot.get(0, 0) * this.side.getX()) + Math.abs(rot.get(1, 0) * this.side.getY()) + Math.abs(rot.get(2, 0) * this.side.getZ()));
        float yrange = 0.5f * (Math.abs(rot.get(0, 1) * this.side.getX()) + Math.abs(rot.get(1, 1) * this.side.getY()) + Math.abs(rot.get(2, 1) * this.side.getZ()));
        float zrange = 0.5f * (Math.abs(rot.get(0, 2) * this.side.getX()) + Math.abs(rot.get(1, 2) * this.side.getY()) + Math.abs(rot.get(2, 2) * this.side.getZ()));
        this.getAABB().set(pos.getX() - xrange, pos.getX() + xrange, pos.getY() - yrange, pos.getY() + yrange, pos.getZ() - zrange, pos.getZ() + zrange);
    }

    public float pointDepth(float x, float y, float z) {
        Vector3 pos = this.getPosition();
        Vector3 p = new Vector3(x - pos.getX(), y - pos.getY(), z - pos.getZ());
        Vector3 q = new Vector3();
        MathUtils.dMULTIPLY1_331(q, this.getRotation(), p);
        float[] dist = new float[6];
        boolean inside = true;
        int i = 0;
        while (i < 3) {
            float s = this.side.get(i) * 0.5f;
            dist[i] = s - q.get(i);
            dist[i + 3] = s + q.get(i);
            if (dist[i] < 0.0f || dist[i + 3] < 0.0f) {
                inside = false;
            }
            ++i;
        }
        if (inside) {
            float smallest_dist = Float.MAX_VALUE;
            i = 0;
            while (i < 6) {
                if (dist[i] < smallest_dist) {
                    smallest_dist = dist[i];
                }
                ++i;
            }
            return smallest_dist;
        }
        float largest_dist = 0.0f;
        i = 0;
        while (i < 6) {
            if (dist[i] > largest_dist) {
                largest_dist = dist[i];
            }
            ++i;
        }
        return -largest_dist;
    }

    public Box cloneState(ClonedReferences util) {
        Box clone = new Box();
        this.clonePartialGeom(clone, util);
        clone.side = new Vector3();
        clone.side.set(this.side);
        return clone;
    }
}

