/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.collision.Contact;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class JointContact
extends Joint {
    private static final long serialVersionUID = -1873530910338731001L;
    public static final Vector3 lvel = new Vector3();
    public static final Vector3 avel = new Vector3();
    private static Vector3 normal = new Vector3();
    private static Vector3 c1 = new Vector3();
    private static Vector3 c2 = new Vector3();
    private static Vector3 t1 = new Vector3();
    private static Vector3 t2tmp = new Vector3();
    private int the_m;
    private Contact contact;

    public JointContact(World world, Contact contact) {
        super(world);
        this.contact = contact;
    }

    private JointContact() {
    }

    protected void init() {
    }

    public final void setContact(Contact contact) {
        this.contact = contact;
    }

    public final Contact getContact() {
        return this.contact;
    }

    public void getInfo1(Joint.Info1 info) {
        int m = 1;
        int nub = 0;
        if (this.contact.getSurfaceParameters().getMu() < 0.0f) {
            this.contact.getSurfaceParameters().setMu(0.0f);
        }
        if (this.contact.getSurfaceParameters().isModeFlagSet(1)) {
            if (this.contact.getSurfaceParameters().getMu() > 0.0f) {
                ++m;
            }
            if (this.contact.getSurfaceParameters().getMu2() < 0.0f) {
                this.contact.getSurfaceParameters().setMu2(0.0f);
            }
            if (this.contact.getSurfaceParameters().getMu2() > 0.0f) {
                ++m;
            }
            if (this.contact.getSurfaceParameters().getMu() == Float.POSITIVE_INFINITY) {
                ++nub;
            }
            if (this.contact.getSurfaceParameters().getMu2() == Float.POSITIVE_INFINITY) {
                ++nub;
            }
        } else {
            if (this.contact.getSurfaceParameters().getMu() > 0.0f) {
                m += 2;
            }
            if (this.contact.getSurfaceParameters().getMu() == Float.POSITIVE_INFINITY) {
                nub += 2;
            }
        }
        this.the_m = m;
        info.m = m;
        info.nub = nub;
    }

    public void getInfo2(Joint.Info2 info) {
        float maxvel;
        int s = info.rowskip;
        int s2 = 2 * s;
        if (this.getFlag(2)) {
            JointContact.normal.m[0] = -this.contact.getNormal().m[0];
            JointContact.normal.m[1] = -this.contact.getNormal().m[1];
            JointContact.normal.m[2] = -this.contact.getNormal().m[2];
        } else {
            JointContact.normal.m[0] = this.contact.getNormal().m[0];
            JointContact.normal.m[1] = this.contact.getNormal().m[1];
            JointContact.normal.m[2] = this.contact.getNormal().m[2];
        }
        int i = 0;
        while (i < 3) {
            JointContact.c1.m[i] = this.contact.getPosition().m[i] - this.getBody((int)0).getPosition().m[i];
            ++i;
        }
        info.J1l.setValue(0, JointContact.normal.m[0]);
        info.J1l.setValue(1, JointContact.normal.m[1]);
        info.J1l.setValue(2, JointContact.normal.m[2]);
        c1.cross(normal, info.J1a);
        if (this.getBody(1) != null) {
            i = 0;
            while (i < 3) {
                JointContact.c2.m[i] = this.contact.getPosition().m[i] - this.getBody((int)1).getPosition().m[i];
                ++i;
            }
            info.J2l.setValue(0, -JointContact.normal.m[0]);
            info.J2l.setValue(1, -JointContact.normal.m[1]);
            info.J2l.setValue(2, -JointContact.normal.m[2]);
            MathUtils.dCROSS_EQUAL_MINUS(info.J2a, c2, normal);
        }
        if (this.contact.getSurfaceParameters().isModeFlagSet(8)) {
            info.erp = this.contact.getSurfaceParameters().getSoftERP();
        }
        float k = info.fps * info.erp;
        float depth = this.contact.getDepth() - this.getWorld().getContactParameters().getMinDepth();
        if (depth < 0.0f) {
            depth = 0.0f;
        }
        if (k * depth > (maxvel = this.getWorld().getContactParameters().getMaxVelocity())) {
            info.c.setValue(0, maxvel);
        } else {
            info.c.setValue(0, k * depth);
        }
        if (this.contact.getSurfaceParameters().isModeFlagSet(16)) {
            info.cfm.setValue(0, this.contact.getSurfaceParameters().getSoftCFM());
        } else {
            info.cfm.setValue(0, this.getWorld().getGlobalCFM());
        }
        if (this.contact.getSurfaceParameters().isModeFlagSet(4)) {
            float newc;
            float outgoing = this.getBody(0).getLinearVel().dot(info.J1l) + this.getBody(0).getAngularVel().dot(info.J1a);
            if (this.getBody(1) != null) {
                outgoing += this.getBody(1).getLinearVel().dot(info.J2l) + this.getBody(1).getAngularVel().dot(info.J2a);
            }
            if (this.contact.getSurfaceParameters().getBounceVel() >= 0.0f && -outgoing > this.contact.getSurfaceParameters().getBounceVel() && (newc = -this.contact.getSurfaceParameters().getBounce() * outgoing) > info.c.getValue(0)) {
                info.c.setValue(0, newc);
            }
        }
        info.lo.setValue(0, 0.0f);
        info.hi.setValue(0, Float.POSITIVE_INFINITY);
        Vector3 t2 = null;
        if (this.the_m >= 2) {
            if (this.contact.getSurfaceParameters().isModeFlagSet(2)) {
                JointContact.t1.m[0] = this.contact.getFDir1().m[0];
                JointContact.t1.m[1] = this.contact.getFDir1().m[1];
                JointContact.t1.m[2] = this.contact.getFDir1().m[2];
                t2 = normal.cross(t1);
            } else {
                t2 = t2tmp;
                t2.set(0.0f, 0.0f, 0.0f);
                normal.constructPlaneSpace(t1, t2);
            }
            info.J1l.setValue(s + 0, JointContact.t1.m[0]);
            info.J1l.setValue(s + 1, JointContact.t1.m[1]);
            info.J1l.setValue(s + 2, JointContact.t1.m[2]);
            c1.cross(t1, info.J1a.add(s, RealPointer.tmp));
            if (this.getBody(1) != null) {
                info.J2l.setValue(s + 0, -JointContact.t1.m[0]);
                info.J2l.setValue(s + 1, -JointContact.t1.m[1]);
                info.J2l.setValue(s + 2, -JointContact.t1.m[2]);
                MathUtils.dCROSS_EQUAL_MINUS(info.J2a.add(s, RealPointer.tmp), c2, t1);
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(32)) {
                info.c.setValue(1, this.contact.getSurfaceParameters().getMotion1());
            }
            info.lo.setValue(1, -this.contact.getSurfaceParameters().getMu());
            info.hi.setValue(1, this.contact.getSurfaceParameters().getMu());
            if (this.contact.getSurfaceParameters().isModeFlagSet(4096)) {
                info.findex.setValue(1, 0);
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(128)) {
                info.cfm.setValue(1, this.contact.getSurfaceParameters().getSlip1());
            }
        }
        if (this.the_m >= 3) {
            info.J1l.setValue(s2 + 0, t2.m[0]);
            info.J1l.setValue(s2 + 1, t2.m[1]);
            info.J1l.setValue(s2 + 2, t2.m[2]);
            c1.cross(t2, info.J1a.add(s2, RealPointer.tmp));
            if (this.getBody(1) != null) {
                info.J2l.setValue(s2 + 0, -t2.m[0]);
                info.J2l.setValue(s2 + 1, -t2.m[1]);
                info.J2l.setValue(s2 + 2, -t2.m[2]);
                MathUtils.dCROSS_EQUAL_MINUS(info.J2a.add(s2, RealPointer.tmp), c2, t2);
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(64)) {
                info.c.setValue(2, this.contact.getSurfaceParameters().getMotion2());
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(1)) {
                info.lo.setValue(2, -this.contact.getSurfaceParameters().getMu2());
                info.hi.setValue(2, this.contact.getSurfaceParameters().getMu2());
            } else {
                info.lo.setValue(2, -this.contact.getSurfaceParameters().getMu());
                info.hi.setValue(2, this.contact.getSurfaceParameters().getMu());
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(8192)) {
                info.findex.setValue(2, 0);
            }
            if (this.contact.getSurfaceParameters().isModeFlagSet(256)) {
                info.cfm.setValue(2, this.contact.getSurfaceParameters().getSlip2());
            }
        }
    }

    public String toString() {
        return this.contact.toString();
    }

    public JointContact cloneState(ClonedReferences util) {
        JointContact clone = new JointContact();
        clone.contact = (Contact)util.getClone(this.contact);
        clone.the_m = this.the_m;
        return clone;
    }
}

