/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.force.BodyForce;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Vector3;

public class JointPenalty
extends Joint {
    private static final long serialVersionUID = -6280297459909465768L;
    private static final Vector3 c = new Vector3();
    private static final Vector3 g1 = new Vector3();
    private static final Vector3 g2 = new Vector3();
    private static final Vector3 gAv = new Vector3();
    private static final Matrix3 T = new Matrix3();
    private static final Matrix3 Tinv = new Matrix3();
    private static final Quaternion Tq = new Quaternion();
    private static final Vector3 axis1 = new Vector3();
    private static final Vector3 axis2 = new Vector3();
    private static final Vector3 axis3 = new Vector3();
    private static final Vector3 tmpV = new Vector3();
    private static final Vector3 tmpVa = new Vector3();
    private static final Matrix3 tmpM = new Matrix3();
    private final Quaternion rotQ = new Quaternion();
    private final Vector3 linearK = new Vector3();
    private final Vector3 angularK = new Vector3();
    private final Vector3 anchor1 = new Vector3();
    private final Vector3 anchor2 = new Vector3();
    private final Matrix3 t2 = new Matrix3();
    private final Vector3 force1 = new Vector3();
    private final Vector3 force2 = new Vector3();
    private final Vector3 torque1 = new Vector3();
    private final Vector3 torque2 = new Vector3();
    private float lastCalulationTime = -1.0f;

    public JointPenalty(World world) {
        super(world);
    }

    public final void setRotation(float a, float b, float c, float d) {
        this.rotQ.set(a, b, c, d);
    }

    public final void setRotation(Quaternion rot) {
        this.rotQ.set(rot);
    }

    public final Quaternion getRotation() {
        return this.rotQ;
    }

    public final void setLinearK(float x, float y, float z) {
        this.linearK.set(x, y, z);
    }

    public final void setLinearK(Vector3 linearK) {
        this.linearK.set(linearK);
    }

    public final Vector3 getLinearK() {
        return this.linearK;
    }

    public final void setAngularK(float x, float y, float z) {
        this.angularK.set(x, y, z);
    }

    public final void setAngularK(Vector3 linearK) {
        this.angularK.set(linearK);
    }

    public final Vector3 getAngularK() {
        return this.angularK;
    }

    public final void setAnchor1(float x, float y, float z) {
        this.anchor1.set(x, y, z);
    }

    public final void setAnchor1(Vector3 anchor) {
        this.anchor1.set(anchor);
    }

    public final Vector3 getAnchor1() {
        return this.anchor1;
    }

    public final void setAnchor2(float x, float y, float z) {
        this.anchor2.set(x, y, z);
    }

    public final void setAnchor2(Vector3 anchor) {
        this.anchor2.set(anchor);
    }

    public final Vector3 getAnchor2() {
        return this.anchor2;
    }

    public final void setForce1(Vector3 force) {
        this.force1.set(force);
    }

    public final Vector3 getForce1() {
        return this.force1;
    }

    public final void setForce2(Vector3 force) {
        this.force2.set(force);
    }

    public final Vector3 getForce2() {
        return this.force2;
    }

    public final void setTorque1(Vector3 torque) {
        this.torque1.set(torque);
    }

    public final Vector3 getTorque1() {
        return this.torque1;
    }

    public final void setTorque2(Vector3 torque) {
        this.torque2.set(torque);
    }

    public final Vector3 getTorque2() {
        return this.torque2;
    }

    public void attach(Body body1, Body body2) {
        super.attach(body1, body2);
        new JointForce(this.getBody(0), this, true);
        if (this.getBody(1) != null) {
            new JointForce(this.getBody(1), this, false);
        }
    }

    public void getInfo1(Joint.Info1 info1) {
        info1.nub = 0;
        info1.m = 0;
    }

    public void getInfo2(Joint.Info2 jinfo) {
    }

    public void calculateForces(float t) {
        int i;
        if (t == this.lastCalulationTime) {
            return;
        }
        this.lastCalulationTime = t;
        this.force1.setZero();
        this.force2.setZero();
        this.torque1.setZero();
        this.torque2.setZero();
        if (!Vector3.epsilonEquals(Vector3.ZERO, this.linearK, 1.0E-4f)) {
            this.getAnchor1InGlobalCoords(g1);
            this.getAnchor2InGlobalCoords(g2);
            c.set(g2);
            c.sub(g1);
            if (this.getBody(1) != null) {
                tmpM.set(this.getBody(1).getRotation());
                tmpM.transpose();
                tmpM.mulTranspose(this.t2, T);
            } else {
                T.set(this.t2);
                T.transpose();
            }
            Tinv.set(T);
            Tinv.transpose();
            tmpV.setZero();
            T.mulInc(c, tmpV);
            c.set(tmpV);
            i = 0;
            while (i < 3) {
                int n = i;
                JointPenalty.c.m[n] = JointPenalty.c.m[n] * this.linearK.m[i];
                ++i;
            }
            tmpV.setZero();
            Tinv.mulInc(c, tmpV);
            c.set(tmpV);
            gAv.set(g1);
            gAv.add(g2);
            gAv.scale(0.5f);
            this.getBody(0).addForceAtPos(c.getX(), c.getY(), c.getZ(), gAv.getX(), gAv.getY(), gAv.getZ(), this.force1, this.torque1);
            if (this.getBody(1) != null) {
                this.getBody(1).addForceAtPos(-c.getX(), -c.getY(), -c.getZ(), gAv.getX(), gAv.getY(), gAv.getZ(), this.force2, this.torque2);
            }
        }
        if (!Vector3.epsilonEquals(Vector3.ZERO, this.angularK, 1.0E-4f)) {
            if (this.getBody(1) != null) {
                Tq.setZero();
                this.getBody(1).getQuaternion().mul(this.rotQ, Tq);
            } else {
                Tq.set(this.rotQ);
            }
            Tq.toMatrix(T);
            Tinv.set(T);
            Tinv.transpose();
            T.getColumn(0, axis1);
            T.getColumn(1, axis2);
            T.getColumn(2, axis3);
            Quaternion.getAngles(this.getBody(0).getQuaternion(), Tq, axis1, axis2, axis3, c);
            i = 0;
            while (i < 3) {
                int n = i;
                JointPenalty.c.m[n] = JointPenalty.c.m[n] * -this.angularK.m[i];
                ++i;
            }
            tmpV.setZero();
            Tinv.mulInc(c, tmpV);
            c.set(tmpV);
            this.torque1.sub(c);
            this.torque2.add(c);
        }
    }

    public SimState cloneState(ClonedReferences util) {
        return null;
    }

    public Vector3 convertGlobalCoordsToFrame1Coords(Vector3 relative, Vector3 passback) {
        passback.setZero();
        tmpV.set(relative);
        tmpV.sub(this.getBody(0).getPosition());
        this.getBody(0).getRotation().transposeMul(tmpV, passback);
        return passback;
    }

    public Vector3 convertGlobalCoordsToFrame2Coords(Vector3 relative, Vector3 passback) {
        passback.setZero();
        if (this.getBody(1) != null) {
            tmpVa.setZero();
            tmpV.set(relative);
            tmpV.sub(this.getBody(1).getPosition());
            this.getBody(1).getRotation().transposeMul(tmpV, tmpVa);
            this.t2.transposeMul(tmpVa, passback);
        } else {
            this.t2.transposeMul(relative, passback);
        }
        return passback;
    }

    public Vector3 convertGlobalFrameToFrame2(Vector3 relative, Vector3 passback) {
        passback.setZero();
        if (this.getBody(1) != null) {
            tmpVa.setZero();
            this.getBody(1).getRotation().transposeMul(relative, tmpVa);
            this.t2.transposeMul(tmpVa, passback);
        } else {
            this.t2.transposeMul(relative, passback);
        }
        return passback;
    }

    public Vector3 convertFrame1CoordsToGlobalFrame(Vector3 relative, Vector3 passback) {
        passback.setZero();
        this.getBody(0).getRotation().mulInc(relative, passback);
        return passback;
    }

    public Vector3 convertFrame2CoordsToGlobalFrame(Vector3 relative, Vector3 passback) {
        passback.setZero();
        tmpV.setZero();
        this.t2.mulInc(relative, tmpV);
        if (this.getBody(1) != null) {
            this.getBody(1).getRotation().mulInc(tmpV, passback);
        } else {
            passback.set(tmpV);
        }
        return passback;
    }

    public Vector3 convertFrame1CoordsToGlobalCoords(Vector3 relative, Vector3 passback) {
        this.convertFrame1CoordsToGlobalFrame(relative, passback);
        passback.add(this.getBody(0).getPosition());
        return passback;
    }

    public Vector3 convertFrame2CoordsToGlobalCoords(Vector3 relative, Vector3 passback) {
        this.convertFrame2CoordsToGlobalFrame(relative, passback);
        if (this.getBody(1) != null) {
            passback.add(this.getBody(1).getPosition());
        }
        return passback;
    }

    public Vector3 getAnchor1InGlobalFrame(Vector3 passback) {
        return this.convertFrame1CoordsToGlobalFrame(this.anchor1, passback);
    }

    public Vector3 getAnchor2InGlobalFrame(Vector3 passback) {
        return this.convertFrame2CoordsToGlobalFrame(this.anchor2, passback);
    }

    public Vector3 getAnchor1InGlobalCoords(Vector3 passback) {
        return this.convertFrame1CoordsToGlobalCoords(this.anchor1, passback);
    }

    public Vector3 getAnchor2InGlobalCoords(Vector3 passback) {
        return this.convertFrame2CoordsToGlobalCoords(this.anchor2, passback);
    }

    public static class JointForce
    extends BodyForce {
        private static final long serialVersionUID = 1L;
        JointPenalty parent;
        boolean attachedToFirstBody;

        public JointForce(Body body, JointPenalty parent, boolean attachedToFirstBody) {
            super(body);
            this.parent = parent;
            this.attachedToFirstBody = attachedToFirstBody;
        }

        public void applyForce(float t, Vector3 faccAccumulator, Vector3 taccAccumulator) {
            this.parent.calculateForces(t);
            if (this.attachedToFirstBody) {
                faccAccumulator.add(this.parent.force1);
                taccAccumulator.add(this.parent.torque1);
            } else {
                faccAccumulator.add(this.parent.force2);
                taccAccumulator.add(this.parent.torque2);
            }
        }

        public SimState cloneState(ClonedReferences util) {
            return null;
        }
    }
}

