/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.AbstractSimpleSpace;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;

public class SimpleSpace
extends AbstractSimpleSpace {
    private static final long serialVersionUID = 1026810829335704640L;

    public SimpleSpace(Space parent) {
        super(parent, 11);
        if (parent != null) {
            parent.add(this);
        }
    }

    protected SimpleSpace(Space parent, int spaceClass) {
        super(parent, spaceClass);
        if (parent != null) {
            parent.add(this);
        }
    }

    private SimpleSpace() {
        super(null, 0);
    }

    public void collideAll(Object data, NearCallback callback) {
        this.cleanGeoms();
        int i = 0;
        while (i < this.clean.size()) {
            Geom g1 = (Geom)this.clean.get(i);
            if (g1.isEnabled()) {
                int j = i - 1;
                while (j >= 0) {
                    Geom g2 = (Geom)this.clean.get(j);
                    if (g2.isEnabled() && SimpleSpace.canCollide(g1, g2, callback.ignoreStatic())) {
                        Geom.collideAABBs(g1, g2, data, callback);
                    }
                    --j;
                }
            }
            ++i;
        }
    }

    public void collide(Object data, Geom geom, boolean spaceIsFirst, NearCallback callback) {
        this.cleanGeoms();
        if (geom instanceof Space) {
            ((Space)geom).cleanGeoms();
        }
        geom.recomputeAABB();
        int i = 0;
        while (i < this.clean.size()) {
            Geom g = (Geom)this.clean.get(i);
            if (g.isEnabled()) {
                if (spaceIsFirst) {
                    Geom.collideAABBs(g, geom, data, callback);
                } else {
                    Geom.collideAABBs(geom, g, data, callback);
                }
            }
            ++i;
        }
    }

    public SimpleSpace cloneState(ClonedReferences util) {
        SimpleSpace clone = new SimpleSpace();
        this.clonePartialSpace(clone, util);
        int i = 0;
        while (i < this.clean.size()) {
            clone.clean.add((Geom)util.getClone((SimState)this.clean.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.dirty.size()) {
            clone.dirty.add((Geom)util.getClone((SimState)this.dirty.get(i)));
            ++i;
        }
        return clone;
    }
}

