/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import java.util.Arrays;
import java.util.Random;
import net.java.dev.joode.Body;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointFeedback;
import net.java.dev.joode.stepper.AbstractStepperFunction;
import net.java.dev.joode.stepper.QuickStepParameters;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class QuickStepper
extends AbstractStepperFunction {
    public static final Vector3 avel = new Vector3();
    public static final Vector3 lvel = new Vector3();
    private static final QuickStepper INSTANCE = new QuickStepper();
    public static final boolean WARM_STARTING = false;
    public static final boolean REORDER_CONSTRAINTS = false;
    public static final boolean RANDOMLY_REORDER_CONSTRAINTS = true;
    public static final Random rnd = new Random(0L);
    public final QuickStepParameters qsp = new QuickStepParameters();

    public static final QuickStepper getInstance() {
        return INSTANCE;
    }

    public void stepConstraints(int m, World world, Body[] body, int bcount, Joint[] joint, int jcount, Joint.Info1[] info, int[] ofs, Matrix3[] invI, float t_start, float t_end) {
        int j;
        float stepsize = t_end - t_start;
        float fps = 1.0f / stepsize;
        Matrix J = new Matrix(12, m);
        Real c = new Real(m);
        Real cfm = new Real(m);
        Arrays.fill(cfm.m, world.getGlobalCFM());
        Real lo = new Real(m);
        Arrays.fill(lo.m, Float.NEGATIVE_INFINITY);
        Real hi = new Real(m);
        Arrays.fill(hi.m, Float.POSITIVE_INFINITY);
        int[] findex = new int[m];
        Arrays.fill(findex, -1);
        Joint.Info2 Jinfo = new Joint.Info2();
        Jinfo.rowskip = 12;
        Jinfo.fps = fps;
        Jinfo.erp = world.getGlobalERP();
        Jinfo.J1l = new RealPointer(J);
        Jinfo.J1a = new RealPointer(J);
        Jinfo.J2l = new RealPointer(J);
        Jinfo.J2a = new RealPointer(J);
        Jinfo.c = new RealPointer(c);
        Jinfo.cfm = new RealPointer(cfm);
        Jinfo.lo = new RealPointer(lo);
        Jinfo.hi = new RealPointer(hi);
        Jinfo.findex = new IntPointer(findex);
        int i = 0;
        while (i < jcount) {
            int start = ofs[i] * 12;
            Jinfo.J1l.setIndex(start);
            Jinfo.J1a.setIndex(start + 3);
            Jinfo.J2l.setIndex(start + 6);
            Jinfo.J2a.setIndex(start + 9);
            Jinfo.c.setIndex(ofs[i]);
            Jinfo.cfm.setIndex(ofs[i]);
            Jinfo.lo.setIndex(ofs[i]);
            Jinfo.hi.setIndex(ofs[i]);
            Jinfo.findex.setIndex(ofs[i]);
            joint[i].getInfo2(Jinfo);
            j = 0;
            while (j < info[i].m) {
                if (findex[ofs[i] + j] >= 0) {
                    int n = ofs[i] + j;
                    findex[n] = findex[n] + ofs[i];
                }
                ++j;
            }
            ++i;
        }
        Matrix Jcopy = new Matrix(12, m);
        System.arraycopy(J.m, 0, Jcopy.m, 0, m * 12);
        int[][] jb = new int[m][2];
        i = 0;
        while (i < jcount) {
            int b1 = joint[i].getBody(0) != null ? joint[i].getBody(0).getTag() : -1;
            int b2 = joint[i].getBody(1) != null ? joint[i].getBody(1).getTag() : -1;
            j = 0;
            while (j < info[i].m) {
                jb[ofs[i] + j][0] = b1;
                jb[ofs[i] + j][1] = b2;
                ++j;
            }
            ++i;
        }
        float[] rhs = this.computeRightHandSide(body, bcount, fps, invI, m, J, c, jb);
        i = 0;
        while (i < m) {
            int n = i++;
            cfm.m[n] = cfm.m[n] * fps;
        }
        float[] lambda = new float[m];
        float[][] cforce = new float[bcount][6];
        this.SOR_LCP(m, J, jb, body, invI, lambda, cforce, rhs, lo.m, hi.m, cfm.m, findex);
        this.addConstraintForces(body, bcount, cforce, stepsize);
        this.setJointFeedback(joint, jcount, info, ofs, Jcopy, lambda);
    }

    private float[] computeRightHandSide(Body[] body, int bcount, float fps, Matrix3[] invI, int m, Matrix J, Real c, int[][] jb) {
        Vector3[][] tmp1 = new Vector3[bcount][2];
        int i = 0;
        while (i < bcount) {
            tmp1[i][0] = new Vector3();
            tmp1[i][1] = new Vector3();
            body[i].getLinearVel(lvel);
            body[i].getAngularVel(avel);
            int j = 0;
            while (j < 3) {
                tmp1[i][0].m[j] = body[i].getFACC().m[j] * body[i].getMass().getInverseMass() + QuickStepper.lvel.m[j] * fps;
                ++j;
            }
            MathUtils.dMULTIPLY0_331((Real)tmp1[i][1], invI[i], (Real)body[i].getTACC());
            j = 0;
            while (j < 3) {
                int n = j;
                tmp1[i][1].m[n] = tmp1[i][1].m[n] + QuickStepper.avel.m[j] * fps;
                ++j;
            }
            ++i;
        }
        float[] rhs = new float[m];
        QuickStepper.multiply_J(m, J, jb, tmp1, rhs);
        i = 0;
        while (i < m) {
            rhs[i] = c.m[i] * fps - rhs[i];
            ++i;
        }
        return rhs;
    }

    private void addConstraintForces(Body[] body, int bcount, float[][] cforce, float stepsize) {
        int i = 0;
        while (i < bcount) {
            body[i].getLinearVel(lvel);
            body[i].getAngularVel(avel);
            int j = 0;
            while (j < 3) {
                int n = j;
                QuickStepper.lvel.m[n] = QuickStepper.lvel.m[n] + stepsize * cforce[i][j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                int n = j;
                QuickStepper.avel.m[n] = QuickStepper.avel.m[n] + stepsize * cforce[i][j + 3];
                ++j;
            }
            body[i].setLinearVel(lvel);
            body[i].setAngularVel(avel);
            ++i;
        }
    }

    private void setJointFeedback(Joint[] joint, int jcount, Joint.Info1[] info, int[] ofs, Matrix Jcopy, float[] lambda) {
        int i = 0;
        while (i < jcount) {
            JointFeedback feedback = joint[i].getFeedback();
            if (feedback != null) {
                float[] data = new float[6];
                QuickStepper.Multiply1_12q1(data, Jcopy, lambda, info[i].m, ofs[i], 0);
                feedback.getForce1().setX(data[0]);
                feedback.getForce1().setY(data[1]);
                feedback.getForce1().setZ(data[2]);
                feedback.getTorque1().setX(data[3]);
                feedback.getTorque1().setY(data[4]);
                feedback.getTorque1().setZ(data[5]);
                if (joint[i].getBody(1) != null) {
                    QuickStepper.Multiply1_12q1(data, Jcopy, lambda, info[i].m, ofs[i], 6);
                    feedback.getForce2().setX(data[0]);
                    feedback.getForce2().setY(data[1]);
                    feedback.getForce2().setZ(data[2]);
                    feedback.getTorque2().setX(data[3]);
                    feedback.getTorque2().setY(data[4]);
                    feedback.getTorque2().setZ(data[5]);
                }
            }
            ++i;
        }
    }

    private static void multiply_J(int m, Matrix J, int[][] jb, Vector3[][] in, float[] out) {
        int i = 0;
        while (i < m) {
            float sum = 0.0f;
            int body1 = jb[i][0];
            int j = 0;
            while (j < 6) {
                sum = j < 3 ? (sum += J.get(j, i) * in[body1][0].m[j]) : (sum += J.get(j, i) * in[body1][1].m[j - 3]);
                ++j;
            }
            if (jb[i][1] >= 0) {
                int body2 = jb[i][1];
                j = 0;
                while (j < 6) {
                    sum = j < 3 ? (sum += J.get(j + 6, i) * in[body2][0].m[j]) : (sum += J.get(j + 6, i) * in[body2][1].m[j - 3]);
                    ++j;
                }
            }
            out[i] = sum;
            ++i;
        }
    }

    private static void Multiply1_12q1(float[] A, Matrix B, float[] C, int q, int ofs, int ofsb) {
        int i = 0;
        while (i < 6) {
            float sum = 0.0f;
            int k = ofs;
            while (k < ofs + q) {
                sum += B.get(i + ofsb, k) * C[k];
                ++k;
            }
            A[i] = sum;
            ++i;
        }
    }

    public void SOR_LCP(int m, Matrix J, int[][] jb, Body[] body, Matrix3[] invI, float[] lambda, float[][] fc, float[] b, float[] lo, float[] hi, float[] cfm, int[] findex) {
        int j;
        float[][] iMJ = new float[m][12];
        QuickStepper.compute_invM_JT(m, J, iMJ, jb, body, invI);
        float[] Ad = new float[m];
        int i = 0;
        while (i < m) {
            float sum = 0.0f;
            j = 0;
            while (j < 6) {
                sum += iMJ[i][j] * J.get(j, i);
                ++j;
            }
            if (jb[i][1] >= 0) {
                j = 6;
                while (j < 12) {
                    sum += iMJ[i][j] * J.get(j, i);
                    ++j;
                }
            }
            Ad[i] = this.qsp.getW() / (sum + cfm[i]);
            ++i;
        }
        i = 0;
        while (i < m) {
            j = 0;
            while (j < 12) {
                J.set(j, i, J.get(j, i) * Ad[i]);
                ++j;
            }
            int n = i;
            b[n] = b[n] * Ad[i];
            ++i;
        }
        i = 0;
        while (i < m) {
            int n = i;
            Ad[n] = Ad[n] * cfm[i];
            ++i;
        }
        IndexError[] order = new IndexError[m];
        i = 0;
        while (i < m) {
            order[i] = new IndexError();
            ++i;
        }
        j = 0;
        i = 0;
        while (i < m) {
            if (findex[i] < 0) {
                order[j].index = i;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m) {
            if (findex[i] >= 0) {
                order[j].index = i;
                ++j;
            }
            ++i;
        }
        assert (j == m);
        float[] hicopy = new float[m];
        System.arraycopy(hi, 0, hicopy, 0, m);
        float[] last_lambda = new float[m];
        int iteration = 0;
        while (iteration < this.qsp.getNumIterations()) {
            if ((iteration & 7) == 0) {
                i = 1;
                while (i < m) {
                    IndexError tmp = order[i];
                    int swapi = rnd.nextInt(i);
                    order[i] = order[swapi];
                    order[swapi] = tmp;
                    ++i;
                }
            }
            i = 0;
            while (i < m) {
                float new_lambda;
                int index = order[i].index;
                if (findex[index] >= 0) {
                    hi[index] = Math.abs(hicopy[index] * lambda[findex[index]]);
                    lo[index] = -hi[index];
                }
                int b1 = jb[index][0];
                int b2 = jb[index][1];
                float delta = b[index] - lambda[index] * Ad[index];
                delta -= fc[b1][0] * J.get(0, index) + fc[b1][1] * J.get(1, index) + fc[b1][2] * J.get(2, index) + fc[b1][3] * J.get(3, index) + fc[b1][4] * J.get(4, index) + fc[b1][5] * J.get(5, index);
                if (b2 >= 0) {
                    delta -= fc[b2][0] * J.get(6, index) + fc[b2][1] * J.get(7, index) + fc[b2][2] * J.get(8, index) + fc[b2][3] * J.get(9, index) + fc[b2][4] * J.get(10, index) + fc[b2][5] * J.get(11, index);
                }
                if ((new_lambda = lambda[index] + delta) < lo[index]) {
                    delta = lo[index] - lambda[index];
                    lambda[index] = lo[index];
                } else if (new_lambda > hi[index]) {
                    delta = hi[index] - lambda[index];
                    lambda[index] = hi[index];
                } else {
                    lambda[index] = new_lambda;
                }
                float[] fArray = fc[b1];
                fArray[0] = fArray[0] + delta * iMJ[index][0];
                float[] fArray2 = fc[b1];
                fArray2[1] = fArray2[1] + delta * iMJ[index][1];
                float[] fArray3 = fc[b1];
                fArray3[2] = fArray3[2] + delta * iMJ[index][2];
                float[] fArray4 = fc[b1];
                fArray4[3] = fArray4[3] + delta * iMJ[index][3];
                float[] fArray5 = fc[b1];
                fArray5[4] = fArray5[4] + delta * iMJ[index][4];
                float[] fArray6 = fc[b1];
                fArray6[5] = fArray6[5] + delta * iMJ[index][5];
                if (b2 >= 0) {
                    float[] fArray7 = fc[b2];
                    fArray7[0] = fArray7[0] + delta * iMJ[index][6];
                    float[] fArray8 = fc[b2];
                    fArray8[1] = fArray8[1] + delta * iMJ[index][7];
                    float[] fArray9 = fc[b2];
                    fArray9[2] = fArray9[2] + delta * iMJ[index][8];
                    float[] fArray10 = fc[b2];
                    fArray10[3] = fArray10[3] + delta * iMJ[index][9];
                    float[] fArray11 = fc[b2];
                    fArray11[4] = fArray11[4] + delta * iMJ[index][10];
                    float[] fArray12 = fc[b2];
                    fArray12[5] = fArray12[5] + delta * iMJ[index][11];
                }
                ++i;
            }
            ++iteration;
        }
    }

    private static void compute_invM_JT(int m, Matrix J, float[][] iMJ, int[][] jb, Body[] body, Matrix3[] invI) {
        int i = 0;
        while (i < m) {
            int b = jb[i][0];
            float k = body[b].getMass().getInverseMass();
            int j = 0;
            while (j < 3) {
                iMJ[i][j] = k * J.get(j, i);
                ++j;
            }
            j = 0;
            while (j < 3) {
                iMJ[i][j + 3] = invI[b].m[j * 4] * J.get(3, i) + invI[b].m[j * 4 + 1] * J.get(4, i) + invI[b].m[j * 4 + 2] * J.get(5, i);
                ++j;
            }
            if (jb[i][1] >= 0) {
                b = jb[i][1];
                k = body[b].getMass().getInverseMass();
                j = 0;
                while (j < 3) {
                    iMJ[i][j + 6] = k * J.get(j + 6, i);
                    ++j;
                }
                j = 0;
                while (j < 3) {
                    iMJ[i][j + 9] = invI[b].m[j * 4] * J.get(9, i) + invI[b].m[j * 4 + 1] * J.get(10, i) + invI[b].m[j * 4 + 2] * J.get(11, i);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void multiply_invM_JT(int m, float[][] iMJ, int[][] jb, float[] in, float[][] out) {
        int i = 0;
        while (i < m) {
            int b1 = jb[i][0];
            int j = 0;
            while (j < 6) {
                float[] fArray = out[b1];
                int n = j;
                fArray[n] = fArray[n] + iMJ[i][j] * in[i];
                ++j;
            }
            if (jb[i][1] >= 0) {
                int b2 = jb[i][1];
                j = 0;
                while (j < 6) {
                    float[] fArray = out[b2];
                    int n = j;
                    fArray[n] = fArray[n] + iMJ[i][j + 6] * in[i];
                    ++j;
                }
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexError
    implements Comparable<IndexError> {
        float error;
        int findex;
        int index;

        private IndexError() {
        }

        @Override
        public int compareTo(IndexError i2) {
            if (this.findex < 0 && i2.findex >= 0) {
                return -1;
            }
            if (this.findex >= 0 && i2.findex < 0) {
                return 1;
            }
            if (this.error < i2.error) {
                return -1;
            }
            if (this.error > i2.error) {
                return 1;
            }
            return 0;
        }
    }
}

