/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper.lcp;

import net.java.dev.joode.stepper.lcp.SlowLCP;
import net.java.dev.joode.util.FastLDLT;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.RealPointerToPointer;
import net.java.dev.joode.util.StopWatch;

public class LCPDriver {
    public static void dSolveLCPBasicSlow(int n, RealPointer A, RealPointer x, RealPointer b, RealPointer w, int nub, RealPointer lo, RealPointer hi) {
        RealPointer L = new RealPointer(new Real(n * n));
        RealPointer d = new RealPointer(new Real(n));
        RealPointer delta_x = new RealPointer(new Real(n));
        RealPointer delta_w = new RealPointer(new Real(n));
        RealPointer Dell = new RealPointer(new Real(n));
        RealPointer ell = new RealPointer(new Real(n));
        RealPointer tmp = new RealPointer(new Real(n));
        RealPointerToPointer Arows = new RealPointerToPointer(new RealPointer[n]);
        IntPointer p = new IntPointer(new int[n]);
        IntPointer C = new IntPointer(new int[n]);
        IntPointer dummy = new IntPointer(new int[n]);
        SlowLCP lcp = new SlowLCP(n, 0, A, x, b, w, tmp, tmp, L, d, Dell, ell, tmp, dummy, dummy, p, C, Arows);
        nub = lcp.getNub();
        int i = 0;
        while (i < n) {
            w.setValue(i, lcp.AiC_times_qC(i, x) - b.getValue(i));
            if (w.getValue(i) >= 0.0f) {
                lcp.transfer_i_to_N(i);
            } else {
                while (true) {
                    float s2;
                    delta_x.setZero(n);
                    lcp.solve1(delta_x, i);
                    delta_x.setValue(1.0f);
                    delta_w.setZero(n);
                    lcp.pN_equals_ANC_times_qC(delta_w, delta_x);
                    lcp.pN_plusequals_ANi(delta_w, i);
                    delta_w.setValue(i, lcp.AiC_times_qC(i, delta_x) + lcp.Aii(i));
                    int si = i;
                    boolean si_in_N = false;
                    float s = -w.getValue(i) / delta_w.getValue(i);
                    if (s <= 0.0f) {
                        JOODELog.error("LCP internal error, s <= 0 (s=", Float.valueOf(s), ") DEBUG:001");
                        if (i < n - 1) {
                            new RealPointer(x, i).setZero(n - i);
                            new RealPointer(w, i).setZero(n - i);
                        }
                        lcp.unpermute();
                        return;
                    }
                    int k = 0;
                    while (k < lcp.numN()) {
                        if (delta_w.getValue(lcp.indexN(k)) < 0.0f && (s2 = -w.getValue(lcp.indexN(k)) / delta_w.getValue(lcp.indexN(k))) < s) {
                            s = s2;
                            si = lcp.indexN(k);
                            si_in_N = true;
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < lcp.numC()) {
                        if (delta_x.getValue(lcp.indexC(k)) < 0.0f && (s2 = -x.getValue(lcp.indexC(k)) / delta_x.getValue(lcp.indexC(k))) < s) {
                            s = s2;
                            si = lcp.indexC(k);
                            si_in_N = false;
                        }
                        ++k;
                    }
                    lcp.pC_plusequals_s_times_qC(x, s, delta_x);
                    x.setValue(i, x.getValue(i) + s);
                    lcp.pN_plusequals_s_times_qN(w, s, delta_w);
                    w.setValue(i, w.getValue(i) + s * delta_w.getValue(i));
                    if (si == i) {
                        w.setValue(i, 0.0f);
                        lcp.transfer_i_to_C(i);
                        break;
                    }
                    if (si_in_N) {
                        w.setValue(si, 0.0f);
                        lcp.transfer_i_from_N_to_C(si);
                        continue;
                    }
                    x.setValue(si, 0.0f);
                    lcp.transfer_i_from_C_to_N(si);
                }
            }
            ++i;
        }
    }

    public static void dSolveLCPSlow(int n, RealPointer A, RealPointer x, RealPointer b, RealPointer w, int nub, RealPointer lo, RealPointer hi, IntPointer findex) {
        boolean hit_first_friction_index = false;
        if (nub >= n) {
            FastLDLT.dFactorLDLT(A, w, n, n);
            MathUtils.dSolveLDLT(A, w, b, n, n);
            x.copy(b, n);
            w.setZero(n);
            return;
        }
        RealPointer L = new RealPointer(new Real(n * n));
        RealPointer d = new RealPointer(new Real(n));
        RealPointer delta_x = new RealPointer(new Real(n));
        RealPointer delta_w = new RealPointer(new Real(n));
        RealPointer Dell = new RealPointer(new Real(n));
        RealPointer ell = new RealPointer(new Real(n));
        RealPointerToPointer Arows = new RealPointerToPointer(new RealPointer[n]);
        IntPointer p = new IntPointer(new int[n]);
        IntPointer C = new IntPointer(new int[n]);
        IntPointer state = new IntPointer(new int[n]);
        SlowLCP lcp = new SlowLCP(n, nub, A, x, b, w, lo, hi, L, d, Dell, ell, delta_w, state, findex, p, C, Arows);
        int i = nub = lcp.getNub();
        while (i < n) {
            int k;
            if (!hit_first_friction_index & (findex.getData() != null && findex.getValue(i) >= 0)) {
                k = 0;
                while (k < n) {
                    delta_w.setValue(p.getValue(k), x.getValue(k));
                    ++k;
                }
                k = i;
                while (k < n) {
                    float wfk = delta_w.getValue(findex.getValue(k));
                    if (wfk == 0.0f) {
                        hi.setValue(k, 0.0f);
                        lo.setValue(k, 0.0f);
                    } else {
                        hi.setValue(k, Math.abs(hi.getValue(k) * wfk));
                        lo.setValue(k, -hi.getValue(k));
                    }
                    ++k;
                }
                hit_first_friction_index = true;
            }
            w.setValue(i, lcp.AiC_times_qC(i, x) + lcp.AiN_times_qN(i, x) - b.getValue(i));
            if (lo.getValue(i) == 0.0f && w.getValue(i) >= 0.0f) {
                lcp.transfer_i_to_N(i);
                state.setValue(i, 0);
            } else if (hi.getValue(i) == 0.0f && w.getValue(i) <= 0.0f) {
                lcp.transfer_i_to_N(i);
                state.setValue(i, 1);
            } else if (w.getValue(i) == 0.0f) {
                lcp.solve1(delta_x, i, 0, 1);
                lcp.transfer_i_to_C(i);
            } else {
                int cmd;
                do {
                    float s2;
                    float dirf;
                    int dir;
                    if (w.getValue(i) <= 0.0f) {
                        dir = 1;
                        dirf = 1.0f;
                    } else {
                        dir = -1;
                        dirf = -1.0f;
                    }
                    lcp.solve1(delta_x, i, dir);
                    lcp.pN_equals_ANC_times_qC(delta_w, delta_x);
                    lcp.pN_plusequals_ANi(delta_w, i, dir);
                    delta_w.setValue(i, lcp.AiC_times_qC(i, delta_x) + lcp.Aii(i) * dirf);
                    cmd = 1;
                    int si = 0;
                    float s = -w.getValue(i) / delta_w.getValue(i);
                    if (dir > 0) {
                        if (hi.getValue(i) < Float.POSITIVE_INFINITY && (s2 = (hi.getValue(i) - x.getValue(i)) / dirf) < s) {
                            s = s2;
                            cmd = 3;
                        }
                    } else if (lo.getValue(i) > Float.NEGATIVE_INFINITY && (s2 = (lo.getValue(i) - x.getValue(i)) / dirf) < s) {
                        s = s2;
                        cmd = 2;
                    }
                    k = 0;
                    while (k < lcp.numN()) {
                        if ((state.getValue(lcp.indexN(k)) == 0 && delta_w.getValue(lcp.indexN(k)) < 0.0f || state.getValue(lcp.indexN(k)) != 0 && delta_w.getValue(lcp.indexN(k)) > 0.0f) && (lo.getValue(lcp.indexN(k)) != 0.0f || hi.getValue(lcp.indexN(k)) != 0.0f) && (s2 = -w.getValue(lcp.indexN(k)) / delta_w.getValue(lcp.indexN(k))) < s) {
                            s = s2;
                            cmd = 4;
                            si = lcp.indexN(k);
                        }
                        ++k;
                    }
                    k = nub;
                    while (k < lcp.numC()) {
                        if (delta_x.getValue(lcp.indexC(k)) < 0.0f && lo.getValue(lcp.indexC(k)) > Float.NEGATIVE_INFINITY && (s2 = (lo.getValue(lcp.indexC(k)) - x.getValue(lcp.indexC(k))) / delta_x.getValue(lcp.indexC(k))) < s) {
                            s = s2;
                            cmd = 5;
                            si = lcp.indexC(k);
                        }
                        if (delta_x.getValue(lcp.indexC(k)) > 0.0f && hi.getValue(lcp.indexC(k)) < Float.POSITIVE_INFINITY && (s2 = (hi.getValue(lcp.indexC(k)) - x.getValue(lcp.indexC(k))) / delta_x.getValue(lcp.indexC(k))) < s) {
                            s = s2;
                            cmd = 6;
                            si = lcp.indexC(k);
                        }
                        ++k;
                    }
                    if (s <= 0.0f) {
                        JOODELog.debug("LCP internal error, s <= 0 (s=", Float.valueOf(s), ") DEBUG:002");
                        if (i < n - 1) {
                            new RealPointer(x, i).setZero(n - i);
                            new RealPointer(w, i).setZero(n - i);
                        }
                        lcp.unpermute();
                        return;
                    }
                    lcp.pC_plusequals_s_times_qC(x, s, delta_x);
                    x.setValue(i, x.getValue(i) + s * dirf);
                    lcp.pN_plusequals_s_times_qN(w, s, delta_w);
                    w.setValue(i, w.getValue(i) + s * delta_w.getValue(i));
                    switch (cmd) {
                        case 1: {
                            w.setValue(i, 0.0f);
                            lcp.transfer_i_to_C(i);
                            break;
                        }
                        case 2: {
                            x.setValue(i, lo.getValue(i));
                            state.setValue(i, 0);
                            lcp.transfer_i_to_N(i);
                            break;
                        }
                        case 3: {
                            x.setValue(i, hi.getValue(i));
                            state.setValue(i, 1);
                            lcp.transfer_i_to_N(i);
                            break;
                        }
                        case 4: {
                            w.setValue(si, 0.0f);
                            lcp.transfer_i_from_N_to_C(si);
                            break;
                        }
                        case 5: {
                            x.setValue(si, lo.getValue(si));
                            state.setValue(si, 0);
                            lcp.transfer_i_from_C_to_N(si);
                            break;
                        }
                        case 6: {
                            x.setValue(si, hi.getValue(si));
                            state.setValue(si, 1);
                            lcp.transfer_i_from_C_to_N(si);
                        }
                    }
                } while (cmd > 3);
            }
            ++i;
        }
    }

    public static void dTestSolveLCP() {
        int n = 100;
        float tol = 1.0E-9f;
        JOODELog.debug("dTestSolveLCP()");
        RealPointer A = new RealPointer(new Real(n * n));
        RealPointer x = new RealPointer(new Real(n));
        RealPointer b = new RealPointer(new Real(n));
        RealPointer w = new RealPointer(new Real(n));
        RealPointer lo = new RealPointer(new Real(n));
        RealPointer hi = new RealPointer(new Real(n));
        RealPointer A2 = new RealPointer(new Real(n * n));
        RealPointer b2 = new RealPointer(new Real(n));
        RealPointer lo2 = new RealPointer(new Real(n));
        RealPointer hi2 = new RealPointer(new Real(n));
        RealPointer tmp1 = new RealPointer(new Real(n));
        RealPointer tmp2 = new RealPointer(new Real(n));
        long total_time = 0L;
        int count = 0;
        while (count < 1000) {
            LCPDriver.dMakeRandomMatrix(A2, n, n, 1.0f);
            MathUtils.dMultiply2(A, A2, A2, n, n, n);
            LCPDriver.dMakeRandomMatrix(x, n, 1, 1.0f);
            MathUtils.dMultiply0(b, A, x, n, n, 1);
            int i = 0;
            while (i < n) {
                b.setValue(i, b.getValue(i) + (MathUtils.rnd.nextFloat() * 0.2f - 0.1f));
                ++i;
            }
            int nub = 50;
            i = 0;
            while (i < nub) {
                lo.setValue(i, Float.NEGATIVE_INFINITY);
                ++i;
            }
            i = 0;
            while (i < nub) {
                hi.setValue(i, Float.POSITIVE_INFINITY);
                ++i;
            }
            i = nub;
            while (i < n) {
                lo.setValue(i, -(MathUtils.rnd.nextFloat() * 1.0f + 0.01f));
                ++i;
            }
            i = nub;
            while (i < n) {
                hi.setValue(i, MathUtils.rnd.nextFloat() * 1.0f + 0.01f);
                ++i;
            }
            A2.copy(A, n * n);
            LCPDriver.dClearUpperTriangle(A2, n);
            b2.copy(b, n);
            lo2.copy(lo, n);
            hi2.copy(hi, n);
            x.setZero(n);
            w.setZero(n);
            StopWatch sw = new StopWatch();
            sw.reset();
            sw.start();
            LCPDriver.dSolveLCPSlow(n, A2, x, b2, w, nub, lo2, hi2, new IntPointer(null));
            sw.stop();
            long time = sw.time();
            long average = (total_time += time) / (long)(count + 1) * 1000L;
            MathUtils.dMultiply0(tmp1, A, x, n, n, 1);
            i = 0;
            while (i < n) {
                tmp2.setValue(i, b.getValue(i) + w.getValue(i));
                ++i;
            }
            float diff = LCPDriver.dMaxDifference(tmp1, tmp2, n, 1);
            if (diff > tol) {
                JOODELog.error("A*x = b+w, maximum difference = ", Float.valueOf(diff));
            }
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            i = 0;
            while (i < n) {
                if (x.getValue(i) == lo.getValue(i) && w.getValue(i) >= 0.0f) {
                    ++n1;
                } else if (x.getValue(i) == hi.getValue(i) && w.getValue(i) <= 0.0f) {
                    ++n2;
                } else if (x.getValue(i) >= lo.getValue(i) && x.getValue(i) <= hi.getValue(i) && w.getValue(i) == 0.0f) {
                    ++n3;
                } else {
                    JOODELog.error("FAILED: i=", i, " x=", Float.valueOf(x.getValue(i)), " w=", Float.valueOf(w.getValue(i)), " lo=", Float.valueOf(lo.getValue(i)), " hi=", Float.valueOf(hi.getValue(i)));
                }
                ++i;
            }
            JOODELog.error("passed: NL=", n1, " NH=", n2, " C=", n3);
            JOODELog.error("time=", time, " ns  avg=", average);
            ++count;
        }
    }

    public static void dMakeRandomMatrix(RealPointer A, int n, int m, float range) {
        A.getData().setZero();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                A.setValue(i * m + j, (MathUtils.rnd.nextFloat() * 2.0f - 1.0f) * range);
                ++j;
            }
            ++i;
        }
    }

    public static void dClearUpperTriangle(RealPointer A, int n) {
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                A.setValue(i * n + j, 0.0f);
                ++j;
            }
            ++i;
        }
    }

    public static float dMaxDifference(RealPointer A, RealPointer B, int n, int m) {
        float max = 0.0f;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                float diff = Math.abs(A.getValue(i * m + j) - B.getValue(i * m + j));
                if (diff > max) {
                    max = diff;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static void main(String[] args) {
        LCPDriver.dTestSolveLCP();
    }
}

