/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper.lcp;

import net.java.dev.joode.util.FastLDLT;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.RealPointerToPointer;

public class SlowLCP {
    private int n;
    private int nub;
    private RealPointer Adata;
    private RealPointer x;
    private RealPointer b;
    private RealPointer w;
    private RealPointer lo;
    private RealPointer hi;
    private RealPointerToPointer A;
    private int[] C;
    private int[] N;
    private int last_i_for_solve1;

    int getNub() {
        return this.nub;
    }

    public void pN_plusequals_ANi(RealPointer p, int i) {
        this.pN_plusequals_ANi(p, i, 1);
    }

    public void solve1(RealPointer a, int i) {
        this.solve1(a, i, 1, 0);
    }

    public void solve1(RealPointer a, int i, int dir) {
        this.solve1(a, i, dir, 0);
    }

    public SlowLCP(int _n, int _nub, RealPointer _Adata, RealPointer _x, RealPointer _b, RealPointer _w, RealPointer _lo, RealPointer _hi, RealPointer _L, RealPointer _d, RealPointer _Dell, RealPointer _ell, RealPointer _tmp, IntPointer _state, IntPointer _findex, IntPointer _p, IntPointer _C, RealPointerToPointer Arows) {
        if (_findex.getData() != null) {
            this.n = _n;
        }
        this.nub = _nub;
        this.Adata = _Adata;
        this.A = null;
        this.x = _x;
        this.b = _b;
        this.w = _w;
        this.lo = _lo;
        this.hi = _hi;
        this.x.getData().setZero();
        this.last_i_for_solve1 = -1;
        this.C = new int[this.n];
        this.N = new int[this.n];
        int i = 0;
        while (i < this.n) {
            this.C[i] = 0;
            this.N[i] = 0;
            ++i;
        }
        this.A = Arows;
        i = 0;
        while (i < this.n) {
            this.A.setValue(i, this.Adata.add(i * this.n));
            ++i;
        }
        i = 0;
        while (i < this.n) {
            int j = i + 1;
            while (j < this.n) {
                this.A.getData()[i].getData().m[j] = this.A.getData()[j].getData().m[i];
                ++j;
            }
            ++i;
        }
        if (this.nub > 0) {
            int cpi;
            i = 0;
            while (i < this.nub) {
                cpi = 0;
                while (cpi < i + 1) {
                    _L.setValue(i * this.n + cpi, this.A.getValue(i).getValue(cpi));
                    ++cpi;
                }
                ++i;
            }
            FastLDLT.dFactorLDLT(_L, _d, this.nub, this.n);
            cpi = 0;
            while (cpi < this.nub) {
                this.x.setValue(cpi, this.b.getValue(cpi));
                ++cpi;
            }
            MathUtils.dSolveLDLT(_L, _d, this.x, this.nub, this.n);
            int di = 0;
            while (di < this.nub) {
                _w.setValue(di, 0.0f);
                ++di;
            }
            i = 0;
            while (i < this.nub) {
                this.C[i] = 1;
                ++i;
            }
        }
    }

    void transfer_i_to_C(int i) {
        if (i < this.nub) {
            JOODELog.error("bad i");
        }
        if (this.C[i] != 0) {
            JOODELog.error("i already in C");
        }
        if (this.N[i] != 0) {
            JOODELog.error("i already in N");
        }
        int k = 0;
        while (k < i) {
            if ((this.C[k] ^ this.N[k]) == 0) {
                JOODELog.error("assumptions for C and N violated");
            }
            ++k;
        }
        k = i;
        while (k < this.n) {
            if ((this.C[k] | this.N[k]) != 0) {
                JOODELog.error("assumptions for C and N violated");
            }
            ++k;
        }
        if (i != this.last_i_for_solve1) {
            JOODELog.error("assumptions for i violated");
        }
        this.last_i_for_solve1 = -1;
        this.C[i] = 1;
    }

    void transfer_i_to_N(int i) {
        if (i < this.nub) {
            JOODELog.error("bad i");
        }
        if (this.C[i] != 0) {
            JOODELog.error("i already in C");
        }
        if (this.N[i] != 0) {
            JOODELog.error("i already in N");
        }
        int k = 0;
        while (k < i) {
            if (this.C[k] == 0 && this.N[k] == 0) {
                JOODELog.error("assumptions for C and N violated");
            }
            ++k;
        }
        k = i;
        while (k < this.n) {
            if ((this.C[k] | this.N[k]) != 0) {
                JOODELog.error("assumptions for C and N violated");
            }
            ++k;
        }
        this.last_i_for_solve1 = -1;
        this.N[i] = 1;
    }

    void transfer_i_from_N_to_C(int i) {
        if (i < this.nub) {
            JOODELog.error("bad i");
        }
        if (this.C[i] != 0) {
            JOODELog.error("i already in C");
        }
        if (this.N[i] == 0) {
            JOODELog.error("i not in N");
        }
        this.last_i_for_solve1 = -1;
        this.N[i] = 0;
        this.C[i] = 1;
    }

    void transfer_i_from_C_to_N(int i) {
        if (i < this.nub) {
            JOODELog.error("bad i");
        }
        if (this.N[i] != 0) {
            JOODELog.error("i already in N");
        }
        if (this.C[i] == 0) {
            JOODELog.error("i not in C");
        }
        this.last_i_for_solve1 = -1;
        this.C[i] = 0;
        this.N[i] = 1;
    }

    int numC() {
        int count = 0;
        int i = 0;
        while (i < this.n) {
            if (this.C[i] != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    int numN() {
        int count = 0;
        int i = 0;
        while (i < this.n) {
            if (this.N[i] != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    int indexC(int i) {
        int count = 0;
        int k = 0;
        while (k < this.n) {
            if (this.C[k] != 0) {
                if (count == i) {
                    return k;
                }
                ++count;
            }
            ++k;
        }
        JOODELog.error("bad index C (", i, ")");
        return 0;
    }

    int indexN(int i) {
        int count = 0;
        int k = 0;
        while (k < this.n) {
            if (this.N[k] != 0) {
                if (count == i) {
                    return k;
                }
                ++count;
            }
            ++k;
        }
        JOODELog.error("bad index into N");
        return 0;
    }

    float Aii(int i) {
        return this.A.getValue(i).getValue(i);
    }

    float AiC_times_qC(int i, RealPointer q) {
        float sum = 0.0f;
        int k = 0;
        while (k < this.n) {
            if (this.C[k] != 0) {
                sum += this.A.getValue(i).getValue(k) * q.getValue(k);
            }
            ++k;
        }
        return sum;
    }

    float AiN_times_qN(int i, RealPointer q) {
        float sum = 0.0f;
        int k = 0;
        while (k < this.n) {
            if (this.N[k] != 0) {
                sum += this.A.getValue(i).getValue(k) * q.getValue(k);
            }
            ++k;
        }
        return sum;
    }

    void pN_equals_ANC_times_qC(RealPointer p, RealPointer q) {
        int ii = 0;
        while (ii < this.n) {
            if (this.N[ii] != 0) {
                float sum = 0.0f;
                int jj = 0;
                while (jj < this.n) {
                    if (this.C[jj] != 0) {
                        sum += this.A.getValue(ii).getValue(jj) * q.getValue(jj);
                    }
                    ++jj;
                }
                p.setValue(ii, sum);
            }
            ++ii;
        }
    }

    public void pN_plusequals_ANi(RealPointer p, int i, int sign) {
        int k = 0;
        while (k < this.n) {
            if (this.N[k] != 0 && k >= i) {
                JOODELog.error("N assumption violated");
            }
            ++k;
        }
        if (sign > 0) {
            k = 0;
            while (k < this.n) {
                if (this.N[k] != 0) {
                    p.setValue(k, p.getValue(k) + this.A.getValue(i).getValue(k));
                }
                ++k;
            }
        } else {
            k = 0;
            while (k < this.n) {
                if (this.N[k] != 0) {
                    p.setValue(k, p.getValue(k) - this.A.getValue(i).getValue(k));
                }
                ++k;
            }
        }
    }

    void pC_plusequals_s_times_qC(RealPointer p, float s, RealPointer q) {
        int k = 0;
        while (k < this.n) {
            if (this.C[k] != 0) {
                p.setValue(k, p.getValue(k) + s * q.getValue(k));
            }
            ++k;
        }
    }

    void pN_plusequals_s_times_qN(RealPointer p, float s, RealPointer q) {
        int k = 0;
        while (k < this.n) {
            if (this.N[k] != 0) {
                p.setValue(k, p.getValue(k) + s * q.getValue(k));
            }
            ++k;
        }
    }

    public void solve1(RealPointer a, int i, int dir, int only_transfer) {
        Real AA = new Real(this.n * this.n);
        Real dd = new Real(this.n);
        Real bb = new Real(this.n * this.n);
        this.last_i_for_solve1 = i;
        int AAi = 0;
        int ii = 0;
        while (ii < this.n) {
            if (this.C[ii] != 0) {
                int AAj = 0;
                int jj = 0;
                while (jj < this.n) {
                    if (this.C[jj] != 0) {
                        AA.m[AAi * this.n + AAj] = this.A.getValue(ii).getValue(jj);
                        ++AAj;
                    }
                    ++jj;
                }
                bb.m[AAi] = this.A.getValue(i).getValue(ii);
                ++AAi;
            }
            ++ii;
        }
        if (AAi == 0) {
            return;
        }
        FastLDLT.dFactorLDLT(new RealPointer(AA), new RealPointer(dd), AAi, this.n);
        MathUtils.dSolveLDLT(new RealPointer(AA), new RealPointer(dd), new RealPointer(bb), AAi, this.n);
        AAi = 0;
        if (dir > 0) {
            ii = 0;
            while (ii < this.n) {
                if (this.C[ii] != 0) {
                    a.setValue(ii, -bb.m[AAi++]);
                }
                ++ii;
            }
        } else {
            ii = 0;
            while (ii < this.n) {
                if (this.C[ii] != 0) {
                    a.setValue(ii, bb.m[AAi++]);
                }
                ++ii;
            }
        }
    }

    void unpermute() {
    }
}

