/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.ROVector2;
import net.java.dev.joode.util.Vector2;

public class Line2D {
    private ROVector2 start;
    private ROVector2 end;
    private Vector2 vec;
    private float lenSquared;
    private static final Vector2 loc = new Vector2(0.0f, 0.0f);
    private static final Vector2 v = new Vector2(0.0f, 0.0f);
    private static final Vector2 v2 = new Vector2(0.0f, 0.0f);
    private static final Vector2 proj = new Vector2(0.0f, 0.0f);
    private static final Vector2 closest = new Vector2(0.0f, 0.0f);
    private static final Vector2 other = new Vector2(0.0f, 0.0f);

    public Line2D(float x, float y) {
        this(0.0f, 0.0f, x, y);
    }

    public Line2D(float x1, float y1, float x2, float y2) {
        this(new Vector2(x1, y1), new Vector2(x2, y2));
    }

    public Line2D(float[] x1, float[] x2) {
        this(new Vector2(x1[0], x1[1]), new Vector2(x2[0], x2[1]));
    }

    public Line2D(ROVector2 start, ROVector2 end) {
        this.set(start, end);
    }

    public ROVector2 getStart() {
        return this.start;
    }

    public ROVector2 getEnd() {
        return this.end;
    }

    public float length() {
        return this.vec.length();
    }

    public float lengthSquared() {
        return this.vec.lengthSquared();
    }

    public void set(ROVector2 start, ROVector2 end) {
        this.start = start;
        this.end = end;
        this.vec = new Vector2(end);
        this.vec.sub(start);
        this.lenSquared = this.vec.length();
        this.lenSquared *= this.lenSquared;
    }

    public float getDX() {
        return this.end.getX() - this.start.getX();
    }

    public float getDY() {
        return this.end.getY() - this.start.getY();
    }

    public float getX1() {
        return this.start.getX();
    }

    public float getY1() {
        return this.start.getY();
    }

    public float getX2() {
        return this.end.getX();
    }

    public float getY2() {
        return this.end.getY();
    }

    public float distance(ROVector2 point) {
        return (float)Math.sqrt(this.distanceSquared(point));
    }

    public float distanceSquared(ROVector2 point) {
        this.getClosestPoint(point, closest);
        closest.sub(point);
        float result = closest.lengthSquared();
        return result;
    }

    public void getClosestPoint(ROVector2 point, Vector2 result) {
        loc.set(point);
        loc.sub(this.start);
        v.set(this.vec);
        v2.set(this.vec);
        v2.scale(-1.0f);
        v.normalise();
        loc.projectOntoUnit(v, proj);
        if (proj.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.end);
            return;
        }
        proj.add(this.start);
        other.set(proj);
        other.sub(this.end);
        if (other.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.start);
            return;
        }
        result.set(proj);
    }

    public Line2D getPositionedLine(ROVector2 displacement, float rotation) {
        Vector2[] verts = this.getVertices(displacement, rotation);
        Line2D line = new Line2D(verts[0], verts[1]);
        return line;
    }

    public Vector2[] getVertices(ROVector2 displacement, float rotation) {
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        Vector2[] endPoints = new Vector2[2];
        endPoints[0] = new Vector2(this.getX1() * cos - this.getY1() * sin, this.getY1() * cos + this.getX1() * sin);
        endPoints[0].add(displacement);
        endPoints[1] = new Vector2(this.getX2() * cos - this.getY2() * sin, this.getY2() * cos + this.getX2() * sin);
        endPoints[1].add(displacement);
        return endPoints;
    }

    public void move(ROVector2 v) {
        Vector2 temp = new Vector2(this.start);
        temp.add(v);
        this.start = temp;
        temp = new Vector2(this.end);
        temp.add(v);
        this.end = temp;
    }

    public String toString() {
        return "[Line " + this.start + "," + this.end + "]";
    }

    public Vector2 intersect(Line2D other) {
        float dx1 = this.end.getX() - this.start.getX();
        float dx2 = other.end.getX() - other.start.getX();
        float dy1 = this.end.getY() - this.start.getY();
        float dy2 = other.end.getY() - other.start.getY();
        float denom = dy2 * dx1 - dx2 * dy1;
        if (denom == 0.0f) {
            return null;
        }
        float ua = dx2 * (this.start.getY() - other.start.getY()) - dy2 * (this.start.getX() - other.start.getX());
        float ub = dx1 * (this.start.getY() - other.start.getY()) - dy1 * (this.start.getX() - other.start.getX());
        ub /= denom;
        float u = ua /= denom;
        float ix = this.start.getX() + u * (this.end.getX() - this.start.getX());
        float iy = this.start.getY() + u * (this.end.getY() - this.start.getY());
        return new Vector2(ix, iy);
    }
}

