/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.Random;
import net.java.dev.joode.util.FastLSolve;
import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.MatrixMxNf;

public class MathUtils {
    public static final float M_SQRT1_2 = 0.70710677f;
    public static Random rnd = new Random(0L);
    public static final RealPointer tmpA = new RealPointer(null);
    public static final RealPointer tmpB = new RealPointer(null);
    public static final RealPointer tmpC = new RealPointer(null);
    public static final RealPointer tmpAA = new RealPointer(null);
    public static final RealPointer tmpBB = new RealPointer(null);
    public static final RealPointer tmpCC = new RealPointer(null);
    public static final RealPointer tmpD = new RealPointer(null);

    public static float dDOTpq(Real a, Real b, int s1, int s2, int p, int q) {
        return a.m[s1] * b.m[s2] + a.m[s1 + p] * b.m[s2 + q] + a.m[s1 + 2 * p] * b.m[s2 + 2 * q];
    }

    private static float dDOT(Real a, Real b, int s1, int s2) {
        return MathUtils.dDOTpq(a, b, s1, s2, 1, 1);
    }

    private static float dDOT14(Real a, Real b, int s1, int s2) {
        return MathUtils.dDOTpq(a, b, s1, s2, 1, 4);
    }

    private static float dDOT41(Real a, Real b, int s1, int s2) {
        return MathUtils.dDOTpq(a, b, s1, s2, 4, 1);
    }

    public static void dCROSS_MINUSEQUAL(Real a, Real b, Real c) {
        a.m[0] = a.m[0] - (b.m[1] * c.m[2] - b.m[2] * c.m[1]);
        a.m[1] = a.m[1] - (b.m[2] * c.m[0] - b.m[0] * c.m[2]);
        a.m[2] = a.m[2] - (b.m[0] * c.m[1] - b.m[1] * c.m[0]);
    }

    public static void dCROSS_MINUSEQUAL(RealPointer a, RealPointer b, RealPointer c) {
        int n = 0 + a.index;
        a.data.m[n] = a.data.m[n] - (b.data.m[1 + b.index] * c.data.m[2 + c.index] - b.data.m[2 + b.index] * c.data.m[1 + a.index]);
        int n2 = 1 + a.index;
        a.data.m[n2] = a.data.m[n2] - (b.data.m[2 + b.index] * c.data.m[0 + c.index] - b.data.m[0 + b.index] * c.data.m[2 + a.index]);
        int n3 = 2 + a.index;
        a.data.m[n3] = a.data.m[n3] - (b.data.m[0 + b.index] * c.data.m[1 + c.index] - b.data.m[1 + b.index] * c.data.m[0 + a.index]);
    }

    public static void dCROSS_EQUAL_MINUS(RealPointer a, Real b, Real c) {
        a.setValue(0, -(b.m[1] * c.m[2] - b.m[2] * c.m[1]));
        a.setValue(1, -(b.m[2] * c.m[0] - b.m[0] * c.m[2]));
        a.setValue(2, -(b.m[0] * c.m[1] - b.m[1] * c.m[0]));
    }

    public static void dCROSSMAT_PLUS_MINUS(Matrix3 A, Vector3 a, int skip) {
        A.m[1] = -a.m[2];
        A.m[2] = a.m[1];
        A.m[skip + 0] = a.m[2];
        A.m[skip + 2] = -a.m[0];
        A.m[2 * skip + 0] = -a.m[1];
        A.m[2 * skip + 1] = a.m[0];
    }

    public static void dCROSSMAT_PLUS_MINUS(RealPointer A, RealPointer a, int skip) {
        A.setValue(1, -a.getValue(2));
        A.setValue(2, a.getValue(1));
        A.setValue(skip + 0, a.getValue(2));
        A.setValue(skip + 2, -a.getValue(0));
        A.setValue(2 * skip + 0, -a.getValue(1));
        A.setValue(2 * skip + 1, a.getValue(0));
    }

    public static void dCROSSMAT_MINUS_PLUS(RealPointer A, RealPointer a, int skip) {
        A.setValue(1, a.getValue(2));
        A.setValue(2, -a.getValue(1));
        A.setValue(skip + 0, -a.getValue(2));
        A.setValue(skip + 2, a.getValue(0));
        A.setValue(2 * skip + 0, a.getValue(1));
        A.setValue(2 * skip + 1, -a.getValue(0));
    }

    private static void dMULTIPLYOP0_EQUAL_331(Real A, Real B, Real C, int as, int bs, int cs) {
        A.m[as + 0] = MathUtils.dDOT(B, C, bs, cs);
        A.m[as + 1] = MathUtils.dDOT(B, C, bs + 4, cs);
        A.m[as + 2] = MathUtils.dDOT(B, C, bs + 8, cs);
    }

    private static void dMULTIPLYOP0_ADDEQUAL_331(Real A, Real B, Real C, int as, int bs, int cs) {
        int n = as + 0;
        A.m[n] = A.m[n] + MathUtils.dDOT(B, C, bs, cs);
        int n2 = as + 1;
        A.m[n2] = A.m[n2] + MathUtils.dDOT(B, C, bs + 4, cs);
        int n3 = as + 2;
        A.m[n3] = A.m[n3] + MathUtils.dDOT(B, C, bs + 8, cs);
    }

    private static void dMULTIPLYOP1_EQUAL_331(Real A, Real B, Real C, int as, int bs, int cs) {
        A.m[as + 0] = MathUtils.dDOT41(B, C, bs, cs);
        A.m[as + 1] = MathUtils.dDOT41(B, C, bs + 1, cs);
        A.m[as + 2] = MathUtils.dDOT41(B, C, bs + 2, cs);
    }

    private static void dMULTIPLYOP0_EQUAL_333(Real A, Real B, Real C, int as, int bs, int cs) {
        A.m[as + 0] = MathUtils.dDOT14(B, C, bs, cs + 0);
        A.m[as + 1] = MathUtils.dDOT14(B, C, bs, cs + 1);
        A.m[as + 2] = MathUtils.dDOT14(B, C, bs, cs + 2);
        A.m[as + 4] = MathUtils.dDOT14(B, C, bs + 4, cs + 0);
        A.m[as + 5] = MathUtils.dDOT14(B, C, bs + 4, cs + 1);
        A.m[as + 6] = MathUtils.dDOT14(B, C, bs + 4, cs + 2);
        A.m[as + 8] = MathUtils.dDOT14(B, C, bs + 8, cs + 0);
        A.m[as + 9] = MathUtils.dDOT14(B, C, bs + 8, cs + 1);
        A.m[as + 10] = MathUtils.dDOT14(B, C, bs + 8, cs + 2);
    }

    private static void dMULTIPLYOP2_EQUAL_333(Real A, Real B, Real C, int as, int bs, int cs) {
        A.m[as + 0] = MathUtils.dDOT(B, C, bs, cs);
        A.m[as + 1] = MathUtils.dDOT(B, C, bs, cs + 4);
        A.m[as + 2] = MathUtils.dDOT(B, C, bs, cs + 8);
        A.m[as + 4] = MathUtils.dDOT(B, C, bs + 4, cs + 0);
        A.m[as + 5] = MathUtils.dDOT(B, C, bs + 4, cs + 4);
        A.m[as + 6] = MathUtils.dDOT(B, C, bs + 4, cs + 8);
        A.m[as + 8] = MathUtils.dDOT(B, C, bs + 8, cs + 0);
        A.m[as + 9] = MathUtils.dDOT(B, C, bs + 8, cs + 4);
        A.m[as + 10] = MathUtils.dDOT(B, C, bs + 8, cs + 8);
    }

    public static void dMULTIPLY0_331(Real A, Real B, Real C) {
        MathUtils.dMULTIPLYOP0_EQUAL_331(A, B, C, 0, 0, 0);
    }

    public static void dMULTIPLY0_331(RealPointer A, RealPointer B, RealPointer C) {
        MathUtils.dMULTIPLYOP0_EQUAL_331(A.data, B.data, C.data, A.index, B.index, C.index);
    }

    public static void dMULTIPLY0_331(Real A, RealPointer B, Real C) {
        MathUtils.dMULTIPLYOP0_EQUAL_331(A, B.data, C, 0, B.index, 0);
    }

    public static void dMULTIPLY0_331(Real A, Real B, Real C, int as, int bs, int cs) {
        MathUtils.dMULTIPLYOP0_EQUAL_331(A, B, C, as, bs, cs);
    }

    public static void dMULTIPLY0_331(RealPointer A, RealPointer B, Real C) {
        MathUtils.dMULTIPLYOP0_EQUAL_331(A.data, B.data, C, A.index, B.index, 0);
    }

    public static void dMULTIPLY1_331(Real A, Real B, Real C) {
        MathUtils.dMULTIPLYOP1_EQUAL_331(A, B, C, 0, 0, 0);
    }

    public static void dMULTIPLY0_333(Real A, Real B, Real C, int as, int bs, int cs) {
        MathUtils.dMULTIPLYOP0_EQUAL_333(A, B, C, as, bs, cs);
    }

    public static void dMULTIPLY0_333(RealPointer A, RealPointer B, RealPointer C) {
        MathUtils.dMULTIPLYOP0_EQUAL_333(A.data, B.data, C.data, A.index, B.index, C.index);
    }

    public static void dMULTIPLY0_333(RealPointer A, Real B, Real C) {
        MathUtils.dMULTIPLYOP0_EQUAL_333(A.data, B, C, A.index, 0, 0);
    }

    public static void dMULTIPLY0_333(RealPointer A, Real B, RealPointer C) {
        MathUtils.dMULTIPLYOP0_EQUAL_333(A.data, B, C.data, A.index, 0, C.index);
    }

    public static void dMULTIPLY2_333(RealPointer A, Real B, Real C) {
        MathUtils.dMULTIPLYOP2_EQUAL_333(A.data, B, C, A.index, 0, 0);
    }

    public static void dMULTIPLY2_333(Real A, Real B, Real C, int as, int bs, int cs) {
        MathUtils.dMULTIPLYOP2_EQUAL_333(A, B, C, as, bs, cs);
    }

    public static void dMULTIPLYADD0_331(Real A, Real B, Real C) {
        MathUtils.dMULTIPLYOP0_ADDEQUAL_331(A, B, C, 0, 0, 0);
    }

    public static void dMULTIPLYADD0_331(Real A, Real B, Real C, int as, int bs, int cs) {
        MathUtils.dMULTIPLYOP0_ADDEQUAL_331(A, B, C, as, bs, cs);
    }

    public static void dMultiply0(RealPointer A, RealPointer B, RealPointer C, int p, int q, int r) {
        A = tmpA.set(A);
        B = tmpB.set(B);
        C = tmpC.set(C);
        RealPointer b = tmpBB;
        RealPointer c = tmpCC;
        int i = p;
        while (i > 0) {
            int j = 0;
            while (j < r) {
                C.add(j, c);
                b.data = B.data;
                b.index = B.index;
                float sum = 0.0f;
                int k = q;
                while (k > 0) {
                    sum += b.getValue() * c.getValue();
                    b.add(1, b);
                    --k;
                    c = c.add(r, c);
                }
                A.setValue(sum);
                A.add(1, A);
                ++j;
            }
            B.add(q, B);
            --i;
        }
    }

    public static void dMultiply1(RealPointer A, RealPointer B, RealPointer C, int p, int q, int r) {
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < r) {
                float sum = 0.0f;
                int k = 0;
                while (k < q) {
                    sum += B.getValue(i + k * p) * C.getValue(j + k * r);
                    ++k;
                }
                A.setValue(i * r + j, sum);
                ++j;
            }
            ++i;
        }
    }

    public static void dMultiply2(RealPointer A, RealPointer B, RealPointer C, int p, int q, int r) {
        A = tmpA.set(A);
        B = tmpB.set(B);
        C = tmpC.set(C);
        int i = p;
        while (i != 0) {
            int j = r;
            while (j != 0) {
                int z = 0;
                float sum = 0.0f;
                int k = q;
                while (k != 0) {
                    sum += B.getValue(z) * C.getValue(z);
                    --k;
                    ++z;
                }
                A.setValue(sum);
                A = A.add(1, A);
                C = C.add(q, C);
                --j;
            }
            B = B.add(q, B);
            C.setIndex(0);
            --i;
        }
    }

    public static boolean dFactorCholesky(RealPointer A, int n) {
        A = tmpD.set(A);
        RealPointer a = tmpA;
        RealPointer b = tmpB;
        RealPointer aa = tmpAA;
        RealPointer bb = tmpBB;
        RealPointer cc = tmpCC;
        RealPointer recip = tmpC;
        recip = new RealPointer(new Real(n));
        aa = (RealPointer)A.clone();
        int i = 0;
        while (i < n) {
            int k;
            float sum;
            bb = (RealPointer)A.clone();
            cc = A.add(i * n, cc);
            int j = 0;
            while (j < i) {
                sum = cc.getValue();
                a = (RealPointer)aa.clone();
                b = (RealPointer)bb.clone();
                k = j;
                while (k != 0) {
                    sum -= a.getValue() * b.getValue();
                    a = a.add(1, a);
                    b = b.add(1, b);
                    --k;
                }
                cc.setValue(sum * recip.getValue(j));
                bb = bb.add(n, bb);
                cc = cc.add(1, cc);
                ++j;
            }
            sum = cc.getValue();
            a = (RealPointer)aa.clone();
            k = i;
            while (k != 0) {
                sum -= a.getValue() * a.getValue();
                --k;
                a = a.add(1, a);
            }
            if (sum <= 0.0f) {
                return false;
            }
            cc.setValue((float)Math.sqrt(sum));
            recip.setValue(i, 1.0f / cc.getValue());
            aa = aa.add(n, aa);
            ++i;
        }
        return true;
    }

    public static void dSolveCholesky(RealPointer L, RealPointer b, int n) {
        int k;
        float sum;
        RealPointer y = new RealPointer(new Real(n));
        int i = 0;
        while (i < n) {
            sum = 0.0f;
            k = 0;
            while (k < i) {
                sum += L.getValue(i * n + k) * y.getValue(k);
                ++k;
            }
            y.setValue(i, (b.getValue(i) - sum) / L.getValue(i * n + i));
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            sum = 0.0f;
            k = i + 1;
            while (k < n) {
                sum += L.getValue(k * n + i) * b.getValue(k);
                ++k;
            }
            b.setValue(i, (y.getValue(i) - sum) / L.getValue(i * n + i));
            --i;
        }
    }

    public static boolean dIsPositiveDefinite(Matrix a, int n) {
        return MathUtils.toVecmathMatrix(a).isPositiveDefinite(n);
    }

    public static void dSolveL1T(RealPointer L, RealPointer b, int n, int nskip) {
        int i = n - 2;
        while (i >= 0) {
            float sum = 0.0f;
            int j = i + 1;
            while (j < n) {
                sum += L.getValue(j * nskip + i) * b.getValue(j);
                ++j;
            }
            b.setValue(i, b.getValue(i) - sum);
            --i;
        }
    }

    private static void dVectorScale(RealPointer a, RealPointer d, int n) {
        int i = 0;
        while (i < n) {
            a.setValue(i, a.getValue(i) * d.getValue(i));
            ++i;
        }
    }

    public static void dSolveLDLT(RealPointer L, RealPointer d, RealPointer b, int n, int nskip) {
        FastLSolve.dSolveL1(L, b, n, nskip);
        MathUtils.dVectorScale(b, d, n);
        MathUtils.dSolveL1T(L, b, n, nskip);
    }

    public static final MatrixMxNf toVecmathMatrix(RealPointer rp, int numColumns, int numRows) {
        MatrixMxNf result = new MatrixMxNf(numRows, numColumns);
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numColumns) {
                int index = numColumns * i + j;
                result.set(i, j, rp.getValue(index));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final MatrixMxNf toVecmathMatrix(Matrix a) {
        int m = a.getRows();
        int n = a.getColumns();
        MatrixMxNf result = new MatrixMxNf(m, n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                result.set(i, j, a.get(j, i));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final RealPointer toODEMatrix(MatrixMxNf matrix) {
        RealPointer result = new RealPointer(new Real(matrix.getNumRows() * matrix.getNumCols()));
        int resultIndex = 0;
        int i = 0;
        while (i < matrix.getNumCols()) {
            int j = 0;
            while (j < matrix.getNumRows()) {
                result.setValue(resultIndex++, matrix.get(j, i));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final MatrixMxNf toVecmathMatrixReversePackingMatrix(RealPointer rp, int numColumns, int numRows) {
        MatrixMxNf result = new MatrixMxNf(numRows, numColumns);
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numColumns) {
                int index = numRows * j + i;
                result.set(i, j, rp.getValue(index));
                ++j;
            }
            ++i;
        }
        return result;
    }
}

