/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector2;

public strictfp class Matrix2 {
    public Vector2 col1 = new Vector2();
    public Vector2 col2 = new Vector2();

    public Matrix2() {
    }

    public Matrix2(float angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        this.col1.x = c;
        this.col2.x = -s;
        this.col1.y = s;
        this.col2.y = c;
    }

    public void set(Matrix3 matrix) {
        this.col1.set(matrix.get(0, 0), matrix.get(0, 1));
        this.col2.set(matrix.get(1, 0), matrix.get(1, 1));
    }

    public Matrix2(Vector2 col1, Vector2 col2) {
        this.col1.set(col1);
        this.col2.set(col2);
    }

    public Matrix2 transpose() {
        return new Matrix2(new Vector2(this.col1.x, this.col2.x), new Vector2(this.col1.y, this.col2.y));
    }

    public Matrix2 invert() {
        float a = this.col1.x;
        float b = this.col2.x;
        float c = this.col1.y;
        float d = this.col2.y;
        Matrix2 B = new Matrix2();
        float det = a * d - b * c;
        if (det == 0.0f) {
            throw new RuntimeException("Matrix2f: invert() - determinate is zero!");
        }
        det = 1.0f / det;
        B.col1.x = det * d;
        B.col2.x = -det * b;
        B.col1.y = -det * c;
        B.col2.y = det * a;
        return B;
    }
}

