/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.ROVector2;
import net.java.dev.joode.util.Vector3;

public strictfp class Vector2
implements ROVector2 {
    public float x;
    public float y;

    public Vector2() {
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final float getX() {
        return this.x;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public final float getY() {
        return this.y;
    }

    public Vector2(ROVector2 other) {
        this(other.getX(), other.getY());
    }

    public Vector2(Vector3 other) {
        this(other.getX(), other.getY());
    }

    public Vector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(ROVector2 other) {
        this.set(other.getX(), other.getY());
    }

    public float dot(ROVector2 other) {
        return this.x * other.getX() + this.y * other.getY();
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector3 vector3) {
        this.x = vector3.getX();
        this.y = vector3.getY();
    }

    public Vector2 negate() {
        return new Vector2(-this.x, -this.y);
    }

    public void add(ROVector2 v) {
        this.x += v.getX();
        this.y += v.getY();
    }

    public void sub(ROVector2 v) {
        this.x -= v.getX();
        this.y -= v.getY();
    }

    public void scale(float a) {
        this.x *= a;
        this.y *= a;
    }

    public void normalise() {
        float l = this.length();
        if (l == 0.0f) {
            return;
        }
        this.x /= l;
        this.y /= l;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public void projectOntoUnit(ROVector2 b, Vector2 result) {
        float dp = b.dot(this);
        result.x = dp * b.getX();
        result.y = dp * b.getY();
    }

    public String toString() {
        return "[Vec " + this.x + "," + this.y + " (" + this.length() + ")]";
    }

    public float distance(ROVector2 other) {
        float dx = other.getX() - this.getX();
        float dy = other.getY() - this.getY();
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public boolean equalsDelta(ROVector2 other, float delta) {
        return other.getX() - delta < this.x && other.getX() + delta > this.x && other.getY() - delta < this.y && other.getY() + delta > this.y;
    }

    public void perp(Vector2 passback) {
        passback.set(this.y, -this.x);
    }
}

