/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.FastMath;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;

public class Vector3
extends Real {
    public static final Pool<Vector3> pool = new Pool<Vector3>(){

        @Override
        protected Vector3 constuct() {
            return new Vector3();
        }

        @Override
        protected void reset(Vector3 object) {
            object.setZero();
        }
    };
    private static final StringBuffer buffer = new StringBuffer();
    public static final Vector3 ZERO = new Vector3();
    public static final Vector3 X = new Vector3(1.0f, 0.0f, 0.0f);
    public static final Vector3 Y = new Vector3(0.0f, 1.0f, 0.0f);
    public static final Vector3 Z = new Vector3(0.0f, 0.0f, 1.0f);

    public Vector3() {
        super(4);
    }

    public Vector3(float x, float y, float z) {
        this();
        this.m[0] = x;
        this.m[1] = y;
        this.m[2] = z;
    }

    public Vector3(Vector3 v) {
        this();
        this.m[0] = v.m[0];
        this.m[1] = v.m[1];
        this.m[2] = v.m[2];
    }

    public Vector3(Real r) {
        this();
        assert (r.size() >= 3);
        this.m[0] = r.m[0];
        this.m[1] = r.m[1];
        this.m[2] = r.m[2];
    }

    public static Vector3 aquire(float x, float y, float z) {
        Vector3 v = pool.aquire();
        v.set(x, y, z);
        return v;
    }

    public static Vector3 aquire() {
        return pool.aquire();
    }

    public void release() {
        pool.release(this);
    }

    public final float getX() {
        return this.m[0];
    }

    public final float getY() {
        return this.m[1];
    }

    public final float getZ() {
        return this.m[2];
    }

    public void set(float x, float y, float z) {
        this.m[0] = x;
        this.m[1] = y;
        this.m[2] = z;
    }

    public final void set(Vector3 v) {
        this.m[0] = v.m[0];
        this.m[1] = v.m[1];
        this.m[2] = v.m[2];
    }

    public final void setX(float x) {
        this.m[0] = x;
    }

    public final void setY(float y) {
        this.m[1] = y;
    }

    public final void setZ(float z) {
        this.m[2] = z;
    }

    public void add(float x, float y, float z) {
        this.m[0] = this.m[0] + x;
        this.m[1] = this.m[1] + y;
        this.m[2] = this.m[2] + z;
    }

    public Vector3 add(Vector3 v, Vector3 result) {
        result.m[0] = this.m[0] + v.m[0];
        result.m[1] = this.m[1] + v.m[1];
        result.m[2] = this.m[2] + v.m[2];
        return result;
    }

    public void sub(float x, float y, float z) {
        this.m[0] = this.m[0] - x;
        this.m[1] = this.m[1] - y;
        this.m[2] = this.m[2] - z;
    }

    public Vector3 cross(Vector3 v) {
        Vector3 a = new Vector3();
        a.m[0] = this.m[1] * v.m[2] - this.m[2] * v.m[1];
        a.m[1] = this.m[2] * v.m[0] - this.m[0] * v.m[2];
        a.m[2] = this.m[0] * v.m[1] - this.m[1] * v.m[0];
        return a;
    }

    public Vector3 cross(Vector3 v, Vector3 result) {
        result.m[0] = this.m[1] * v.m[2] - this.m[2] * v.m[1];
        result.m[1] = this.m[2] * v.m[0] - this.m[0] * v.m[2];
        result.m[2] = this.m[0] * v.m[1] - this.m[1] * v.m[0];
        return result;
    }

    public Vector3 crossMe(Vector3 v) {
        float m0 = this.m[1] * v.m[2] - this.m[2] * v.m[1];
        float m1 = this.m[2] * v.m[0] - this.m[0] * v.m[2];
        this.m[2] = this.m[0] * v.m[1] - this.m[1] * v.m[0];
        this.m[1] = m1;
        this.m[0] = m0;
        return this;
    }

    public void cross(Vector3 v, RealPointer result) {
        result.setValue(this.m[1] * v.m[2] - this.m[2] * v.m[1]);
        result.setValue(1, this.m[2] * v.m[0] - this.m[0] * v.m[2]);
        result.setValue(2, this.m[0] * v.m[1] - this.m[1] * v.m[0]);
    }

    public float cosAngle(Vector3 other) {
        return this.dot(other) / (this.norm() * other.norm());
    }

    public void bar(Matrix3 result) {
        result.set(0, 0, 0.0f);
        result.set(0, 1, this.m[2]);
        result.set(0, 2, -this.m[1]);
        result.set(1, 0, -this.m[2]);
        result.set(1, 1, 0.0f);
        result.set(1, 2, this.m[0]);
        result.set(2, 0, this.m[1]);
        result.set(2, 1, -this.m[0]);
        result.set(2, 2, 0.0f);
    }

    public float dot(RealPointer a) {
        float d = 0.0f;
        int i = 0;
        while (i < 3) {
            d += this.m[i] * a.getValue(i);
            ++i;
        }
        return d;
    }

    public float dist(Vector3 o) {
        return (float)Math.sqrt((this.m[0] - o.m[0]) * (this.m[0] - o.m[0]) + (this.m[1] - o.m[1]) * (this.m[1] - o.m[1]) + (this.m[2] - o.m[2]) * (this.m[2] - o.m[2]));
    }

    public float dist2D(Vector3 o) {
        return (float)Math.sqrt((this.m[0] - o.m[0]) * (this.m[0] - o.m[0]) + (this.m[1] - o.m[1]) * (this.m[1] - o.m[1]));
    }

    public float distSquared(Vector3 o) {
        return (this.m[0] - o.m[0]) * (this.m[0] - o.m[0]) + (this.m[1] - o.m[1]) * (this.m[1] - o.m[1]) + (this.m[2] - o.m[2]) * (this.m[2] - o.m[2]);
    }

    public float norm() {
        return (float)Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2]);
    }

    public float min() {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < 3) {
            min = Math.min(this.m[i], min);
            ++i;
        }
        return min;
    }

    public float max() {
        float max = Float.MIN_VALUE;
        int i = 0;
        while (i < 3) {
            max = Math.max(this.m[i], max);
            ++i;
        }
        return max;
    }

    public float mean() {
        float sum = 0.0f;
        int i = 0;
        while (i < 3) {
            sum += this.m[i];
            ++i;
        }
        return sum / 3.0f;
    }

    public float var() {
        float mean = this.mean();
        float sum2 = 0.0f;
        int i = 0;
        while (i < 3) {
            sum2 += (this.m[i] - mean) * (this.m[i] - mean);
            ++i;
        }
        return sum2 / 2.0f;
    }

    public float sum() {
        float sum = 0.0f;
        int i = 0;
        while (i < 3) {
            sum += this.m[i];
            ++i;
        }
        return sum;
    }

    public void constructPlaneSpace(Vector3 p, Vector3 q) {
        if (Math.abs(this.m[2]) > 0.70710677f) {
            float a = this.m[1] * this.m[1] + this.m[2] * this.m[2];
            float k = 1.0f / (float)Math.sqrt(a);
            p.m[0] = 0.0f;
            p.m[1] = -this.m[2] * k;
            p.m[2] = this.m[1] * k;
            q.m[0] = a * k;
            q.m[1] = -this.m[0] * p.m[2];
            q.m[2] = this.m[0] * p.m[1];
        } else {
            float a = this.m[0] * this.m[0] + this.m[1] * this.m[1];
            float k = 1.0f / (float)Math.sqrt(a);
            p.m[0] = -this.m[1] * k;
            p.m[1] = this.m[0] * k;
            p.m[2] = 0.0f;
            q.m[0] = -this.m[2] * p.m[1];
            q.m[1] = this.m[2] * p.m[0];
            q.m[2] = a * k;
        }
    }

    public static float planeVectorAngle(Vector3 planeNormal, Vector3 line) {
        return (float)Math.asin(line.dot(planeNormal) / (planeNormal.norm() * line.norm()));
    }

    public static float planePlaneAngle(Real normal1, Real normal2) {
        assert (Vector3.epsilonEquals(normal1.norm(), 1.0f, 0.001f));
        assert (Vector3.epsilonEquals(normal2.norm(), 1.0f, 0.001f));
        return FastMath.acos(normal1.dot(normal2));
    }

    public static float planePlaneCosAngle(Vector3 normal1, Vector3 normal2) {
        assert (Vector3.epsilonEquals(normal1.norm(), 1.0f, 0.001f));
        assert (Vector3.epsilonEquals(normal2.norm(), 1.0f, 0.001f));
        return normal1.dot(normal2);
    }

    public String toString() {
        buffer.setLength(0);
        return buffer.append("(").append(this.m[0]).append(", ").append(this.m[1]).append(", ").append(this.m[2]).append(")").toString();
    }

    public static Vector3 randomVector() {
        Vector3 ret = new Vector3();
        ret.m[0] = (float)Math.random();
        ret.m[1] = (float)Math.random();
        ret.m[2] = (float)Math.random();
        return ret;
    }

    public static boolean epsilonEquals(Vector3 a, Vector3 b, float e) {
        if (!Vector3.epsilonEquals(a.m[0], b.m[0], e)) {
            return false;
        }
        if (!Vector3.epsilonEquals(a.m[1], b.m[1], e)) {
            return false;
        }
        return Vector3.epsilonEquals(a.m[2], b.m[2], e);
    }

    public static Vector3 setRandom(Vector3 passback) {
        passback.m[0] = (float)Math.random();
        passback.m[1] = (float)Math.random();
        passback.m[2] = (float)Math.random();
        return passback;
    }
}

