/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.geometry;

import java.nio.FloatBuffer;
import java.util.Arrays;
import org.jagatoo.geometry.GeomNioFloatData;
import org.jagatoo.geometry.SimpleGeometryDataContainer;
import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryDataContainer
extends SimpleGeometryDataContainer {
    public static final int NORMALS = 2;
    public static final int COLORS = 4;
    public static final int TEXTURE_COORDINATES = 8;
    public static final int VERTEX_ATTRIBUTES = 16;
    protected GeomNioFloatData normals = null;
    protected GeomNioFloatData colors = null;
    protected GeomNioFloatData[] texCoords = null;
    protected GeomNioFloatData[] vertexAttribs = null;
    private boolean hasNormals = false;
    private boolean hasColors = false;
    protected int colorSize = 0;
    private final int[] textureUnitSize = new int[8];
    private final int[] vertexAttribsSize = new int[16];
    private int[] texCoordSetMap = new int[0];
    private int[] texCoordSetMap_public = new int[0];
    protected long normalsOffset = 0L;
    protected long colorsOffset = 0L;
    protected final long[] texCoordsOffsets = new long[8];
    protected final long[] vertexAttribsOffsets = new long[16];
    private int vertexFormat = 1;

    public final int getVertexFormat() {
        return this.vertexFormat;
    }

    public final boolean hasColorAlpha() {
        if (this.colors == null) {
            throw new Error("no colors set");
        }
        return this.colorSize == 4;
    }

    public final boolean hasFeature(int flag) {
        return (flag & this.vertexFormat) != 0;
    }

    public void addData(float[] coordData, float[] texCoordData, float[] normalData, float[] colorData) {
        if (coordData != null) {
            this.coords.set(coordData, 0, coordData.length);
        }
        if (texCoordData != null) {
            this.texCoords[0].set(texCoordData, 0, texCoordData.length);
        }
        if (normalData != null) {
            this.normals.set(normalData, 0, normalData.length);
        }
        if (colorData != null) {
            this.colors.set(colorData, 0, colorData.length);
        }
        this.numVertices += coordData.length / 3;
    }

    public void addData(float translateX, float translateY, float translateZ, int numVertices, float[] coordData, float[] texCoordData, float[] normalData, float[] colorData) {
        if (this.maxVertices <= this.numVertices + numVertices / 3) {
            return;
        }
        if (coordData != null) {
            int coordLength = numVertices * 3;
            float[] temp = new float[(int)((double)coordLength * 1.1)];
            System.arraycopy(coordData, 0, temp, 0, coordLength);
            int i = 0;
            while (i < numVertices) {
                int j = i * 3;
                temp[j + 0] = coordData[j + 0] + translateX;
                temp[j + 1] = coordData[j + 1] + translateY;
                temp[j + 2] = coordData[j + 2] + translateZ;
                ++i;
            }
            this.coords.set(temp, 0, coordLength);
        }
        if (texCoordData != null) {
            this.texCoords[0].set(texCoordData, 0, texCoordData.length);
        }
        if (normalData != null) {
            this.normals.set(normalData, 0, normalData.length);
        }
        if (colorData != null) {
            this.colors.set(colorData, 0, colorData.length);
        }
        this.numVertices += coordData.length / 3;
    }

    public void addData(float translateX, float translateY, float translateZ, int numVertices, float[] coordData, float[] texCoordData, float[] normalData, float alpha) {
        int colorLength = numVertices * 4;
        float[] tempColor = new float[(int)((double)colorLength * 1.1)];
        Arrays.fill(tempColor, 0, colorLength, alpha);
        this.addData(translateX, translateY, translateZ, numVertices, coordData, texCoordData, normalData, tempColor);
    }

    @Override
    public void setCoordinateData(GeomNioFloatData data) {
        super.setCoordinateData(data);
        this.vertexFormat |= 1;
    }

    public void setNormalData(GeomNioFloatData data) {
        this.normals = data;
        if (this.normals == null) {
            this.hasNormals = false;
            this.vertexFormat &= 0xFFFFFFFD;
        } else {
            this.hasNormals = true;
            this.vertexFormat |= 2;
        }
    }

    public final GeomNioFloatData getNormalsData() {
        return this.normals;
    }

    public final int getNormalsSize() {
        return 3;
    }

    public final long getNormalsOffset() {
        return this.normalsOffset;
    }

    public void setColorData(GeomNioFloatData data) {
        this.colors = data;
        if (this.colors == null) {
            this.hasColors = false;
            this.vertexFormat &= 0xFFFFFFFB;
        } else {
            this.hasColors = true;
            this.vertexFormat |= 4;
            this.colorSize = this.colors.getElemSize();
        }
    }

    public final GeomNioFloatData getColorData() {
        return this.colors;
    }

    public final int getColorsSize() {
        return this.colorSize;
    }

    public final long getColorsOffset() {
        return this.colorsOffset;
    }

    private final void rebuildTexCoordSetMap() {
        int numSetTUs = 0;
        int i = 0;
        while (i < this.texCoords.length) {
            if (this.texCoords[i] != null) {
                ++numSetTUs;
            }
            ++i;
        }
        if (this.texCoordSetMap.length != numSetTUs) {
            this.texCoordSetMap = new int[numSetTUs];
            this.texCoordSetMap_public = new int[numSetTUs];
        }
        int j = 0;
        int i2 = 0;
        while (i2 < this.texCoords.length) {
            this.texCoordSetMap[j++] = this.texCoords[i2] != null ? i2 : -1;
            ++i2;
        }
        System.arraycopy(this.texCoordSetMap, 0, this.texCoordSetMap_public, 0, this.texCoordSetMap.length);
    }

    public void setTexCoordData(int unit, GeomNioFloatData data) {
        if (data == null) {
            if (this.texCoords == null || unit >= this.texCoords.length) {
                return;
            }
        } else if (unit >= this.texCoords.length) {
            Object[] newTexCoords = new GeomNioFloatData[unit + 1];
            System.arraycopy(this.texCoords, 0, newTexCoords, 0, this.texCoords.length);
            Arrays.fill(newTexCoords, unit + 1, newTexCoords.length, null);
            this.texCoords = newTexCoords;
        }
        this.texCoords[unit] = data;
        this.textureUnitSize[unit] = data == null ? 0 : data.getElemSize();
        this.rebuildTexCoordSetMap();
        this.vertexFormat = this.getNumTextureUnits() == 0 ? (this.vertexFormat &= 0xFFFFFFF7) : (this.vertexFormat |= 8);
    }

    public final GeomNioFloatData getTexCoordsData(int unit) {
        if (this.texCoords == null) {
            return null;
        }
        if (this.texCoords.length > unit) {
            return this.texCoords[unit];
        }
        return null;
    }

    public final int getTexCoordSize(int unit) {
        return this.textureUnitSize[unit];
    }

    public final int getNumTextureUnits() {
        return this.texCoordSetMap.length;
    }

    public final int[] getTexCoordSetMap() {
        return this.texCoordSetMap_public;
    }

    public final void getTexCoordSetMap(int[] intArray) {
        System.arraycopy(this.texCoordSetMap, 0, intArray, 0, this.texCoordSetMap.length);
    }

    public final long getTexCoordsOffset(int unit) {
        return this.texCoordsOffsets[unit];
    }

    public final GeomNioFloatData getVertexAttribData(int index) {
        if (this.vertexAttribs == null) {
            return null;
        }
        if (this.vertexAttribs.length > index) {
            return this.vertexAttribs[index];
        }
        return null;
    }

    public final int getVertexAttribSize(int index) {
        return this.vertexAttribsSize[index];
    }

    public final long getVertexAttribsOffset(int index) {
        return this.vertexAttribsOffsets[index];
    }

    @Override
    protected void createCoordinates() {
        super.createCoordinates();
        this.vertexFormat |= 1;
    }

    public final boolean hasNormals() {
        return this.hasNormals;
    }

    private final void createNormals() {
        this.normals = this.newNioFloatData(this.maxVertices, this.getNormalsSize(), 0, false);
        this.hasNormals = true;
        this.vertexFormat |= 2;
    }

    protected final boolean checkNormalsExistence(boolean b) {
        if (this.normals == null) {
            if (!b) {
                return false;
            }
            this.createNormals();
            if (this.isInterleaved()) {
                this.makeInterleaved();
            }
        }
        return true;
    }

    public void setNormal(int vertexIndex, float[] floatArray) {
        if (!this.checkNormalsExistence(floatArray != null)) {
            return;
        }
        this.normals.set(vertexIndex, this.getNormalsSize(), this.normalsOffset / 4L, floatArray, 0, this.getNormalsSize());
    }

    public void setNormal(int vertexIndex, Vector3f vector3f) {
        if (!this.checkNormalsExistence(vector3f != null)) {
            return;
        }
        this.normals.set(vertexIndex, this.getNormalsOffset() / 4L, vector3f);
    }

    public void setNormals(int vertexIndex, float[] floatArray) {
        if (!this.checkNormalsExistence(floatArray != null)) {
            return;
        }
        assert (floatArray.length % 3 == 0);
        this.normals.set(vertexIndex, this.getNormalsSize(), this.normalsOffset / 4L, floatArray);
    }

    public void setNormals(int vertexIndex, Vector3f[] vector3fArray) {
        if (!this.checkNormalsExistence(vector3fArray != null)) {
            return;
        }
        int i = 0;
        while (i < vector3fArray.length) {
            this.normals.set(vertexIndex + i, this.getNormalsOffset() / 4L, vector3fArray[i]);
            ++i;
        }
    }

    public void setNormals(int vertexIndex, float[] floatArray, int startIndex, int length) {
        if (!this.checkNormalsExistence(floatArray != null)) {
            return;
        }
        assert (floatArray.length % 3 == 0);
        this.normals.set(vertexIndex, this.getNormalsSize(), this.normalsOffset / 4L, floatArray, startIndex * this.getNormalsSize(), length * this.getNormalsSize());
    }

    public void setNormals(int vertexIndex, Vector3f[] vector3fArray, int startIndex, int length) {
        if (!this.checkNormalsExistence(vector3fArray != null)) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.normals.set(vertexIndex + i, this.getNormalsOffset() / 4L, vector3fArray[startIndex + i]);
            ++i;
        }
    }

    public void setNormal(int vertexIndex, float x, float y, float z) {
        if (!this.checkNormalsExistence(true)) {
            return;
        }
        this.normals.set(vertexIndex, this.normalsOffset / 4L, x, y, z);
    }

    public void getNormal(int vertexIndex, float[] floatArray) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("No normals defined");
        }
        this.normals.get(vertexIndex, 3, this.normalsOffset / 4L, floatArray, 0, 3);
    }

    public Vector3f getNormal(int index, Vector3f normal) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("No normals defined");
        }
        this.normals.get(index, this.getNormalsOffset() / 4L, normal);
        return normal;
    }

    public void getNormals(int vertexIndex, float[] floatArray) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("No normals defined");
        }
        int i = 0;
        while (i < floatArray.length / 3) {
            this.normals.get(vertexIndex + i * 3, 3, this.normalsOffset / 4L, floatArray, i * 3, 3);
            ++i;
        }
    }

    public void getNormals(int index0, Vector3f[] vector3fArray) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("No normals defined");
        }
        int i = vector3fArray.length - 1;
        while (i > -1) {
            this.normals.get(i - index0, this.getNormalsOffset() / 4L, vector3fArray[i]);
            --i;
        }
    }

    public final boolean hasColors() {
        return this.hasColors;
    }

    private final void createColors(int colorSize) {
        this.colors = this.newNioFloatData(this.maxVertices, colorSize, 0, false);
        this.colorSize = colorSize;
        this.hasColors = true;
        this.vertexFormat |= 4;
    }

    protected final boolean checkColorsExistence(int colorSize, boolean b) {
        if (this.colors == null) {
            if (!b) {
                return false;
            }
            if (colorSize != 3 && colorSize != 4) {
                throw new IllegalArgumentException("illegal color size");
            }
            this.createColors(colorSize);
            if (this.isInterleaved()) {
                this.makeInterleaved();
            }
        } else if (this.colorSize != colorSize) {
            throw new IllegalArgumentException("mismatching color size");
        }
        return true;
    }

    public void setColor(int vertexIndex, float[] floatArray) {
        int l = floatArray != null ? floatArray.length : 0;
        if (!this.checkColorsExistence(l, floatArray != null)) {
            return;
        }
        this.colors.set(vertexIndex, this.colorSize, this.colorsOffset / 4L, floatArray, 0, this.colorSize);
    }

    public void setColor(int vertexIndex, Colorf colorf) {
        int s;
        int n = colorf != null ? (colorf.hasAlpha() ? 4 : 3) : (s = 3);
        if (!this.checkColorsExistence(s, colorf != null)) {
            return;
        }
        this.colors.set(vertexIndex, this.colorSize, this.colorsOffset / 4L, colorf);
    }

    public void setColors(int vertexIndex, int colorSize, float[] floatArray) {
        if (colorSize != 4 && colorSize != 3) {
            throw new IllegalArgumentException("Illegal color-size " + colorSize);
        }
        if (!this.checkColorsExistence(colorSize, floatArray != null)) {
            return;
        }
        assert (floatArray.length % colorSize == 0);
        this.colors.set(vertexIndex, colorSize, this.colorsOffset / 4L, floatArray);
    }

    public void setColors(int vertexIndex, Colorf[] colorfArray) {
        int s;
        int n = colorfArray != null ? (colorfArray[0].hasAlpha() ? 4 : 3) : (s = 3);
        if (!this.checkColorsExistence(s, colorfArray != null)) {
            return;
        }
        int i = 0;
        while (i < colorfArray.length) {
            this.colors.set(vertexIndex + i, this.colorSize, this.colorsOffset / 4L, colorfArray[i]);
            ++i;
        }
    }

    public void setColors(int vertexIndex, int colorSize, float[] floatArray, int startIndex, int length) {
        if (colorSize != 4 && colorSize != 3) {
            throw new IllegalArgumentException("Illegal color-size " + colorSize);
        }
        if (!this.checkColorsExistence(colorSize, floatArray != null)) {
            return;
        }
        assert (floatArray.length % colorSize == 0);
        this.colors.set(vertexIndex, colorSize, this.colorsOffset / 4L, floatArray, startIndex * colorSize, length * colorSize);
    }

    public void setColors(int vertexIndex, Colorf[] colorfArray, int startIndex, int length) {
        int colorSize;
        int n = colorfArray != null ? (colorfArray[0].hasAlpha() ? 4 : 3) : (colorSize = 3);
        if (!this.checkColorsExistence(colorSize, colorfArray != null)) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.colors.set(vertexIndex + i, colorSize, this.colorsOffset / 4L, colorfArray[startIndex + i]);
            ++i;
        }
    }

    public void setColor(int vertexIndex, float r, float g, float b) {
        if (!this.checkColorsExistence(3, true)) {
            return;
        }
        this.colors.set(vertexIndex, this.colorsOffset / 4L, r, g, b);
    }

    public void setColor(int vertexIndex, float r, float g, float b, float a) {
        if (!this.checkColorsExistence(4, true)) {
            return;
        }
        this.colors.set(vertexIndex, this.colorsOffset / 4L, r, g, b, a);
    }

    public void getColor(int vertexIndex, float[] floatArray) {
        if (!this.hasColors()) {
            throw new Error("No colors set");
        }
        this.colors.get(vertexIndex, this.colorSize, this.colorsOffset / 4L, floatArray, 0, this.colorSize);
    }

    public Colorf getColor(int vertexIndex, Colorf colorf) {
        if (!this.hasColors()) {
            throw new Error("No colors set");
        }
        this.colors.get(vertexIndex, this.colorSize, this.colorsOffset / 4L, colorf);
        return colorf;
    }

    public void getColors(int vertexIndex, float[] floatArray) {
        if (!this.hasColors()) {
            throw new Error("No colors set");
        }
        int i = 0;
        while (i < floatArray.length / this.colorSize) {
            this.colors.get(vertexIndex + i * this.colorSize, this.colorSize, this.colorsOffset / 4L, floatArray, i * this.colorSize, this.colorSize);
            ++i;
        }
    }

    public final boolean hasTextureCoordinates() {
        return this.texCoordSetMap.length > 0;
    }

    public final boolean hasTextureCoordinates(int unit) {
        if (this.texCoords == null) {
            return false;
        }
        return this.texCoords.length > unit && this.texCoords[unit] != null;
    }

    private final void createTexCoord(int unit, int texCoordSize) {
        this.texCoords[unit] = this.newNioFloatData(this.maxVertices, texCoordSize, 0, false);
        this.textureUnitSize[unit] = texCoordSize;
        this.vertexFormat |= 8;
    }

    protected final boolean checkTexCoordExistence(int unit, int texCoordSize, boolean b) {
        if (this.texCoords == null) {
            if (!b) {
                return false;
            }
            this.texCoords = new GeomNioFloatData[unit + 1];
            this.createTexCoord(unit, texCoordSize);
            this.rebuildTexCoordSetMap();
            if (this.isInterleaved()) {
                this.makeInterleaved();
            }
            return true;
        }
        if (unit < this.texCoords.length) {
            GeomNioFloatData old = this.texCoords[unit];
            if (old == null) {
                this.createTexCoord(unit, texCoordSize);
                this.rebuildTexCoordSetMap();
                if (this.isInterleaved()) {
                    this.makeInterleaved();
                }
                return true;
            }
            if (this.textureUnitSize[unit] == texCoordSize) {
                return true;
            }
            throw new IllegalArgumentException("mismatching TexCoord size");
        }
        GeomNioFloatData[] texCoords2 = new GeomNioFloatData[unit + 1];
        System.arraycopy(this.texCoords, 0, texCoords2, 0, this.texCoords.length);
        this.texCoords = texCoords2;
        this.createTexCoord(unit, texCoordSize);
        this.rebuildTexCoordSetMap();
        if (this.isInterleaved()) {
            this.makeInterleaved();
        }
        return true;
    }

    public void setTextureCoordinate(int unit, int vertexIndex, float[] floatArray) {
        if (floatArray.length < 1 || floatArray.length > 4) {
            throw new IllegalArgumentException("texture coords must be of size 1, 2, 3 or 4");
        }
        this.checkTexCoordExistence(unit, floatArray.length, true);
        this.texCoords[unit].set(vertexIndex, this.textureUnitSize[unit], this.texCoordsOffsets[unit] / 4L, floatArray, 0, floatArray.length);
    }

    public void setTextureCoordinate(int unit, int vertexIndex, TexCoordf<?> texCoord) {
        this.checkTexCoordExistence(unit, texCoord.getSize(), true);
        this.texCoords[unit].set(vertexIndex, this.texCoordsOffsets[unit] / 4L, texCoord);
    }

    public void setTextureCoordinates(int unit, int vertexIndex, int texCoordSize, float[] floatArray) {
        if (texCoordSize < 1 || texCoordSize > 4) {
            throw new IllegalArgumentException("texture coords must be of size 1, 2, 3 or 4");
        }
        this.checkTexCoordExistence(unit, texCoordSize, true);
        this.texCoords[unit].set(vertexIndex, this.textureUnitSize[unit], this.texCoordsOffsets[unit] / 4L, floatArray, 0, floatArray.length);
    }

    public void setTextureCoordinates(int unit, int vertexIndex, TexCoordf<?>[] texCoordArray) {
        this.checkTexCoordExistence(unit, texCoordArray[0].getSize(), true);
        int i = 0;
        while (i < texCoordArray.length) {
            this.texCoords[unit].set(vertexIndex + i, this.texCoordsOffsets[unit] / 4L, texCoordArray[i]);
            ++i;
        }
    }

    public void setTextureCoordinates(int unit, int vertexIndex, int texCoordSize, float[] floatArray, int startIndex, int length) {
        this.checkTexCoordExistence(unit, texCoordSize, true);
        this.texCoords[unit].set(vertexIndex, this.textureUnitSize[unit], this.texCoordsOffsets[unit] / 4L, floatArray, startIndex * texCoordSize, length * texCoordSize);
    }

    public void setTextureCoordinates(int unit, int vertexIndex, TexCoordf<?>[] texCoordArray, int startIndex, int length) {
        this.checkTexCoordExistence(unit, texCoordArray[0].getSize(), true);
        int i = 0;
        while (i < length) {
            this.texCoords[unit].set(vertexIndex + i, this.texCoordsOffsets[unit] / 4L, texCoordArray[startIndex + i]);
            ++i;
        }
    }

    public void setTextureCoordinate(int unit, int vertexIndex, float s) {
        this.checkTexCoordExistence(unit, 1, true);
        this.texCoords[unit].set(vertexIndex, this.texCoordsOffsets[unit] / 4L, s);
    }

    public void setTextureCoordinate(int unit, int vertexIndex, float s, float t) {
        this.checkTexCoordExistence(unit, 2, true);
        this.texCoords[unit].set(vertexIndex, this.texCoordsOffsets[unit] / 4L, s, t);
    }

    public void setTextureCoordinate(int unit, int vertexIndex, float s, float t, float r) {
        this.checkTexCoordExistence(unit, 3, true);
        this.texCoords[unit].set(vertexIndex, this.texCoordsOffsets[unit] / 4L, s, t, r);
    }

    public void setTextureCoordinate(int unit, int vertexIndex, float s, float t, float r, float q) {
        this.checkTexCoordExistence(unit, 4, true);
        this.texCoords[unit].set(vertexIndex, this.texCoordsOffsets[unit] / 4L, s, t, r, q);
    }

    public void getTextureCoordinate(int unit, int vertexIndex, float[] floatArray) {
        if (floatArray == null) {
            throw new NullPointerException("The passed value buffer is null");
        }
        int size = this.getTexCoordSize(unit);
        if (size <= 0) {
            throw new Error("This TextureCoodinate does not exist");
        }
        this.texCoords[unit].get(vertexIndex, size, this.texCoordsOffsets[unit] / 4L, floatArray, 0, size);
    }

    public <T extends TexCoordf<?>> T getTextureCoordinate(int unit, int vertexIndex, T texCoord) {
        int size = this.getTexCoordSize(unit);
        if (size <= 0) {
            throw new Error("This TextureCoodinate does not exist");
        }
        if (size != texCoord.getSize()) {
            throw new Error("Mismatching texture coord size (" + texCoord.getSize() + " != " + size + ")");
        }
        this.texCoords[unit].get(vertexIndex, this.texCoordsOffsets[unit] / 4L, texCoord);
        return texCoord;
    }

    public void getTextureCoordinates(int unit, int vertexIndex, float[] floatArray) {
        if (!this.hasTextureCoordinates(unit)) {
            throw new Error("The texture unti " + unit + " does not yet have texture coordinate data.");
        }
        int size = this.getTexCoordSize(unit);
        this.texCoords[unit].get(vertexIndex, size, this.texCoordsOffsets[unit] / 4L, floatArray, 0, floatArray.length / size);
    }

    public final boolean hasVertexAttributes() {
        return this.vertexAttribs != null;
    }

    public final boolean hasVertexAttributes(int attribIndex) {
        if (this.vertexAttribs == null) {
            return false;
        }
        return this.vertexAttribs.length > attribIndex && this.vertexAttribs[attribIndex] != null;
    }

    public final int getVertexAttributesCount() {
        if (this.vertexAttribs == null) {
            return 0;
        }
        return this.vertexAttribs.length;
    }

    private final void createVertexAttribute(int attribIndex, int attribSize) {
        this.vertexAttribs[attribIndex] = this.newNioFloatData(this.maxVertices, attribSize, 0, false);
        this.vertexAttribsSize[attribIndex] = attribSize;
        this.vertexFormat |= 0x10;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void checkAttributeExistence(int attribIndex, int attribSize, boolean b) {
        if (this.vertexAttribs == null) {
            if (!b) {
                return;
            }
            this.vertexAttribs = new GeomNioFloatData[attribIndex + 1];
            this.createVertexAttribute(attribIndex, attribSize);
            if (!this.isInterleaved()) return;
            this.makeInterleaved();
            return;
        }
        if (attribIndex >= this.vertexAttribs.length) {
            GeomNioFloatData[] vertexAttribs2 = new GeomNioFloatData[attribIndex + 1];
            System.arraycopy(this.vertexAttribs, 0, vertexAttribs2, 0, this.vertexAttribs.length);
            this.vertexAttribs = vertexAttribs2;
            this.createVertexAttribute(attribIndex, attribSize);
            if (!this.isInterleaved()) return;
            this.makeInterleaved();
            return;
        }
        GeomNioFloatData old = this.vertexAttribs[attribIndex];
        if (old == null) {
            this.createVertexAttribute(attribIndex, attribSize);
            if (!this.isInterleaved()) return;
            this.makeInterleaved();
            return;
        }
        if (this.vertexAttribsSize[attribIndex] != attribSize) throw new IllegalArgumentException("mismatching attribute size");
    }

    public void setVertexAttribute(int attribIndex, int vertexIndex, float[] floatArray) {
        if (floatArray.length < 1 || floatArray.length > 4) {
            throw new IllegalArgumentException("vertex attributes must be of size 1, 2, 3 or 4");
        }
        this.checkAttributeExistence(attribIndex, floatArray.length, true);
        this.vertexAttribs[attribIndex].set(vertexIndex, floatArray.length, this.vertexAttribsOffsets[attribIndex] / 4L, floatArray);
    }

    public void setVertexAttribute(int attribIndex, int vertexIndex, TupleNf<?> value) {
        this.checkAttributeExistence(attribIndex, value.getSize(), true);
        this.vertexAttribs[attribIndex].set(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L, value);
    }

    public void setVertexAttributes(int attribIndex, int vertexIndex, float[] values, int attribSize) {
        if (attribSize < 1 || attribSize > 4) {
            throw new IllegalArgumentException("vertex attributes must be of size 1, 2, 3 or 4");
        }
        this.checkAttributeExistence(attribIndex, attribSize, values != null);
        if (values == null) {
            return;
        }
        this.vertexAttribs[attribIndex].set(vertexIndex, attribSize, this.vertexAttribsOffsets[attribIndex] / 4L, values);
    }

    public void setVertexAttributes(int attribIndex, int vertexIndex, TupleNf<?>[] values) {
        int s = values != null ? values[0].getSize() : 0;
        this.checkAttributeExistence(attribIndex, s, values != null);
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            this.vertexAttribs[attribIndex].set(vertexIndex + i, this.vertexAttribsOffsets[attribIndex] / 4L, values[i]);
            ++i;
        }
    }

    public void setVertexAttributes(int attribIndex, int vertexIndex, float[] values, int attribsSize, int startIndex, int length) {
        if (attribsSize < 1 || attribsSize > 4) {
            throw new IllegalArgumentException("vertex attributes must be of size 1, 2, 3 or 4");
        }
        this.checkAttributeExistence(attribIndex, attribsSize, values != null);
        if (values == null) {
            return;
        }
        this.vertexAttribs[attribIndex].set(vertexIndex, attribsSize, this.vertexAttribsOffsets[attribIndex] / 4L, values, startIndex * attribsSize, length * attribsSize);
    }

    public void setVertexAttributes(int attribIndex, int vertexIndex, TupleNf<?>[] values, int startIndex, int length) {
        int s = values != null ? values[0].getSize() : 0;
        this.checkAttributeExistence(attribIndex, s, values != null);
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.vertexAttribs[attribIndex].set(vertexIndex + i, this.vertexAttribsOffsets[attribIndex] / 4L, values[startIndex + i]);
            ++i;
        }
    }

    public void setVertexAttribute(int attribIndex, int vertexIndex, float value) {
        this.checkAttributeExistence(attribIndex, 1, true);
        this.vertexAttribs[attribIndex].set(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L, value);
    }

    public void getVertexAttribute(int attribIndex, int vertexIndex, float[] floatArray) {
        if (!this.hasVertexAttributes(attribIndex)) {
            throw new Error("This vertex attribute does not exist.");
        }
        this.vertexAttribs[attribIndex].getData(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L, floatArray, 0, floatArray.length / this.getVertexAttribSize(attribIndex));
    }

    public void getVertexAttribute(int attribIndex, int vertexIndex, TupleNf<?> value) {
        if (!this.hasVertexAttributes(attribIndex)) {
            throw new IllegalStateException("vertex attribute " + attribIndex + " does not exist.");
        }
        this.vertexAttribs[attribIndex].get(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L, value);
    }

    public void getVertexAttributes(int attribIndex, int vertexIndex, float[] floatArray) {
        if (!this.hasVertexAttributes(attribIndex)) {
            throw new Error("This vertex attribute does not exist.");
        }
        this.vertexAttribs[attribIndex].getData(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L, floatArray, 0, floatArray.length / this.getVertexAttribSize(attribIndex));
    }

    public float getVertexAttribute(int attribIndex, int vertexIndex) {
        if (!this.hasVertexAttributes(attribIndex)) {
            throw new IllegalStateException("vertex attribute " + attribIndex + " does not exist.");
        }
        return this.vertexAttribs[attribIndex].get(vertexIndex, this.vertexAttribsOffsets[attribIndex] / 4L);
    }

    @Override
    public boolean setTriangle(int i0, int i1, int i2, Triangle triangle) {
        super.setTriangle(i0, i1, i2, triangle);
        if (triangle.hasFeature(2)) {
            this.setNormal(i0, triangle.getVertexNormalA());
            this.setNormal(i1, triangle.getVertexNormalB());
            this.setNormal(i2, triangle.getVertexNormalC());
        }
        if (triangle.hasFeature(4)) {
            this.setColor(i0, triangle.getVertexColorA());
            this.setColor(i1, triangle.getVertexColorB());
            this.setColor(i2, triangle.getVertexColorC());
        }
        if (triangle.hasFeature(8) && this.getTexCoordSize(0) == triangle.getTexCoordsSize()) {
            this.setTextureCoordinate(0, i0, triangle.getVertexTexCoordA());
            this.setTextureCoordinate(0, i1, triangle.getVertexTexCoordB());
            this.setTextureCoordinate(0, i2, triangle.getVertexTexCoordC());
        }
        return true;
    }

    @Override
    public boolean getTriangle(int i0, int i1, int i2, Triangle triangle) {
        super.getTriangle(i0, i1, i2, triangle);
        if (this.hasFeature(2) && triangle.hasFeature(2)) {
            this.getNormal(i0, triangle.getVertexNormalA());
            this.getNormal(i1, triangle.getVertexNormalB());
            this.getNormal(i2, triangle.getVertexNormalC());
        }
        if (this.hasFeature(4) && triangle.hasFeature(4)) {
            this.getColor(i0, triangle.getVertexColorA());
            this.getColor(i1, triangle.getVertexColorB());
            this.getColor(i2, triangle.getVertexColorC());
        }
        if (this.hasFeature(8) && triangle.hasFeature(8) && this.getTexCoordSize(0) == triangle.getTexCoordsSize()) {
            this.getTextureCoordinate(0, i0, triangle.getVertexTexCoordA());
            this.getTextureCoordinate(0, i1, triangle.getVertexTexCoordB());
            this.getTextureCoordinate(0, i2, triangle.getVertexTexCoordC());
        }
        triangle.setVertexIndices(i0, i1, i2);
        return true;
    }

    public float[] getColorRefFloat() {
        return this.colors == null ? null : this.colors.getData();
    }

    public float[] getNormalRefFloat() {
        return this.normals == null ? null : this.normals.getData();
    }

    public float[] getTexCoordRefFloat(int unit) {
        return this.texCoords == null ? null : (this.texCoords[unit] == null ? null : this.texCoords[unit].getData());
    }

    public void makeInterleaved(int features, boolean colorAlpha, int[] tuSizes, int[] vaSizes) {
        int i;
        int t;
        int i2;
        int stride = 0;
        if ((features & 1) != 0) {
            stride += 3;
        }
        if ((features & 2) != 0) {
            stride += 3;
        }
        if ((features & 4) != 0) {
            stride = colorAlpha ? (stride += 4) : (stride += 3);
        }
        if ((features & 8) != 0) {
            i2 = 0;
            while (i2 < tuSizes.length) {
                stride += tuSizes[i2];
                ++i2;
            }
        }
        if ((features & 0x10) != 0) {
            i2 = 0;
            while (i2 < vaSizes.length) {
                stride += vaSizes[i2];
                ++i2;
            }
        }
        int numVertices = this.getVertexCount();
        GeomNioFloatData interData = this.newNioFloatData(numVertices, stride, stride * 4, false);
        FloatBuffer interBuff = interData.getBuffer();
        int colorSize = colorAlpha ? 4 : 3;
        float[] values = new float[4];
        int i3 = 0;
        while (i3 < numVertices) {
            if (this.isInterleaved || this.coords != null) {
                this.getCoordinate(i3, values);
                interBuff.put(values, 0, this.getCoordinatesSize());
            }
            if (this.hasNormals) {
                this.getNormal(i3, values);
                interBuff.put(values, 0, 3);
            }
            if (this.hasColors) {
                values[3] = 0.0f;
                this.getColor(i3, values);
                interBuff.put(values, 0, colorSize);
            }
            if (tuSizes != null) {
                t = 0;
                while (t < tuSizes.length) {
                    if (this.hasTextureCoordinates(t)) {
                        values[0] = 0.0f;
                        values[1] = 0.0f;
                        values[2] = 0.0f;
                        values[3] = 0.0f;
                        this.getTextureCoordinate(t, i3, values);
                        interBuff.put(values, 0, tuSizes[t]);
                    } else {
                        interBuff.position(interBuff.position() + tuSizes[t]);
                    }
                    ++t;
                }
            }
            if (vaSizes != null) {
                int j = 0;
                while (j < vaSizes.length) {
                    if (this.hasVertexAttributes(j)) {
                        values[0] = 0.0f;
                        values[1] = 0.0f;
                        values[2] = 0.0f;
                        values[3] = 0.0f;
                        this.getVertexAttribute(j, i3, values);
                        interBuff.put(values, 0, vaSizes[j]);
                    } else {
                        interBuff.position(interBuff.position() + vaSizes[j]);
                    }
                    ++j;
                }
            }
            ++i3;
        }
        if (tuSizes != null) {
            int numTUs = 0;
            t = 0;
            while (t < tuSizes.length) {
                if (tuSizes[t] > 0) {
                    ++numTUs;
                }
                ++t;
            }
            this.texCoordSetMap = new int[numTUs];
            int t2 = 0;
            int t3 = 0;
            while (t3 < tuSizes.length) {
                if (tuSizes[t3] > 0) {
                    this.texCoordSetMap[t2++] = t3;
                }
                ++t3;
            }
            this.texCoordSetMap_public = new int[this.texCoordSetMap.length];
            System.arraycopy(this.texCoordSetMap, 0, this.texCoordSetMap_public, 0, this.texCoordSetMap.length);
        }
        this.texCoords = null;
        int t4 = 0;
        while (t4 < this.textureUnitSize.length) {
            this.textureUnitSize[t4] = tuSizes == null || tuSizes.length <= t4 ? 0 : (t4 < tuSizes.length ? tuSizes[t4] : 0);
            ++t4;
        }
        this.vertexAttribs = null;
        int j = 0;
        while (j < this.vertexAttribsSize.length) {
            this.vertexAttribsSize[j] = vaSizes == null || vaSizes.length <= j ? 0 : (j < vaSizes.length ? vaSizes[j] : vaSizes[j]);
            ++j;
        }
        this.interleavedData = interData;
        this.coords = (features & 1) != 0 ? this.interleavedData : null;
        this.normals = (features & 2) != 0 ? this.interleavedData : null;
        GeomNioFloatData geomNioFloatData = this.colors = (features & 4) != 0 ? this.interleavedData : null;
        if ((features & 8) != 0) {
            this.texCoords = new GeomNioFloatData[tuSizes.length];
            i3 = 0;
            while (i3 < tuSizes.length) {
                this.texCoords[i3] = tuSizes[i3] > 0 ? this.interleavedData : null;
                ++i3;
            }
        } else {
            this.texCoords = null;
        }
        if ((features & 0x10) != 0) {
            this.vertexAttribs = new GeomNioFloatData[vaSizes.length];
            i3 = 0;
            while (i3 < vaSizes.length) {
                this.vertexAttribs[i3] = vaSizes[i3] > 0 ? this.interleavedData : null;
                ++i3;
            }
        } else {
            this.vertexAttribs = null;
        }
        this.colorSize = (features & 4) != 0 ? (colorAlpha ? 4 : 3) : 0;
        long offset = 0L;
        if ((features & 1) != 0) {
            this.coordsOffset = offset * 4L;
            offset += 3L;
        }
        if ((features & 2) != 0) {
            this.normalsOffset = offset * 4L;
            offset += 3L;
            this.hasNormals = true;
        }
        if ((features & 4) != 0) {
            this.colorsOffset = offset * 4L;
            offset = colorAlpha ? (offset += 3L) : (offset += 4L);
            this.hasColors = true;
        }
        if ((features & 8) != 0) {
            i = 0;
            while (i < tuSizes.length) {
                this.texCoordsOffsets[i] = offset * 4L;
                offset += (long)tuSizes[i];
                ++i;
            }
        }
        if ((features & 0x10) != 0) {
            i = 0;
            while (i < vaSizes.length) {
                this.vertexAttribsOffsets[i] = offset * 4L;
                offset += (long)vaSizes[i];
                ++i;
            }
        }
        this.vertexFormat = features;
        this.isInterleaved = true;
    }

    public void makeInterleaved() {
        int[] vaSizes;
        int[] tuSizes;
        boolean colorAlpha;
        if (this.coords == null) {
            throw new Error("You cannot use the parameterless makeInterleaved() method before any geometry data has been initialized.");
        }
        int features = this.getVertexFormat();
        boolean bl = colorAlpha = this.hasColors() ? this.hasColorAlpha() : false;
        if (this.texCoords == null) {
            tuSizes = null;
        } else {
            tuSizes = new int[this.texCoords.length];
            int i = 0;
            while (i < this.texCoords.length) {
                tuSizes[i] = this.textureUnitSize[i];
                ++i;
            }
        }
        if (this.vertexAttribs == null) {
            vaSizes = null;
        } else {
            vaSizes = new int[this.vertexAttribs.length];
            int i = 0;
            while (i < this.vertexAttribs.length) {
                vaSizes[i] = this.vertexAttribsSize[i];
                ++i;
            }
        }
        this.makeInterleaved(features, colorAlpha, tuSizes, vaSizes);
    }

    @Override
    protected void copyFrom(SimpleGeometryDataContainer original, boolean forceDuplicate) {
        GeometryDataContainer o = (GeometryDataContainer)original;
        super.copyFrom(o, forceDuplicate);
        this.texCoordSetMap = o.texCoordSetMap != null ? (int[])o.texCoordSetMap.clone() : null;
        this.texCoordSetMap_public = o.texCoordSetMap_public != null ? (int[])o.texCoordSetMap_public.clone() : null;
        System.arraycopy(o.textureUnitSize, 0, this.textureUnitSize, 0, o.textureUnitSize.length);
        this.colorSize = o.colorSize;
        this.vertexFormat = o.vertexFormat;
        this.hasNormals = o.hasNormals;
        this.hasColors = o.hasColors;
        this.colorSize = o.colorSize;
        this.normalsOffset = o.normalsOffset;
        this.colorsOffset = o.colorsOffset;
        System.arraycopy(o.texCoordsOffsets, 0, this.texCoordsOffsets, 0, o.texCoordsOffsets.length);
        System.arraycopy(o.vertexAttribsOffsets, 0, this.vertexAttribsOffsets, 0, o.vertexAttribsOffsets.length);
        if (!o.isInterleaved()) {
            int i;
            if (o.hasNormals()) {
                this.normals = o.normals.duplicateGeomData(true);
            }
            if (o.hasColors()) {
                this.colors = o.colors.duplicateGeomData(true);
            }
            if (o.hasTextureCoordinates()) {
                this.texCoords = new GeomNioFloatData[o.texCoords.length];
                i = 0;
                while (i < this.texCoords.length) {
                    if (o.texCoords[i] != null) {
                        this.texCoords[i] = o.texCoords[i].duplicateGeomData(true);
                    }
                    ++i;
                }
            }
            if (o.vertexAttribs != null) {
                this.vertexAttribs = new GeomNioFloatData[o.vertexAttribs.length];
                i = 0;
                while (i < this.vertexAttribs.length) {
                    if (o.vertexAttribs[i] != null) {
                        this.vertexAttribs[i] = o.vertexAttribs[i].duplicateGeomData(true);
                    }
                    ++i;
                }
            }
        }
    }

    protected GeometryDataContainer(GeometryArrayType type, boolean hasIndex, int coordsSize, int vertexCount, int[] stripCounts, int indexCount) {
        super(type, hasIndex, coordsSize, vertexCount, stripCounts, indexCount);
    }

    public GeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount) {
        this(type, false, coordsSize, vertexCount, null, 0);
    }

    public GeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int indexCount) {
        this(type, true, coordsSize, vertexCount, null, indexCount);
    }

    public GeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int[] stripCounts) {
        this(type, false, coordsSize, vertexCount, stripCounts, 0);
    }

    public GeometryDataContainer(GeometryArrayType type, int coordsSize, int vertexCount, int[] stripCounts, int indexCount) {
        this(type, true, coordsSize, vertexCount, stripCounts, indexCount);
    }
}

