/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.image;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public class SharedBufferedImage
extends BufferedImage {
    private final int pixelSize;
    private final int[] pixelOffsets;
    private final byte[] data;

    public final int getPixelSize() {
        return this.pixelSize;
    }

    public final int[] getPixelOffsets() {
        return this.pixelOffsets;
    }

    public final byte[] getSharedData() {
        return this.data;
    }

    protected SharedBufferedImage(int width, int height, ColorModel cm, DataBufferByte dbb, byte[] data, int scanlineStride, int pixelStride, int[] pixelOffsets) {
        super(cm, Raster.createInterleavedRaster(dbb, width, height, scanlineStride, pixelStride, pixelOffsets, new Point(0, 0)), false, null);
        this.pixelSize = scanlineStride / width;
        this.pixelOffsets = pixelOffsets;
        this.data = data;
    }

    public static SharedBufferedImage create(int width, int height, int pixelSize, boolean hasAlpha, int[] pixelOffsets, byte[] data) {
        ComponentColorModel cm;
        int pixelStride;
        int scanlineStride;
        switch (pixelSize) {
            case 4: {
                scanlineStride = width * 4;
                pixelStride = 4;
                if (pixelOffsets == null) {
                    int[] nArray = new int[4];
                    nArray[0] = 3;
                    nArray[1] = 2;
                    nArray[2] = 1;
                    pixelOffsets = nArray;
                }
                int[] nBits = new int[]{8, 8, 8, 8};
                ColorSpace cs = ColorSpace.getInstance(1000);
                cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
                break;
            }
            case 3: {
                scanlineStride = width * 3;
                pixelStride = 3;
                if (pixelOffsets == null) {
                    int[] nArray = new int[3];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    pixelOffsets = nArray;
                }
                int[] nBits = new int[]{8, 8, 8};
                ColorSpace cs = ColorSpace.getInstance(1000);
                cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
                break;
            }
            case 2: {
                scanlineStride = width * 2;
                pixelStride = 2;
                if (pixelOffsets == null) {
                    int[] nArray = new int[2];
                    nArray[0] = 1;
                    pixelOffsets = nArray;
                }
                int[] nBits = new int[]{8, 8};
                ColorSpace cs = ColorSpace.getInstance(1000);
                cm = new ComponentColorModel(cs, nBits, false, false, 3, 0);
                break;
            }
            case 1: {
                scanlineStride = width * 1;
                pixelStride = 1;
                if (pixelOffsets == null) {
                    pixelOffsets = new int[1];
                }
                int[] nBits = new int[]{8};
                ColorSpace cs = ColorSpace.getInstance(1003);
                if (hasAlpha) {
                    cm = new ComponentColorModel(cs, nBits, false, false, 3, 0);
                    break;
                }
                cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pixelSize: " + pixelSize);
            }
        }
        if (data == null) {
            data = new byte[width * height * pixelSize];
        }
        DataBufferByte dbb = new DataBufferByte(data, data.length);
        return new SharedBufferedImage(width, height, cm, dbb, data, scanlineStride, pixelStride, pixelOffsets);
    }

    public static final SharedBufferedImage create(int width, int height, int pixelSize, int[] pixelOffsets, byte[] data) {
        Boolean hasAlpha = null;
        switch (pixelSize) {
            case 4: {
                hasAlpha = Boolean.TRUE;
                break;
            }
            case 3: {
                hasAlpha = Boolean.FALSE;
                break;
            }
            case 2: {
                hasAlpha = Boolean.TRUE;
                break;
            }
            case 1: {
                hasAlpha = Boolean.FALSE;
            }
        }
        if (hasAlpha == null) {
            throw new IllegalArgumentException("Unsupported pixelSize: " + pixelSize);
        }
        return SharedBufferedImage.create(width, height, pixelSize, hasAlpha, pixelOffsets, data);
    }
}

