/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input;

import java.util.ArrayList;
import java.util.HashSet;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.ControllerEventPool;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.KeyboardEventPool;
import org.jagatoo.input.events.MouseEventPool;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.input.listeners.InputListener;
import org.jagatoo.input.listeners.InputStateListener;
import org.jagatoo.input.managers.InputStatesManager;
import org.jagatoo.input.managers._IS_Mgrs_PrivilegedAccess;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.util.arrays.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputSystem {
    public static final LogChannel LOG_CHANNEL = new LogChannel("JAGaToo.InputSystem");
    private static InputSystem instance = null;
    private Keyboard[] keyboards = new Keyboard[0];
    private Mouse[] mouses = new Mouse[0];
    private Controller[] controllers = new Controller[0];
    private Keyboard[] keyboards_out = null;
    private Mouse[] mouses_out = null;
    private Controller[] controllers_out = null;
    private final EventQueue eventQueue;
    private final ArrayList<InputListener> inputListeners = new ArrayList();
    private final ArrayList<InputStateListener> inputStateListeners = new ArrayList();
    private InputStatesManager[] statesManagers = null;
    private final ArrayList<InputHandler<?>> inputHandlers = new ArrayList();
    private long clickThreshold = 150000000L;

    public static final void setInstance(InputSystem inputSystem) {
        instance = inputSystem;
    }

    public static final boolean hasInstance() {
        return instance != null;
    }

    public static final InputSystem getInstance() {
        if (instance == null) {
            instance = new InputSystem();
        }
        return instance;
    }

    public final EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public void registerInputStatesManager(InputStatesManager mgr) {
        if (mgr == null) {
            throw new NullPointerException("mgr must not be null.");
        }
        if (this.statesManagers == null || this.statesManagers.length == 0) {
            this.statesManagers = new InputStatesManager[]{mgr};
        } else if (!ArrayUtils.contains(this.statesManagers, mgr, true)) {
            InputStatesManager[] newArray = new InputStatesManager[this.statesManagers.length + 1];
            System.arraycopy(this.statesManagers, 0, newArray, 0, this.statesManagers.length);
            newArray[newArray.length - 1] = mgr;
            this.statesManagers = newArray;
        }
    }

    public void deregisterInputStatesManager(InputStatesManager mgr) {
        if (mgr == null) {
            throw new NullPointerException("mgr must not be null.");
        }
        if (this.statesManagers == null || this.statesManagers.length == 0) {
            return;
        }
        int index = ArrayUtils.indexOf(this.statesManagers, mgr, true);
        if (index >= 0) {
            InputStatesManager[] newArray = new InputStatesManager[this.statesManagers.length - 1];
            System.arraycopy(this.statesManagers, 0, newArray, 0, index);
            System.arraycopy(this.statesManagers, index + 1, newArray, index, this.statesManagers.length - index - 1);
            this.statesManagers = newArray;
        }
    }

    public final void notifyInputStatesManagers(InputDevice device, DeviceComponent comp, int state, int delta, long nanoTime) {
        if (this.statesManagers == null || this.statesManagers.length == 0) {
            return;
        }
        if (comp != null) {
            int i = 0;
            while (i < this.statesManagers.length) {
                _IS_Mgrs_PrivilegedAccess.internalUpdateState(this.statesManagers[i], device, comp, state, delta, nanoTime);
                ++i;
            }
        }
    }

    public void addInputHandler(InputHandler<?> inputHandler) {
        if (inputHandler == null) {
            throw new NullPointerException("inputHandler must not be null.");
        }
        if (!this.inputHandlers.contains(inputHandler)) {
            inputHandler.setInputSystem(this);
            this.inputHandlers.add(inputHandler);
        }
    }

    public void removeInputHandler(InputHandler<?> inputHandler) {
        if (inputHandler == null) {
            throw new NullPointerException("inputHandler must not be null.");
        }
        if (this.inputHandlers.remove(inputHandler)) {
            inputHandler.setInputSystem(null);
        }
    }

    public void addInputListener(InputListener l) {
        boolean contains = false;
        int i = 0;
        while (i < this.inputListeners.size()) {
            if (this.inputListeners.get(i) == l) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            i = 0;
            while (i < this.keyboards.length) {
                this.keyboards[i].addKeyboardListener(l);
                ++i;
            }
            i = 0;
            while (i < this.mouses.length) {
                this.mouses[i].addMouseListener(l);
                ++i;
            }
            i = 0;
            while (i < this.controllers.length) {
                this.controllers[i].addControllerListener(l);
                ++i;
            }
            this.inputListeners.add(l);
        }
    }

    public void removeInputListener(InputListener l) {
        if (this.inputListeners.remove(l)) {
            int i = 0;
            while (i < this.keyboards.length) {
                this.keyboards[i].removeKeyboardListener(l);
                ++i;
            }
            i = 0;
            while (i < this.mouses.length) {
                this.mouses[i].removeMouseListener(l);
                ++i;
            }
            i = 0;
            while (i < this.controllers.length) {
                this.controllers[i].removeControllerListener(l);
                ++i;
            }
        }
    }

    public void addInputStateListener(InputStateListener l) {
        boolean contains = false;
        int i = 0;
        while (i < this.inputStateListeners.size()) {
            if (this.inputStateListeners.get(i) == l) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            i = 0;
            while (i < this.keyboards.length) {
                this.keyboards[i].addInputStateListener(l);
                ++i;
            }
            i = 0;
            while (i < this.mouses.length) {
                this.mouses[i].addInputStateListener(l);
                ++i;
            }
            i = 0;
            while (i < this.controllers.length) {
                this.controllers[i].addInputStateListener(l);
                ++i;
            }
            this.inputStateListeners.add(l);
        }
    }

    public void removeInputStateListener(InputStateListener l) {
        if (this.inputStateListeners.remove(l)) {
            int i = 0;
            while (i < this.keyboards.length) {
                this.keyboards[i].removeInputStateListener(l);
                ++i;
            }
            i = 0;
            while (i < this.mouses.length) {
                this.mouses[i].removeInputStateListener(l);
                ++i;
            }
            i = 0;
            while (i < this.controllers.length) {
                this.controllers[i].removeInputStateListener(l);
                ++i;
            }
        }
    }

    public void registerKeyboard(Keyboard keyboard) throws InputSystemException {
        int i = 0;
        while (i < this.keyboards.length) {
            if (this.keyboards[i] == keyboard) {
                throw new InputSystemException("This Keyboard is already registered at this InputSystem.");
            }
            ++i;
        }
        Keyboard[] keyboards2 = new Keyboard[this.keyboards.length + 1];
        System.arraycopy(this.keyboards, 0, keyboards2, 0, this.keyboards.length);
        keyboards2[this.keyboards.length] = keyboard;
        this.keyboards = keyboards2;
        keyboard.onDeviceRegistered(this);
        int i2 = 0;
        while (i2 < this.inputListeners.size()) {
            keyboard.addKeyboardListener(this.inputListeners.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.inputStateListeners.size()) {
            keyboard.addInputStateListener(this.inputStateListeners.get(i2));
            ++i2;
        }
    }

    public final Keyboard registerNewKeyboard(KeyboardFactory factory) throws InputSystemException {
        Keyboard[] allKeyboards = factory.getKeyboards(false);
        Keyboard[] newKeyboards = new Keyboard[allKeyboards.length];
        int numNewKeyboards = 0;
        int i = 0;
        while (i < allKeyboards.length) {
            boolean b = false;
            int j = 0;
            while (j < this.keyboards.length) {
                if (this.keyboards[j].equals(allKeyboards[i])) {
                    b = true;
                    break;
                }
                ++j;
            }
            if (!b) {
                newKeyboards[numNewKeyboards++] = allKeyboards[i];
            }
            ++i;
        }
        if (numNewKeyboards == 0) {
            throw new InputSystemException("There's no available Keyboard to register.");
        }
        this.registerKeyboard(newKeyboards[0]);
        return newKeyboards[0];
    }

    public final Keyboard registerNewKeyboard(InputSourceWindow sourceWindow) throws InputSystemException {
        return this.registerNewKeyboard(sourceWindow.getInputDeviceFactory(this));
    }

    public void deregisterKeyboard(Keyboard keyboard) throws InputSystemException {
        if (this.keyboards.length == 0) {
            throw new InputSystemException("This Keyboard is not registered at this InputSystem.");
        }
        boolean found = false;
        Keyboard[] keyboards2 = new Keyboard[this.keyboards.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.keyboards.length) {
            if (this.keyboards[i] == keyboard) {
                found = true;
            } else {
                keyboards2[j++] = this.keyboards[i];
            }
            ++i;
        }
        if (!found) {
            throw new InputSystemException("This Keyboard is not registered at this InputSystem.");
        }
        i = 0;
        while (i < this.inputListeners.size()) {
            keyboard.removeKeyboardListener(this.inputListeners.get(i));
            ++i;
        }
        i = 0;
        while (i < this.inputStateListeners.size()) {
            keyboard.removeInputStateListener(this.inputStateListeners.get(i));
            ++i;
        }
        keyboard.destroy();
        this.keyboards = keyboards2;
        KeyboardEventPool.cleanup(keyboard.getSourceWindow());
        this.eventQueue.cleanup(keyboard.getSourceWindow());
        keyboard.onDeviceUnregistered(this);
    }

    public final boolean hasKeyboard() {
        return this.keyboards.length > 0;
    }

    public final int getKeyboardsCount() {
        return this.keyboards.length;
    }

    public final Keyboard getKeyboard() {
        if (this.keyboards.length >= 1) {
            return this.keyboards[0];
        }
        return null;
    }

    public final Keyboard getKeyboard(int index) {
        return this.keyboards[index];
    }

    public final Keyboard[] getKeyboards() {
        if (this.keyboards_out == null || this.keyboards_out.length != this.keyboards.length) {
            this.keyboards_out = new Keyboard[this.keyboards.length];
            System.arraycopy(this.keyboards, 0, this.keyboards_out, 0, this.keyboards.length);
        }
        return this.keyboards_out;
    }

    public final boolean isKeyboardRegistered(Keyboard keyboard) {
        int i = 0;
        while (i < this.keyboards.length) {
            if (this.keyboards[i] == keyboard) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setMouseButtonClickThreshold(long threshold) {
        this.clickThreshold = threshold;
    }

    public final long getMouseButtonClickThreshold() {
        return this.clickThreshold;
    }

    public void registerMouse(Mouse mouse) throws InputSystemException {
        int i = 0;
        while (i < this.mouses.length) {
            if (this.mouses[i] == mouse) {
                throw new InputSystemException("This Mouse is already registered at this InputSystem.");
            }
            ++i;
        }
        Mouse[] mouses2 = new Mouse[this.mouses.length + 1];
        System.arraycopy(this.mouses, 0, mouses2, 0, this.mouses.length);
        mouses2[this.mouses.length] = mouse;
        this.mouses = mouses2;
        mouse.onDeviceRegistered(this);
        int i2 = 0;
        while (i2 < this.inputListeners.size()) {
            mouse.addMouseListener(this.inputListeners.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.inputStateListeners.size()) {
            mouse.addInputStateListener(this.inputStateListeners.get(i2));
            ++i2;
        }
    }

    public final Mouse registerNewMouse(MouseFactory factory) throws InputSystemException {
        Mouse[] allMouses = factory.getMouses(false);
        Mouse[] newMouses = new Mouse[allMouses.length];
        int numNewMouses = 0;
        int i = 0;
        while (i < allMouses.length) {
            boolean b = false;
            int j = 0;
            while (j < this.mouses.length) {
                if (this.mouses[j].equals(allMouses[i])) {
                    b = true;
                    break;
                }
                ++j;
            }
            if (!b) {
                newMouses[numNewMouses++] = allMouses[i];
            }
            ++i;
        }
        if (numNewMouses == 0) {
            throw new InputSystemException("There's no available Mouse to register.");
        }
        this.registerMouse(newMouses[0]);
        return newMouses[0];
    }

    public final Mouse registerNewMouse(InputSourceWindow sourceWindow) throws InputSystemException {
        return this.registerNewMouse(sourceWindow.getInputDeviceFactory(this));
    }

    public void deregisterMouse(Mouse mouse) throws InputSystemException {
        if (this.mouses.length == 0) {
            throw new InputSystemException("This Mouse is not registered at this InputSystem.");
        }
        boolean found = false;
        Mouse[] mouses2 = new Mouse[this.mouses.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.mouses.length) {
            if (this.mouses[i] == mouse) {
                found = true;
            } else {
                mouses2[j++] = this.mouses[i];
            }
            ++i;
        }
        if (!found) {
            throw new InputSystemException("This Mouse is not registered at this InputSystem.");
        }
        i = 0;
        while (i < this.inputListeners.size()) {
            mouse.removeMouseListener(this.inputListeners.get(i));
            ++i;
        }
        i = 0;
        while (i < this.inputStateListeners.size()) {
            mouse.removeInputStateListener(this.inputStateListeners.get(i));
            ++i;
        }
        mouse.destroy();
        this.mouses = mouses2;
        MouseEventPool.cleanup(mouse.getSourceWindow());
        this.eventQueue.cleanup(mouse.getSourceWindow());
        mouse.onDeviceUnregistered(this);
    }

    public final boolean hasMouse() {
        return this.mouses.length > 0;
    }

    public final int getMousesCount() {
        return this.mouses.length;
    }

    public final Mouse getMouse() {
        if (this.mouses.length >= 1) {
            return this.mouses[0];
        }
        return null;
    }

    public final Mouse getMouse(int index) {
        return this.mouses[index];
    }

    public final Mouse[] getMouses() {
        if (this.mouses_out == null || this.mouses_out.length != this.mouses.length) {
            this.mouses_out = new Mouse[this.mouses.length];
            System.arraycopy(this.mouses, 0, this.mouses_out, 0, this.mouses.length);
        }
        return this.mouses_out;
    }

    public final boolean isMouseRegistered(Mouse mouse) {
        int i = 0;
        while (i < this.mouses.length) {
            if (this.mouses[i] == mouse) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void registerNewKeyboardAndMouse(InputDeviceFactory factory) throws InputSystemException {
        this.registerNewKeyboard(factory);
        this.registerNewMouse(factory);
    }

    public final void registerNewKeyboardAndMouse(InputSourceWindow sourceWindow) throws InputSystemException {
        this.registerNewKeyboardAndMouse(sourceWindow.getInputDeviceFactory(this));
    }

    public void registerController(Controller controller) throws InputSystemException {
        int i = 0;
        while (i < this.controllers.length) {
            if (this.controllers[i] == controller) {
                throw new InputSystemException("This Controller is already registered at this InputSystem.");
            }
            ++i;
        }
        Controller[] controllers2 = new Controller[this.controllers.length + 1];
        System.arraycopy(this.controllers, 0, controllers2, 0, this.controllers.length);
        controllers2[this.controllers.length] = controller;
        this.controllers = controllers2;
        controller.onDeviceRegistered(this);
        int i2 = 0;
        while (i2 < this.inputListeners.size()) {
            controller.addControllerListener(this.inputListeners.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.inputStateListeners.size()) {
            controller.addInputStateListener(this.inputStateListeners.get(i2));
            ++i2;
        }
    }

    public final Controller registerNewController(ControllerFactory factory) throws InputSystemException {
        Controller[] allControllers = factory.getControllers(false);
        Controller[] newControllers = new Controller[allControllers.length];
        int numNewControllers = 0;
        int i = 0;
        while (i < allControllers.length) {
            boolean b = false;
            int j = 0;
            while (j < this.controllers.length) {
                if (this.controllers[j].equals(allControllers[i])) {
                    b = true;
                    break;
                }
                ++j;
            }
            if (!b) {
                newControllers[numNewControllers++] = allControllers[i];
            }
            ++i;
        }
        if (numNewControllers == 0) {
            throw new InputSystemException("There's no available Controller to register.");
        }
        this.registerController(newControllers[0]);
        return newControllers[0];
    }

    public final Controller registerNewController(InputSourceWindow sourceWindow) throws InputSystemException {
        return this.registerNewController(sourceWindow.getInputDeviceFactory(this));
    }

    public void deregisterController(Controller controller) throws InputSystemException {
        if (this.controllers.length == 0) {
            throw new InputSystemException("This Controller is not registered at this InputSystem.");
        }
        boolean found = false;
        Controller[] controllers2 = new Controller[this.controllers.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.controllers.length) {
            if (this.controllers[i] == controller) {
                found = true;
            } else {
                controllers2[j++] = this.controllers[i];
            }
            ++i;
        }
        if (!found) {
            throw new InputSystemException("This Controller is not registered at this InputSystem.");
        }
        i = 0;
        while (i < this.inputListeners.size()) {
            controller.removeControllerListener(this.inputListeners.get(i));
            ++i;
        }
        i = 0;
        while (i < this.inputStateListeners.size()) {
            controller.removeInputStateListener(this.inputStateListeners.get(i));
            ++i;
        }
        controller.destroy();
        this.controllers = controllers2;
        ControllerEventPool.cleanup(controller.getSourceWindow());
        this.eventQueue.cleanup(controller.getSourceWindow());
        controller.onDeviceUnregistered(this);
    }

    public final boolean hasController() {
        return this.controllers.length > 0;
    }

    public final int getControllersCount() {
        return this.controllers.length;
    }

    public final Controller getController() {
        if (this.controllers.length >= 1) {
            return this.controllers[0];
        }
        return null;
    }

    public final Controller getController(int index) {
        return this.controllers[index];
    }

    public final Controller[] getControllers() {
        if (this.controllers_out == null || this.controllers_out.length != this.controllers.length) {
            this.controllers_out = new Controller[this.controllers.length];
            System.arraycopy(this.controllers, 0, this.controllers_out, 0, this.controllers.length);
        }
        return this.controllers_out;
    }

    public final boolean isControllerRegistered(Controller controller) {
        int i = 0;
        while (i < this.controllers.length) {
            if (this.controllers[i] == controller) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void collectKeyboardEvents(long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.keyboards.length) {
            boolean acceptEvents;
            Keyboard keyboard = this.keyboards[i];
            boolean bl = acceptEvents = keyboard.isEnabled() && keyboard.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                keyboard.collectEvents(this, this.eventQueue, nanoTime);
            }
            ++i;
        }
    }

    protected void collectMouseEvents(long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.mouses.length) {
            boolean acceptEvents;
            Mouse mouse = this.mouses[i];
            boolean bl = acceptEvents = mouse.isEnabled() && mouse.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                mouse.collectEvents(this, this.eventQueue, nanoTime);
            }
            ++i;
        }
    }

    protected void collectControllerEvents(EventQueue eventQueue, long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.controllers.length) {
            boolean acceptEvents;
            Controller controller = this.controllers[i];
            boolean bl = acceptEvents = controller.isEnabled() && controller.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                controller.collectEvents(this, eventQueue, nanoTime);
            }
            ++i;
        }
    }

    public void collectEvents(long nanoTime) throws InputSystemException {
        this.collectKeyboardEvents(nanoTime);
        this.collectMouseEvents(nanoTime);
        this.collectControllerEvents(this.eventQueue, nanoTime);
    }

    protected void updateKeyboards(long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.keyboards.length) {
            boolean acceptEvents;
            Keyboard keyboard = this.keyboards[i];
            boolean bl = acceptEvents = keyboard.isEnabled() && keyboard.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                keyboard.update(this, this.eventQueue, nanoTime);
            } else {
                keyboard.consumePendingEvents(this, this.eventQueue, nanoTime);
            }
            ++i;
        }
    }

    protected void updateMouses(long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.mouses.length) {
            boolean acceptEvents;
            Mouse mouse = this.mouses[i];
            boolean bl = acceptEvents = mouse.isEnabled() && mouse.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                mouse.update(this, this.eventQueue, nanoTime);
            } else {
                mouse.consumePendingEvents(this, this.eventQueue, nanoTime);
            }
            ++i;
        }
    }

    protected void updateControllers(EventQueue eventQueue, long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.controllers.length) {
            boolean acceptEvents;
            Controller controller = this.controllers[i];
            boolean bl = acceptEvents = controller.isEnabled() && controller.getSourceWindow().receivesInputEvents();
            if (acceptEvents) {
                controller.update(this, eventQueue, nanoTime);
            } else {
                controller.consumePendingEvents(this, eventQueue, nanoTime);
            }
            ++i;
        }
    }

    protected void updateInputHandlers(long nanoTime) throws InputSystemException {
        int i = 0;
        while (i < this.inputHandlers.size()) {
            this.inputHandlers.get(i).update(nanoTime);
            ++i;
        }
    }

    public void update(long nanoTime) throws InputSystemException {
        this.updateKeyboards(nanoTime);
        this.updateMouses(nanoTime);
        this.updateControllers(this.eventQueue, nanoTime);
        this.updateInputHandlers(nanoTime);
    }

    /*
     * WARNING - void declaration
     */
    public void destroy() throws InputSystemException {
        void var2_7;
        void var2_5;
        void var2_3;
        HashSet<Object> factories = new HashSet<Object>();
        int n = this.keyboards.length - 1;
        while (var2_3 >= 0) {
            factories.add(this.keyboards[var2_3].getSourceFactory());
            this.deregisterKeyboard(this.keyboards[var2_3]);
            --var2_3;
        }
        int n2 = this.mouses.length - 1;
        while (var2_5 >= 0) {
            factories.add(this.mouses[var2_5].getSourceFactory());
            this.deregisterMouse(this.mouses[var2_5]);
            --var2_5;
        }
        int n3 = this.controllers.length - 1;
        while (var2_7 >= 0) {
            factories.add(this.controllers[var2_7].getSourceFactory());
            this.deregisterController(this.controllers[var2_7]);
            --var2_7;
        }
        for (Object e : factories) {
            if (e instanceof KeyboardFactory) {
                ((KeyboardFactory)e).destroy(this);
                continue;
            }
            if (e instanceof MouseFactory) {
                ((MouseFactory)e).destroy(this);
                continue;
            }
            if (!(e instanceof ControllerFactory)) continue;
            ((ControllerFactory)e).destroy(this);
        }
    }

    public void destroy(KeyboardFactory deviceFactory) throws InputSystemException {
        InputSourceWindow sourceWindow = null;
        int i = this.keyboards.length - 1;
        while (i >= 0) {
            if (this.keyboards[i].getSourceFactory() == deviceFactory) {
                sourceWindow = this.keyboards[i].getSourceWindow();
                this.deregisterKeyboard(this.keyboards[i]);
            }
            --i;
        }
        deviceFactory.destroy(this);
        if (sourceWindow != null) {
            KeyboardEventPool.cleanup(sourceWindow);
            this.eventQueue.cleanup(sourceWindow);
        }
    }

    public void destroy(MouseFactory deviceFactory) throws InputSystemException {
        InputSourceWindow sourceWindow = null;
        int i = this.mouses.length - 1;
        while (i >= 0) {
            if (this.mouses[i].getSourceFactory() == deviceFactory) {
                sourceWindow = this.mouses[i].getSourceWindow();
                this.deregisterMouse(this.mouses[i]);
            }
            --i;
        }
        deviceFactory.destroy(this);
        if (sourceWindow != null) {
            MouseEventPool.cleanup(sourceWindow);
            this.eventQueue.cleanup(sourceWindow);
        }
    }

    public void destroy(ControllerFactory deviceFactory) throws InputSystemException {
        InputSourceWindow sourceWindow = null;
        int i = this.controllers.length - 1;
        while (i >= 0) {
            if (this.controllers[i].getSourceFactory() == deviceFactory) {
                sourceWindow = this.controllers[i].getSourceWindow();
                this.deregisterController(this.controllers[i]);
            }
            --i;
        }
        deviceFactory.destroy(this);
        if (sourceWindow != null) {
            MouseEventPool.cleanup(sourceWindow);
            this.eventQueue.cleanup(sourceWindow);
        }
    }

    public void destroy(InputDeviceFactory deviceFactory) throws InputSystemException {
        this.destroy((KeyboardFactory)deviceFactory);
        this.destroy((MouseFactory)deviceFactory);
        this.destroy((ControllerFactory)deviceFactory);
    }

    public final void destroy(InputSourceWindow sourceWindow) throws InputSystemException {
        this.destroy(sourceWindow.getInputDeviceFactory(this));
    }

    public InputSystem() {
        this.eventQueue = new EventQueue();
    }
}

