/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices;

import java.util.Arrays;
import java.util.Comparator;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.events.ControllerEventPool;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.KeyboardEventPool;
import org.jagatoo.input.events.MouseEventPool;
import org.jagatoo.input.render.InputSourceWindow;

public abstract class InputDeviceFactory
implements KeyboardFactory,
MouseFactory,
ControllerFactory {
    private final InputDeviceFactory masterFactory;
    private final EventQueue eventQueue;
    private final InputSourceWindow sourceWindow;
    private static Controller[] staticCachedControllers = null;
    private Keyboard[] cachedKeyboards = null;
    private Mouse[] cachedMouses = null;
    private Controller[] cachedControllers = null;
    private final boolean useStaticArrays;

    public final InputSourceWindow getSourceWindow() {
        return this.sourceWindow;
    }

    protected final InputDeviceFactory getMasterFactory() {
        return this.masterFactory;
    }

    protected final InputDeviceFactory findSourceFactory() {
        InputDeviceFactory sourceFactory = this;
        while (sourceFactory.getMasterFactory() != null) {
            sourceFactory = sourceFactory.getMasterFactory();
        }
        return sourceFactory;
    }

    protected EventQueue getEveneQueue() {
        return this.eventQueue;
    }

    private final synchronized void setCachedKeyboards(Keyboard[] keyboards) {
        this.cachedKeyboards = keyboards;
    }

    protected final synchronized Keyboard[] getCachedKeyboards() {
        return this.cachedKeyboards;
    }

    private final synchronized void setCachedMouses(Mouse[] mouses) {
        this.cachedMouses = mouses;
    }

    protected final synchronized Mouse[] getCachedMouses() {
        return this.cachedMouses;
    }

    private final synchronized void setCachedControllers(Controller[] controllers) {
        if (this.useStaticArrays) {
            staticCachedControllers = controllers;
        } else {
            this.cachedControllers = controllers;
        }
    }

    protected final synchronized Controller[] getCachedControllers() {
        if (this.useStaticArrays) {
            return staticCachedControllers;
        }
        return this.cachedControllers;
    }

    protected synchronized void flushCache(boolean keyboards, boolean mouses, boolean controllers) {
        if (keyboards) {
            this.cachedKeyboards = null;
        }
        if (mouses) {
            this.cachedMouses = null;
        }
        if (this.useStaticArrays) {
            if (controllers) {
                staticCachedControllers = null;
            }
        } else if (controllers) {
            this.cachedControllers = null;
        }
    }

    protected static final void flushCache(InputDeviceFactory factory, boolean keyboards, boolean mouses, boolean controllers) {
        factory.flushCache(keyboards, mouses, controllers);
    }

    protected abstract Keyboard[] initKeyboards() throws InputSystemException;

    protected static final Keyboard[] initKeyboards(InputDeviceFactory factory) throws InputSystemException {
        return factory.initKeyboards();
    }

    public Keyboard[] getKeyboards(boolean forceRefresh) throws InputSystemException {
        if (this.getCachedKeyboards() == null || forceRefresh) {
            this.setCachedKeyboards(this.initKeyboards());
        }
        return this.getCachedKeyboards();
    }

    public final Keyboard[] getKeyboards() throws InputSystemException {
        return this.getKeyboards(false);
    }

    protected abstract Mouse[] initMouses() throws InputSystemException;

    protected static final Mouse[] initMouses(InputDeviceFactory factory) throws InputSystemException {
        return factory.initMouses();
    }

    public Mouse[] getMouses(boolean forceRefresh) throws InputSystemException {
        if (this.getCachedMouses() == null || forceRefresh) {
            this.setCachedMouses(this.initMouses());
        }
        return this.getCachedMouses();
    }

    public final Mouse[] getMouses() throws InputSystemException {
        return this.getMouses(false);
    }

    protected abstract Controller[] initControllers() throws InputSystemException;

    protected static final Controller[] initControllers(InputDeviceFactory factory) throws InputSystemException {
        return ControllerSorter.sort(factory.initControllers());
    }

    public Controller[] getControllers(boolean forceRefresh) throws InputSystemException {
        if (this.getCachedControllers() == null || forceRefresh) {
            this.setCachedControllers(this.initControllers());
        }
        return this.getCachedControllers();
    }

    public final Controller[] getControllers() throws InputSystemException {
        return this.getControllers(false);
    }

    protected abstract void destroyImpl(InputSystem var1) throws InputSystemException;

    public final void destroy(InputSystem inputSystem) throws InputSystemException {
        this.destroyImpl(inputSystem);
        KeyboardEventPool.cleanup(this.sourceWindow);
        MouseEventPool.cleanup(this.sourceWindow);
        ControllerEventPool.cleanup(this.sourceWindow);
        this.eventQueue.cleanup(this.sourceWindow);
    }

    public InputDeviceFactory(InputDeviceFactory masterFactory, boolean useStaticArrays, InputSourceWindow sourceWindow, EventQueue eventQueue) {
        this.masterFactory = masterFactory;
        this.useStaticArrays = useStaticArrays;
        this.sourceWindow = sourceWindow;
        this.eventQueue = eventQueue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ControllerSorter
    implements Comparator<Controller> {
        private static final ControllerSorter instance = new ControllerSorter();

        private ControllerSorter() {
        }

        @Override
        public int compare(Controller c1, Controller c2) {
            if (c1.getAxesCount() < c2.getAxesCount()) {
                return 1;
            }
            if (c1.getAxesCount() > c2.getAxesCount()) {
                return -1;
            }
            if (c1.getButtonsCount() < c2.getButtonsCount()) {
                return 1;
            }
            if (c1.getButtonsCount() > c2.getButtonsCount()) {
                return -1;
            }
            return 0;
        }

        public static Controller[] sort(Controller[] controllers) {
            Arrays.sort(controllers, instance);
            return controllers;
        }
    }
}

