/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices.components;

import org.jagatoo.input.devices.components.DeviceComponent;

public class AnalogDeviceComponent
extends DeviceComponent {
    private int intValue = 0;
    private float floatValue = 0.0f;
    private float scale = 1000.0f;

    protected void setValue(int intValue, float floatValue) {
        this.intValue = intValue;
        this.floatValue = floatValue;
    }

    public final void setValue(int value) {
        this.setValue(value, (float)this.intValue / this.scale);
    }

    public final void setValue(float value) {
        this.setValue((int)(this.floatValue * this.scale), value);
    }

    public final void addValue(int deltaValue) {
        this.setValue(this.intValue + deltaValue);
    }

    public final void addValue(float deltaValue) {
        this.setValue(this.floatValue + deltaValue);
    }

    public final int getIntValue() {
        return this.intValue;
    }

    public final float getFloatValue() {
        return this.floatValue;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public final float getScale() {
        return this.scale;
    }

    protected AnalogDeviceComponent(DeviceComponent.Type type, String name) {
        super(type, name);
    }
}

