/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.InputEvent;

public abstract class ControllerEvent
extends InputEvent {
    private SubType subType;
    private Controller controller;

    public final SubType getSubType() {
        return this.subType;
    }

    public final Controller getController() {
        return this.controller;
    }

    public abstract String toString();

    protected void set(Controller controller, SubType subType, DeviceComponent component, long when, long lastWhen) {
        super.set(component, when, lastWhen);
        this.controller = controller;
        this.subType = subType;
    }

    protected void set(ControllerEvent e) {
        if (e.getType() != this.getType()) {
            throw new IllegalArgumentException("mismatching types");
        }
        super.set(e.getComponent(), e.getWhen(), e.getLastWhen());
        this.controller = e.controller;
        this.subType = e.subType;
    }

    protected ControllerEvent(Controller controller, SubType subType, DeviceComponent component, long when, long lastWhen) {
        super(InputEvent.Type.CONTROLLER_EVENT, component, when, lastWhen);
        this.controller = controller;
        this.subType = subType;
    }

    protected ControllerEvent(SubType subType) {
        super(InputEvent.Type.CONTROLLER_EVENT, null, -1L, -1L);
        this.subType = subType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubType {
        BUTTON_PRESSED,
        BUTTON_RELEASED,
        AXIS_CHANGED;

    }
}

