/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.InputEvent;

public abstract class MouseEvent
extends InputEvent {
    private Mouse mouse;
    private SubType subType;

    public final Mouse getMouse() {
        return this.mouse;
    }

    public final SubType getSubType() {
        return this.subType;
    }

    public abstract String toString();

    protected void set(Mouse mouse, SubType subType, DeviceComponent component, long when, long lastWhen) {
        super.set(component, when, lastWhen);
        this.mouse = mouse;
        this.subType = subType;
    }

    protected void set(MouseEvent e) {
        super.set(e);
        this.mouse = e.mouse;
        this.subType = e.subType;
    }

    public MouseEvent(Mouse mouse, SubType subType, DeviceComponent component, long when, long lastWhen) {
        super(InputEvent.Type.MOUSE_EVENT, component, when, lastWhen);
        this.subType = subType;
        this.mouse = mouse;
    }

    protected MouseEvent(SubType subType) {
        super(InputEvent.Type.MOUSE_EVENT, null, -1L, -1L);
        this.subType = subType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubType {
        BUTTON_PRESSED,
        BUTTON_RELEASED,
        BUTTON_CLICKED,
        WHEEL_MOVED,
        MOVED,
        STOPPED;

    }
}

