/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.awt;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.BitSet;
import javax.swing.SwingUtilities;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.KeyID;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.localization.KeyboardLocalizer;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.Log;

public class AWTKeyboard
extends Keyboard {
    private static final boolean IS_WINDOWS = System.getenv("windir") != null;
    private int firstUnusedEntry = 0;
    private boolean deferredEventsProcessed = true;
    private final BitSet lastPressedKeys = new BitSet();
    private final BitSet pressedKeys = new BitSet();
    private final BitSet changedKeyStates = new BitSet();
    private final KeyEvent[] eventQueue = new KeyEvent[128];
    private final Runnable deferredEventProcessor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BitSet bitSet = AWTKeyboard.this.changedKeyStates;
            synchronized (bitSet) {
                if (!$assertionsDisabled && AWTKeyboard.this.firstUnusedEntry <= 0) {
                    throw new AssertionError();
                }
                int i = 0;
                while (i < AWTKeyboard.this.firstUnusedEntry) {
                    KeyEvent keyEvent = AWTKeyboard.this.eventQueue[i];
                    ((AWTKeyboard)AWTKeyboard.this).eventQueue[i] = null;
                    if (keyEvent.getID() != 400) {
                        Key key = AWTKeyboard.convertKey(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), keyEvent.getKeyChar());
                        if (key == null) {
                            AWTKeyboard.dumpKeyConversionFailed(keyEvent);
                        } else {
                            AWTKeyboard.this.pressedKeys.set(key.getKeyCode() - 1, keyEvent.getID() == 401);
                        }
                    } else {
                        KeyTypedEvent e;
                        int modifierMask = AWTKeyboard.this.getModifierMask();
                        char keyChar = keyEvent.getKeyChar();
                        if (keyEvent.getKeyChar() == '\uffac') {
                            keyChar = KeyboardLocalizer.getMapping().getModifiedChar(Keys.NUMPAD_DECIMAL, '\u0000', 0);
                        }
                        if ((e = AWTKeyboard.this.prepareKeyTypedEvent(keyChar, modifierMask, AWTKeyboard.this.lastUpdateTime, 0L)) != null) {
                            AWTKeyboard.this.getEventQueue().enqueue(e);
                        }
                    }
                    ++i;
                }
                int keyIndex = AWTKeyboard.this.pressedKeys.nextSetBit(0);
                while (keyIndex >= 0) {
                    if (!AWTKeyboard.this.lastPressedKeys.get(keyIndex)) {
                        AWTKeyboard.this.changedKeyStates.set(keyIndex);
                        AWTKeyboard.this.lastPressedKeys.set(keyIndex);
                    }
                    keyIndex = AWTKeyboard.this.pressedKeys.nextSetBit(keyIndex + 1);
                }
                keyIndex = AWTKeyboard.this.lastPressedKeys.nextSetBit(0);
                while (keyIndex >= 0) {
                    if (!AWTKeyboard.this.pressedKeys.get(keyIndex)) {
                        AWTKeyboard.this.changedKeyStates.set(keyIndex);
                        AWTKeyboard.this.lastPressedKeys.clear(keyIndex);
                    }
                    keyIndex = AWTKeyboard.this.lastPressedKeys.nextSetBit(keyIndex + 1);
                }
                AWTKeyboard.this.firstUnusedEntry = 0;
                AWTKeyboard.this.deferredEventsProcessed = true;
            }
        }
    };
    private long lastUpdateTime = 0L;

    private static final Key convertKey(int awtKey) {
        switch (awtKey) {
            case 27: {
                return Keys.ESCAPE;
            }
            case 112: {
                return Keys.F1;
            }
            case 113: {
                return Keys.F2;
            }
            case 114: {
                return Keys.F3;
            }
            case 115: {
                return Keys.F4;
            }
            case 116: {
                return Keys.F5;
            }
            case 117: {
                return Keys.F6;
            }
            case 118: {
                return Keys.F7;
            }
            case 119: {
                return Keys.F8;
            }
            case 120: {
                return Keys.F9;
            }
            case 121: {
                return Keys.F10;
            }
            case 122: {
                return Keys.F11;
            }
            case 123: {
                return Keys.F12;
            }
            case 19: {
                return Keys.PAUSE;
            }
            case 145: {
                return Keys.SCROLL_LOCK;
            }
            case 130: {
                if (IS_WINDOWS) {
                    return Keys.CIRCUMFLEX;
                }
                return null;
            }
            case 514: {
                return Keys.CIRCUMFLEX;
            }
            case 48: {
                return Keys._0;
            }
            case 49: {
                return Keys._1;
            }
            case 50: {
                return Keys._2;
            }
            case 51: {
                return Keys._3;
            }
            case 52: {
                return Keys._4;
            }
            case 53: {
                return Keys._5;
            }
            case 54: {
                return Keys._6;
            }
            case 55: {
                return Keys._7;
            }
            case 56: {
                return Keys._8;
            }
            case 57: {
                return Keys._9;
            }
            case 65: {
                return Keys.A;
            }
            case 66: {
                return Keys.B;
            }
            case 67: {
                return Keys.C;
            }
            case 68: {
                return Keys.D;
            }
            case 69: {
                return Keys.E;
            }
            case 70: {
                return Keys.F;
            }
            case 71: {
                return Keys.G;
            }
            case 72: {
                return Keys.H;
            }
            case 73: {
                return Keys.I;
            }
            case 74: {
                return Keys.J;
            }
            case 75: {
                return Keys.K;
            }
            case 76: {
                return Keys.L;
            }
            case 77: {
                return Keys.M;
            }
            case 78: {
                return Keys.N;
            }
            case 79: {
                return Keys.O;
            }
            case 80: {
                return Keys.P;
            }
            case 81: {
                return Keys.Q;
            }
            case 82: {
                return Keys.R;
            }
            case 83: {
                return Keys.S;
            }
            case 84: {
                return Keys.T;
            }
            case 85: {
                return Keys.U;
            }
            case 86: {
                return Keys.V;
            }
            case 87: {
                return Keys.W;
            }
            case 88: {
                return Keys.X;
            }
            case 89: {
                return Keys.Y;
            }
            case 90: {
                return Keys.Z;
            }
            case 9: {
                return Keys.TAB;
            }
            case 32: {
                return Keys.SPACE;
            }
            case 8: {
                return Keys.BACK_SPACE;
            }
            case 18: {
                return Keys.ALT;
            }
            case 65406: {
                return Keys.ALT_GRAPH;
            }
            case 20: {
                return Keys.CAPS_LOCK;
            }
            case 127: {
                return Keys.DELETE;
            }
            case 155: {
                return Keys.INSERT;
            }
            case 35: {
                return Keys.END;
            }
            case 36: {
                return Keys.HOME;
            }
            case 33: {
                return Keys.PAGE_UP;
            }
            case 34: {
                return Keys.PAGE_DOWN;
            }
            case 39: {
                return Keys.RIGHT;
            }
            case 37: {
                return Keys.LEFT;
            }
            case 38: {
                return Keys.UP;
            }
            case 40: {
                return Keys.DOWN;
            }
            case 144: {
                return Keys.NUM_LOCK;
            }
            case 111: {
                return Keys.NUMPAD_DIVIDE;
            }
            case 106: {
                return Keys.NUMPAD_MULTIPLY;
            }
            case 109: {
                return Keys.NUMPAD_SUBTRACT;
            }
            case 107: {
                return Keys.NUMPAD_ADD;
            }
            case 96: {
                return Keys.NUMPAD0;
            }
            case 97: {
                return Keys.NUMPAD1;
            }
            case 98: {
                return Keys.NUMPAD2;
            }
            case 99: {
                return Keys.NUMPAD3;
            }
            case 100: {
                return Keys.NUMPAD4;
            }
            case 101: {
                return Keys.NUMPAD5;
            }
            case 102: {
                return Keys.NUMPAD6;
            }
            case 103: {
                return Keys.NUMPAD7;
            }
            case 104: {
                return Keys.NUMPAD8;
            }
            case 105: {
                return Keys.NUMPAD9;
            }
        }
        return null;
    }

    public static final Key convertKey(int awtKey, int keyLocation, char keyChar) {
        Key key;
        switch (awtKey) {
            case 16: {
                if (keyLocation == 2) {
                    key = Keys.LEFT_SHIFT;
                    break;
                }
                key = Keys.RIGHT_SHIFT;
                break;
            }
            case 17: {
                if (keyLocation == 2) {
                    key = Keys.LEFT_CONTROL;
                    break;
                }
                key = Keys.RIGHT_CONTROL;
                break;
            }
            case 157: {
                if (keyLocation == 2) {
                    key = Keys.LEFT_META;
                    break;
                }
                key = Keys.RIGHT_META;
                break;
            }
            case 10: {
                if (keyLocation == 4) {
                    key = Keys.NUMPAD_ENTER;
                    break;
                }
                key = Keys.ENTER;
                break;
            }
            case 110: {
                key = Keys.NUMPAD_DECIMAL;
                break;
            }
            default: {
                key = AWTKeyboard.convertKey(awtKey);
            }
        }
        if (key == null) {
            key = KeyboardLocalizer.getMapping().getLocalizedKey(keyChar);
        }
        if (key == Keys.DELETE && keyChar != '\u0000') {
            key = Keys.NUMPAD_DECIMAL;
        }
        return key;
    }

    protected boolean hasKeyStateChanged(Key key, boolean keyState) {
        return true;
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        try {
            this.getEventQueue().dequeueAndFire(is, InputEvent.Type.KEYBOARD_EVENT);
            BitSet bitSet = this.changedKeyStates;
            synchronized (bitSet) {
                int n = this.changedKeyStates.length();
                int i = this.changedKeyStates.nextSetBit(0);
                while (i >= 0 && i < n) {
                    KeyStateEvent e;
                    int modifierMask;
                    Key key = KeyID.values()[i].getKey();
                    if (this.pressedKeys.get(i)) {
                        modifierMask = this.applyModifier(key, true);
                        e = this.prepareKeyPressedEvent(key, modifierMask, nanoTime, 0L);
                        is.notifyInputStatesManagers(this, key, 1, 1, nanoTime);
                        if (e != null) {
                            this.fireOnKeyPressed((KeyPressedEvent)e, true);
                        }
                    } else {
                        modifierMask = this.applyModifier(key, false);
                        e = this.prepareKeyReleasedEvent(key, modifierMask, nanoTime, 0L);
                        is.notifyInputStatesManagers(this, key, 0, -1, nanoTime);
                        if (e != null) {
                            this.fireOnKeyReleased((KeyReleasedEvent)e, true);
                        }
                    }
                    this.changedKeyStates.clear(i);
                    i = this.changedKeyStates.nextSetBit(i + 1);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
        this.lastUpdateTime = nanoTime;
    }

    private static final void dumpKeyConversionFailed(KeyEvent e) {
        String message = "Key-conversion failed for AWT key " + e.getKeyCode() + ". Please check localization (" + KeyboardLocalizer.getCurrentMappingName() + ")";
        Log.printlnEx(InputSystem.LOG_CHANNEL, message);
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled() || !this.getSourceWindow().receivesInputEvents()) {
            return;
        }
        if (this.firstUnusedEntry < this.eventQueue.length - 1) {
            this.eventQueue[this.firstUnusedEntry++] = keyEvent;
        }
        if (this.deferredEventsProcessed) {
            this.deferredEventsProcessed = false;
            SwingUtilities.invokeLater(this.deferredEventProcessor);
        }
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected AWTKeyboard(KeyboardFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Keyboard");
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if (event instanceof KeyEvent) {
                        AWTKeyboard.this.processKeyEvent((KeyEvent)event);
                    }
                }
            }, 8L);
        }
        catch (Throwable e) {
            throw new InputSystemException(e);
        }
    }
}

