/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.jinput;

import java.util.HashMap;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.impl.jinput.JInputControllerAxis;
import org.jagatoo.input.impl.jinput.JInputControllerButton;
import org.jagatoo.input.render.InputSourceWindow;

public class JInputController
extends Controller {
    private final net.java.games.input.Controller controller;
    private final HashMap<Component, DeviceComponent> deviceMap = new HashMap();
    final Event event = new Event();

    protected final net.java.games.input.Controller getController() {
        return this.controller;
    }

    protected final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime, boolean acceptsEvents) throws InputSystemException {
        if (!this.getSourceWindow().receivesInputEvents()) {
            return;
        }
        boolean isQueued = eventQueue != null;
        try {
            this.controller.poll();
            while (this.controller.getEventQueue().getNextEvent(this.event)) {
                boolean newState;
                DeviceComponent devComp;
                if (!acceptsEvents || (devComp = this.deviceMap.get(this.event.getComponent())) == null) continue;
                float value = this.event.getValue();
                if (devComp instanceof JInputControllerAxis) {
                    JInputControllerAxis axis = (JInputControllerAxis)devComp;
                    float oldValue = axis.getFloatValue();
                    if (value == oldValue) continue;
                    int oldIntValue = axis.getIntValue();
                    axis.setValue(value);
                    ControllerAxisChangedEvent axisEv = this.prepareControllerAxisChanged(axis, value - oldValue, nanoTime);
                    is.notifyInputStatesManagers(this, axis, axis.getIntValue(), axis.getIntValue() - oldIntValue, nanoTime);
                    if (isQueued) {
                        eventQueue.enqueue(axisEv);
                        continue;
                    }
                    this.fireOnControllerAxisChanged(axisEv, true);
                    continue;
                }
                if (!(devComp instanceof JInputControllerButton)) continue;
                JInputControllerButton button = (JInputControllerButton)devComp;
                boolean oldState = button.getBooleanState();
                boolean bl = newState = value != 0.0f;
                if (newState == oldState) continue;
                if (newState) {
                    button.setState(InputState.POSITIVE);
                    is.notifyInputStatesManagers(this, button, 1, 1, nanoTime);
                    ControllerButtonPressedEvent pressedEv = this.prepareControllerButtonPressed(button, nanoTime);
                    if (isQueued) {
                        eventQueue.enqueue(pressedEv);
                        continue;
                    }
                    this.fireOnControllerButtonPressed(pressedEv, true);
                    continue;
                }
                button.setState(InputState.NEGATIVE);
                is.notifyInputStatesManagers(this, button, 0, -1, nanoTime);
                ControllerButtonReleasedEvent releasedEv = this.prepareControllerButtonReleased(button, nanoTime);
                if (isQueued) {
                    eventQueue.enqueue(releasedEv);
                    continue;
                }
                this.fireOnControllerButtonReleased(releasedEv, true);
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, false);
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        boolean acceptEvents = this.isEnabled() && this.getSourceWindow().receivesInputEvents();
        this.collectOrFireEvents(is, eventQueue, nanoTime, acceptEvents);
    }

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, true);
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.CONTROLLER_EVENT);
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected final JInputControllerAxis[] createAxesArray(Object implObj) {
        net.java.games.input.Controller controller = (net.java.games.input.Controller)implObj;
        JInputControllerAxis[] axes0 = new JInputControllerAxis[controller.getComponents().length];
        int numAxes = 0;
        int i = 0;
        while (i < controller.getComponents().length) {
            Component component = controller.getComponents()[i];
            if (component.getIdentifier() instanceof Component.Identifier.Axis) {
                int index = numAxes++;
                axes0[index] = new JInputControllerAxis(this, component, index);
            }
            ++i;
        }
        JInputControllerAxis[] axes1 = new JInputControllerAxis[numAxes];
        System.arraycopy(axes0, 0, axes1, 0, numAxes);
        return axes1;
    }

    protected final JInputControllerButton[] createButtonsArray(Object implObj) {
        net.java.games.input.Controller controller = (net.java.games.input.Controller)implObj;
        JInputControllerButton[] buttons0 = new JInputControllerButton[controller.getComponents().length];
        int numButtons = 0;
        int i = 0;
        while (i < controller.getComponents().length) {
            Component component = controller.getComponents()[i];
            if (component.getIdentifier() instanceof Component.Identifier.Button) {
                int index = numButtons++;
                buttons0[index] = new JInputControllerButton(this, component, index);
            }
            ++i;
        }
        JInputControllerButton[] buttons1 = new JInputControllerButton[numButtons];
        System.arraycopy(buttons0, 0, buttons1, 0, numButtons);
        return buttons1;
    }

    protected JInputController(ControllerFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue, net.java.games.input.Controller controller) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, controller.getName(), controller);
        this.controller = controller;
        int i = 0;
        while (i < this.getAxesCount()) {
            JInputControllerAxis axis = (JInputControllerAxis)this.getAxis(i);
            this.deviceMap.put(axis.getAxis(), axis);
            ++i;
        }
        i = 0;
        while (i < this.getButtonsCount()) {
            JInputControllerButton button = (JInputControllerButton)this.getButton(i);
            this.deviceMap.put(button.getButton(), button);
            ++i;
        }
    }
}

