/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.lwjgl;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.impl.lwjgl.LWJGLMessageProcessor;
import org.jagatoo.input.render.InputSourceWindow;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;

public class LWJGLMouse
extends Mouse {
    private static final MouseButton[] buttonMap = new MouseButton[12];

    static {
        LWJGLMouse.buttonMap[0] = MouseButtons.LEFT_BUTTON;
        LWJGLMouse.buttonMap[1] = MouseButtons.RIGHT_BUTTON;
        LWJGLMouse.buttonMap[2] = MouseButtons.MIDDLE_BUTTON;
        LWJGLMouse.buttonMap[3] = MouseButtons.EXT_BUTTON_1;
        LWJGLMouse.buttonMap[4] = MouseButtons.EXT_BUTTON_2;
        LWJGLMouse.buttonMap[5] = MouseButtons.EXT_BUTTON_3;
        LWJGLMouse.buttonMap[6] = MouseButtons.EXT_BUTTON_4;
        LWJGLMouse.buttonMap[7] = MouseButtons.EXT_BUTTON_5;
        LWJGLMouse.buttonMap[8] = MouseButtons.EXT_BUTTON_6;
        LWJGLMouse.buttonMap[9] = MouseButtons.EXT_BUTTON_7;
        LWJGLMouse.buttonMap[10] = MouseButtons.EXT_BUTTON_8;
        LWJGLMouse.buttonMap[11] = MouseButtons.EXT_BUTTON_9;
    }

    public static final MouseButton convertButton(int lwjglButton) {
        return buttonMap[lwjglButton];
    }

    public void setPosition(int x, int y) throws InputSystemException {
        super.setPosition(x, y);
        try {
            if (this.isAbsolute()) {
                org.lwjgl.input.Mouse.setCursorPosition(x, this.getSourceWindow().getHeight() - y);
            } else {
                this.storePosition(x, y);
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void centerMouse() throws InputSystemException {
        int centerX = 0;
        int centerY = 0;
        try {
            centerX = this.getSourceWindow().getWidth() / 2;
            centerY = this.getSourceWindow().getHeight() / 2;
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
        this.setPosition(centerX, centerY);
    }

    protected final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime, boolean acceptEvents) throws InputSystemException {
        boolean isQueued;
        boolean bl = isQueued = eventQueue != null;
        if (!Display.isCreated()) {
            throw new InputSystemException("Display is not created.");
        }
        if (!org.lwjgl.input.Mouse.isCreated()) {
            throw new InputSystemException("Mouse is not created.");
        }
        try {
            LWJGLMessageProcessor.processMessages(nanoTime);
            org.lwjgl.input.Mouse.poll();
            while (org.lwjgl.input.Mouse.next()) {
                if (!acceptEvents) continue;
                int x = org.lwjgl.input.Mouse.getEventX();
                int y = this.getSourceWindow().getHeight() - org.lwjgl.input.Mouse.getEventY();
                int dx = org.lwjgl.input.Mouse.getEventDX();
                int dy = -org.lwjgl.input.Mouse.getEventDY();
                int buttonIdx = org.lwjgl.input.Mouse.getEventButton();
                boolean buttonState = org.lwjgl.input.Mouse.getEventButtonState();
                int wheelDelta = org.lwjgl.input.Mouse.getEventDWheel() / 120;
                if (this.isAbsolute()) {
                    this.storePosition(x, y);
                }
                if (dx != 0 || dy != 0) {
                    MouseMovedEvent movEv = this.prepareMouseMovedEvent(this.getCurrentX(), this.getCurrentY(), dx, dy, nanoTime);
                    if (dx != 0) {
                        is.notifyInputStatesManagers(this, this.getXAxis(), x, dx, nanoTime);
                    }
                    if (dy != 0) {
                        is.notifyInputStatesManagers(this, this.getYAxis(), y, dy, nanoTime);
                    }
                    if (movEv == null) continue;
                    if (isQueued) {
                        eventQueue.enqueue(movEv);
                    } else {
                        this.fireOnMouseMoved(movEv, true);
                    }
                }
                if (buttonIdx != -1) {
                    MouseButton button = LWJGLMouse.convertButton(buttonIdx);
                    if (buttonState) {
                        MouseButtonPressedEvent pressedEv = this.prepareMouseButtonPressedEvent(button, nanoTime);
                        is.notifyInputStatesManagers(this, button, 1, 1, nanoTime);
                        if (pressedEv == null) continue;
                        if (isQueued) {
                            eventQueue.enqueue(pressedEv);
                        } else {
                            this.fireOnMouseButtonPressed(pressedEv, true);
                        }
                    } else {
                        MouseButtonReleasedEvent releasedEv = this.prepareMouseButtonReleasedEvent(button, nanoTime);
                        is.notifyInputStatesManagers(this, button, 0, -1, nanoTime);
                        if (releasedEv == null) continue;
                        if (isQueued) {
                            eventQueue.enqueue(releasedEv);
                        } else {
                            this.fireOnMouseButtonReleased(releasedEv, true);
                        }
                    }
                }
                if (wheelDelta == 0) continue;
                MouseWheelEvent wheelEv = this.prepareMouseWheelMovedEvent(wheelDelta, false, nanoTime);
                is.notifyInputStatesManagers(this, this.getWheel(), this.getWheel().getIntValue(), wheelDelta, nanoTime);
                if (wheelEv == null) continue;
                if (isQueued) {
                    eventQueue.enqueue(wheelEv);
                    continue;
                }
                this.fireOnMouseWheelMoved(wheelEv, true);
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, false);
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        boolean acceptEvents = this.isEnabled() && this.getSourceWindow().receivesInputEvents();
        this.collectOrFireEvents(is, eventQueue, nanoTime, acceptEvents);
    }

    public void updateMouse(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, true);
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.MOUSE_EVENT);
        this.handleClickedEvents(nanoTime, is.getMouseButtonClickThreshold());
    }

    protected void setAbsoluteImpl(boolean absolute) throws InputSystemException {
        try {
            org.lwjgl.input.Mouse.setGrabbed(!absolute);
            if (absolute) {
                org.lwjgl.input.Mouse.setCursorPosition(this.getCurrentX(), this.getSourceWindow().getHeight() - this.getCurrentY());
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void destroyImpl() throws InputSystemException {
        try {
            if (org.lwjgl.input.Mouse.isCreated()) {
                org.lwjgl.input.Mouse.destroy();
            }
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
    }

    private static int init_getNumButtons() throws InputSystemException {
        try {
            if (!org.lwjgl.input.Mouse.isCreated()) {
                org.lwjgl.input.Mouse.create();
            }
        }
        catch (LWJGLException e) {
            throw new InputSystemException(e);
        }
        return org.lwjgl.input.Mouse.getButtonCount();
    }

    private static boolean init_hasWheel() throws InputSystemException {
        try {
            if (!org.lwjgl.input.Mouse.isCreated()) {
                org.lwjgl.input.Mouse.create();
            }
        }
        catch (LWJGLException e) {
            throw new InputSystemException(e);
        }
        return org.lwjgl.input.Mouse.hasWheel();
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    protected LWJGLMouse(MouseFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Mouse", LWJGLMouse.init_getNumButtons(), LWJGLMouse.init_hasWheel());
    }
}

