/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.localization;

import java.util.HashMap;
import java.util.Locale;
import org.jagatoo.input.localization.mappings.Mapping;
import org.jagatoo.input.localization.mappings.german.MappingGermany;

public class KeyboardLocalizer {
    private static final Mapping DEFAULT_MAPPING = new MappingGermany();
    private static final HashMap<Locale, Mapping> mappingMap = new HashMap();
    private static Mapping mapping = null;

    public static void registerMapping(Locale locale, Mapping mapping) {
        mappingMap.put(locale, mapping);
    }

    public static final Mapping autoselectMapping() {
        Mapping mapping = mappingMap.get(Locale.getDefault());
        KeyboardLocalizer.mapping = mapping == null ? DEFAULT_MAPPING : mapping;
        return KeyboardLocalizer.mapping;
    }

    public static void setMapping(Mapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("mapping must not be null");
        }
        KeyboardLocalizer.mapping = mapping;
    }

    public static final Mapping getMapping() {
        if (mapping == null) {
            KeyboardLocalizer.autoselectMapping();
        }
        return mapping;
    }

    public static final String getCurrentMappingName() {
        Mapping mapping = KeyboardLocalizer.getMapping();
        if (mapping == null) {
            return "[NO MAPPING]";
        }
        return mapping.getClass().getName();
    }
}

