/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.localization.mappings.french;

import java.net.URL;
import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.localization.mappings.KeyLocalizationParser;
import org.jagatoo.input.localization.mappings.Mapping;
import org.jagatoo.input.localization.mappings.french.FrenchKeys;
import org.jagatoo.logging.Log;

public class MappingFrance
implements Mapping {
    private HashMap<String, String> localizedKeyNamesMap = null;

    public final Key getUpperYZKey() {
        return Keys.Z;
    }

    public final Key getLowerYZKey() {
        return Keys.Y;
    }

    public char getModifiedChar(Key key, char unmodChar, int modifierMask) {
        switch (key.getKeyID()) {
            case _0: {
                if (modifierMask == 1) {
                    return '0';
                }
                if (modifierMask != 8) break;
                return '@';
            }
            case _1: {
                if (modifierMask != 1) break;
                return '&';
            }
            case _2: {
                if (modifierMask == 1) {
                    return '\u00e9';
                }
                if (modifierMask != 8) break;
                return '~';
            }
            case _3: {
                if (modifierMask == 1) {
                    return '\"';
                }
                if (modifierMask != 8) break;
                return '#';
            }
            case _4: {
                if (modifierMask == 1) {
                    return '\'';
                }
                if (modifierMask != 8) break;
                return '{';
            }
            case _5: {
                if (modifierMask == 1) {
                    return '(';
                }
                if (modifierMask != 8) break;
                return '[';
            }
            case _6: {
                if (modifierMask == 1) {
                    return '-';
                }
                if (modifierMask != 8) break;
                return '|';
            }
            case _7: {
                if (modifierMask == 1) {
                    return '\u00e8';
                }
                if (modifierMask != 8) break;
                return '`';
            }
            case _8: {
                if (modifierMask == 1) {
                    return '_';
                }
                if (modifierMask != 8) break;
                return '\\';
            }
            case _9: {
                if (modifierMask == 1) {
                    return '\u00e7';
                }
                if (modifierMask != 8) break;
                return '^';
            }
            case E: {
                if (modifierMask != 8) break;
                return '\u20ac';
            }
            case CIRCUMFLEX: {
                if (modifierMask == 0) {
                    return '^';
                }
                if (modifierMask != 1) break;
                return '\u00a8';
            }
            case NUMPAD_DECIMAL: {
                return '.';
            }
            case LOCAL_KEY1: {
                if (modifierMask != 0) break;
                return '\u00b2';
            }
            case LOCAL_KEY2: {
                if (modifierMask == 0) {
                    return ')';
                }
                if (modifierMask == 1) {
                    return '\u00b0';
                }
                if (modifierMask != 8) break;
                return ']';
            }
            case LOCAL_KEY3: {
                if (modifierMask == 0) {
                    return '$';
                }
                if (modifierMask == 1) {
                    return '\u00a3';
                }
                if (modifierMask != 8) break;
                return '\u00a4';
            }
            case LOCAL_KEY4: {
                if (modifierMask == 0) {
                    return '\u00f9';
                }
                if (modifierMask != 1) break;
                return '%';
            }
            case LOCAL_KEY5: {
                if (modifierMask == 0) {
                    return '*';
                }
                if (modifierMask != 1) break;
                return '\u00b5';
            }
            case LOCAL_KEY6: {
                if (modifierMask == 0) {
                    return ',';
                }
                if (modifierMask != 1) break;
                return '?';
            }
            case LOCAL_KEY7: {
                if (modifierMask == 0) {
                    return ';';
                }
                if (modifierMask != 1) break;
                return '.';
            }
            case LOCAL_KEY8: {
                if (modifierMask == 0) {
                    return ':';
                }
                if (modifierMask != 1) break;
                return '/';
            }
            case LOCAL_KEY9: {
                if (modifierMask == 0) {
                    return '!';
                }
                if (modifierMask != 1) break;
                return '\u00a7';
            }
            case LOCAL_KEY10: {
                if (modifierMask == 0) {
                    return '^';
                }
                if (modifierMask != 1) break;
                return '\u00a8';
            }
            case LOCAL_KEY11: {
                if (modifierMask == 0) {
                    return '=';
                }
                if (modifierMask == 1) {
                    return '+';
                }
                if (modifierMask != 8) break;
                return '}';
            }
        }
        return '\u0000';
    }

    public Key getLocalizedKey(char keyChar) {
        System.out.println("key char =" + keyChar);
        switch (keyChar) {
            case '\u00b2': {
                return FrenchKeys.SUPERSCRIPT_TWO;
            }
            case '$': 
            case '\u00a3': {
                return FrenchKeys.DOLLAR;
            }
            case '^': 
            case '\u00a8': {
                return Keys.CIRCUMFLEX;
            }
            case '*': 
            case '\u00b5': {
                return FrenchKeys.ASTERISK;
            }
            case '%': 
            case '\u00f9': {
                return FrenchKeys.U_ACCENT;
            }
            case '!': 
            case '\u00a7': {
                return FrenchKeys.EXCLAMATION;
            }
            case '/': 
            case ':': {
                return FrenchKeys.COLON;
            }
            case '.': 
            case ';': {
                return FrenchKeys.SEMICOLON;
            }
            case ',': 
            case '?': {
                return FrenchKeys.COMMA;
            }
            case '+': 
            case '=': 
            case '}': {
                return FrenchKeys.EQUAL;
            }
            case ')': 
            case ']': 
            case '\u00b0': {
                return FrenchKeys.PARENTHESIS_CLOSE;
            }
            case '<': 
            case '>': {
                return FrenchKeys.UPPER;
            }
        }
        return null;
    }

    public String getLocalizedKeyName(DeviceComponent key) {
        String locName;
        if (this.localizedKeyNamesMap == null) {
            this.localizedKeyNamesMap = new HashMap();
            try {
                String packageName = this.getClass().getPackage().getName().replace('.', '/');
                String filename = "/" + packageName + "/keynames.french";
                URL resource = this.getClass().getResource(filename);
                if (resource != null) {
                    Log.debug(InputSystem.LOG_CHANNEL, "Parsing key-localization file ", filename, "...");
                    int numValidLines = KeyLocalizationParser.parse(resource, this.localizedKeyNamesMap);
                    Log.debug(InputSystem.LOG_CHANNEL, "parsing done. Found ", numValidLines, " valid lines.");
                }
            }
            catch (Throwable t) {
                Log.print(InputSystem.LOG_CHANNEL, t);
                t.printStackTrace();
            }
        }
        if ((locName = this.localizedKeyNamesMap.get(key.getName())) == null) {
            return key.getName();
        }
        return locName;
    }
}

