/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.localization.mappings.german;

import java.net.URL;
import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.localization.mappings.KeyLocalizationParser;
import org.jagatoo.input.localization.mappings.Mapping;
import org.jagatoo.input.localization.mappings.german.GermanKeys;
import org.jagatoo.logging.Log;

public class MappingGermany
implements Mapping {
    private HashMap<String, String> localizedKeyNamesMap = null;

    public final Key getUpperYZKey() {
        return Keys.Z;
    }

    public final Key getLowerYZKey() {
        return Keys.Y;
    }

    public char getModifiedChar(Key key, char unmodChar, int modifierMask) {
        switch (key.getKeyID()) {
            case _0: {
                if (modifierMask == 1) {
                    return '=';
                }
                if (modifierMask != 8) break;
                return '}';
            }
            case _1: {
                if (modifierMask == 1) {
                    return '!';
                }
                if (modifierMask != 8) break;
                return '\u00b9';
            }
            case _2: {
                if (modifierMask == 1) {
                    return '\"';
                }
                if (modifierMask != 8) break;
                return '\u00b2';
            }
            case _3: {
                if (modifierMask == 1) {
                    return '\u00a7';
                }
                if (modifierMask != 8) break;
                return '\u00b3';
            }
            case _4: {
                if (modifierMask == 1) {
                    return '$';
                }
                if (modifierMask != 8) break;
                return '\u00bc';
            }
            case _5: {
                if (modifierMask == 1) {
                    return '%';
                }
                if (modifierMask != 8) break;
                return '\u00bd';
            }
            case _6: {
                if (modifierMask == 1) {
                    return '&';
                }
                if (modifierMask != 8) break;
                return '\u00ac';
            }
            case _7: {
                if (modifierMask == 1) {
                    return '/';
                }
                if (modifierMask != 8) break;
                return '{';
            }
            case _8: {
                if (modifierMask == 1) {
                    return '(';
                }
                if (modifierMask != 8) break;
                return '[';
            }
            case _9: {
                if (modifierMask == 1) {
                    return ')';
                }
                if (modifierMask != 8) break;
                return ']';
            }
            case A: {
                if (modifierMask != 8) break;
                return '\u00e6';
            }
            case B: {
                if (modifierMask != 8) break;
                return '\u201d';
            }
            case C: {
                if (modifierMask != 8) break;
                return '\u00a2';
            }
            case D: {
                if (modifierMask != 8) break;
                return '\u00f0';
            }
            case E: {
                if (modifierMask != 8) break;
                return '\u20ac';
            }
            case F: {
                if (modifierMask != 8) break;
                return '\u0111';
            }
            case G: {
                if (modifierMask != 8) break;
                return '\u014b';
            }
            case H: {
                if (modifierMask != 8) break;
                return '\u0127';
            }
            case I: {
                if (modifierMask != 8) break;
                return '\u2192';
            }
            case J: {
                break;
            }
            case K: {
                if (modifierMask != 8) break;
                return '\u0138';
            }
            case L: {
                if (modifierMask != 8) break;
                return '\u0142';
            }
            case M: {
                if (modifierMask != 8) break;
                return '\u00b5';
            }
            case N: {
                break;
            }
            case O: {
                if (modifierMask != 8) break;
                return '\u00f8';
            }
            case P: {
                if (modifierMask != 8) break;
                return '\u00fe';
            }
            case Q: {
                if (modifierMask != 8) break;
                return '@';
            }
            case R: {
                if (modifierMask != 8) break;
                return '\u00b6';
            }
            case S: {
                if (modifierMask != 8) break;
                return '\u00df';
            }
            case T: {
                if (modifierMask != 8) break;
                return '\u0167';
            }
            case U: {
                if (modifierMask != 8) break;
                return '\u2193';
            }
            case V: {
                if (modifierMask != 8) break;
                return '\u201c';
            }
            case W: {
                if (modifierMask != 8) break;
                return '\u0142';
            }
            case X: {
                if (modifierMask != 8) break;
                return '\u00bb';
            }
            case Y: {
                if (modifierMask != 8) break;
                return '\u00ab';
            }
            case Z: {
                if (modifierMask != 8) break;
                return '\u2190';
            }
            case CIRCUMFLEX: {
                if (modifierMask == 0) {
                    return '^';
                }
                if (modifierMask == 1) {
                    return '\u00b0';
                }
                if (modifierMask != 8) break;
                return '\u00ac';
            }
            case NUMPAD_DECIMAL: {
                return ',';
            }
            case LOCAL_KEY1: {
                if (modifierMask == 0) {
                    return '\u00df';
                }
                if (modifierMask == 1) {
                    return '?';
                }
                if (modifierMask != 8) break;
                return '\\';
            }
            case LOCAL_KEY2: {
                if (modifierMask == 0) {
                    return '\'';
                }
                if (modifierMask == 1) {
                    return '`';
                }
                if (modifierMask != 8) break;
                return '\u00b8';
            }
            case LOCAL_KEY3: {
                if (modifierMask == 0) {
                    return '\u00fc';
                }
                if (modifierMask == 1) {
                    return '\u00dc';
                }
                if (modifierMask != 8) break;
                return '\u00a8';
            }
            case LOCAL_KEY4: {
                if (modifierMask == 0) {
                    return '+';
                }
                if (modifierMask == 1) {
                    return '*';
                }
                if (modifierMask != 8) break;
                return '~';
            }
            case LOCAL_KEY5: {
                if (modifierMask == 0) {
                    return '\u00f6';
                }
                if (modifierMask == 1) {
                    return '\u00d6';
                }
                if (modifierMask != 8) break;
                return '\u02dd';
            }
            case LOCAL_KEY6: {
                if (modifierMask == 0) {
                    return '\u00e4';
                }
                if (modifierMask == 1) {
                    return '\u00c4';
                }
                if (modifierMask != 8) break;
                return '^';
            }
            case LOCAL_KEY7: {
                if (modifierMask == 0) {
                    return '#';
                }
                if (modifierMask == 1) {
                    return '\'';
                }
                if (modifierMask != 8) break;
                return '`';
            }
            case LOCAL_KEY8: {
                if (modifierMask == 0) {
                    return ',';
                }
                if (modifierMask != 1) break;
                return ';';
            }
            case LOCAL_KEY9: {
                if (modifierMask == 0) {
                    return '.';
                }
                if (modifierMask == 1) {
                    return ':';
                }
                if (modifierMask != 8) break;
                return '\u00b7';
            }
            case LOCAL_KEY10: {
                if (modifierMask == 0) {
                    return '-';
                }
                if (modifierMask != 1) break;
                return '_';
            }
            case LOCAL_KEY11: {
                if (modifierMask == 0) {
                    return '<';
                }
                if (modifierMask == 1) {
                    return '>';
                }
                if (modifierMask != 8) break;
                return '|';
            }
        }
        return '\u0000';
    }

    public Key getLocalizedKey(char keyChar) {
        switch (keyChar) {
            case '?': 
            case '\\': 
            case '\u00df': {
                return GermanKeys.SZ;
            }
            case '\u00b8': {
                return GermanKeys.APOSTROPH;
            }
            case '^': 
            case '\u00c4': 
            case '\u00e4': {
                return GermanKeys.AE;
            }
            case '\u00d6': 
            case '\u00f6': 
            case '\u02dd': {
                return GermanKeys.OE;
            }
            case '\u00a8': 
            case '\u00dc': 
            case '\u00fc': {
                return GermanKeys.UE;
            }
            case '*': 
            case '+': 
            case '~': {
                return GermanKeys.ADD;
            }
            case '#': 
            case '\'': 
            case '`': {
                return GermanKeys.DIAMOND;
            }
            case '<': 
            case '>': 
            case '|': {
                return GermanKeys.RELATION;
            }
            case ',': 
            case ';': {
                return GermanKeys.COMMA;
            }
            case '.': 
            case '0': 
            case '\u00b7': {
                return GermanKeys.PERIOD;
            }
            case '-': 
            case '_': {
                return GermanKeys.SUBTRACT;
            }
        }
        return null;
    }

    public String getLocalizedKeyName(DeviceComponent key) {
        String locName;
        if (this.localizedKeyNamesMap == null) {
            this.localizedKeyNamesMap = new HashMap();
            try {
                String packageName = this.getClass().getPackage().getName().replace('.', '/');
                String filename = "/" + packageName + "/keynames.german";
                URL resource = this.getClass().getResource(filename);
                if (resource != null) {
                    Log.debug(InputSystem.LOG_CHANNEL, "Parsing key-localization file ", filename, "...");
                    int numValidLines = KeyLocalizationParser.parse(resource, this.localizedKeyNamesMap);
                    Log.debug(InputSystem.LOG_CHANNEL, "parsing done. Found ", numValidLines, " valid lines.");
                }
            }
            catch (Throwable t) {
                Log.print(InputSystem.LOG_CHANNEL, t);
                t.printStackTrace();
            }
        }
        if ((locName = this.localizedKeyNamesMap.get(key.getName())) == null) {
            return key.getName();
        }
        return locName;
    }
}

