/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.managers.InputHotPlugListener;
import org.jagatoo.logging.Log;
import org.jagatoo.util.arrays.ArrayUtils;

public class InputHotPlugManager
implements Runnable {
    private KeyboardFactory[] keyboardFactories = null;
    private MouseFactory[] mouseFactories = null;
    private ControllerFactory[] controllerFactories = null;
    private final HashMap<KeyboardFactory, Keyboard[]> cachedKeyboardsMap = new HashMap();
    private final HashMap<MouseFactory, Mouse[]> cachedMousesMap = new HashMap();
    private final HashMap<ControllerFactory, Controller[]> cachedControllersMap = new HashMap();
    private final ArrayList<InputHotPlugListener> listeners = new ArrayList();
    private Thread thread = null;
    private boolean running = false;

    private void refreshCachedKeyboards(KeyboardFactory factory) throws InputSystemException {
        Keyboard[] keyboards = factory.getKeyboards(true);
        this.cachedKeyboardsMap.put(factory, keyboards);
    }

    private void refreshCachedMouses(MouseFactory factory) throws InputSystemException {
        Mouse[] mouses = factory.getMouses(true);
        this.cachedMousesMap.put(factory, mouses);
    }

    private void refreshCachedControllers(ControllerFactory factory) throws InputSystemException {
        Controller[] controllers = factory.getControllers(true);
        this.cachedControllersMap.put(factory, controllers);
    }

    public void registerKeyboardFactory(KeyboardFactory factory) throws InputSystemException {
        if (this.keyboardFactories == null) {
            this.keyboardFactories = new KeyboardFactory[]{factory};
        } else {
            if (ArrayUtils.contains(this.keyboardFactories, factory, true)) {
                throw new InputSystemException("This factory is already registered.");
            }
            KeyboardFactory[] newArray = new KeyboardFactory[this.keyboardFactories.length + 1];
            System.arraycopy(this.keyboardFactories, 0, newArray, 0, this.keyboardFactories.length);
            newArray[newArray.length - 1] = factory;
            this.keyboardFactories = newArray;
        }
    }

    public void deregisterKeyboardFactory(KeyboardFactory factory) throws InputSystemException {
        if (this.keyboardFactories == null || !ArrayUtils.contains(this.keyboardFactories, factory, true)) {
            throw new InputSystemException("This factory is not registered.");
        }
        int index = ArrayUtils.indexOf(this.keyboardFactories, factory, true);
        KeyboardFactory[] newArray = new KeyboardFactory[this.keyboardFactories.length - 1];
        System.arraycopy(this.keyboardFactories, 0, newArray, 0, index);
        System.arraycopy(this.keyboardFactories, index + 1, newArray, index, this.keyboardFactories.length - index - 1);
        this.keyboardFactories = newArray;
    }

    public void registerMouseFactory(MouseFactory factory) throws InputSystemException {
        if (this.mouseFactories == null) {
            this.mouseFactories = new MouseFactory[]{factory};
        } else {
            if (ArrayUtils.contains(this.mouseFactories, factory, true)) {
                throw new InputSystemException("This factory is already registered.");
            }
            MouseFactory[] newArray = new MouseFactory[this.mouseFactories.length + 1];
            System.arraycopy(this.mouseFactories, 0, newArray, 0, this.mouseFactories.length);
            newArray[newArray.length - 1] = factory;
            this.mouseFactories = newArray;
        }
    }

    public void deregisterMouseFactory(MouseFactory factory) throws InputSystemException {
        if (this.mouseFactories == null || !ArrayUtils.contains(this.mouseFactories, factory, true)) {
            throw new InputSystemException("This factory is not registered.");
        }
        int index = ArrayUtils.indexOf(this.mouseFactories, factory, true);
        MouseFactory[] newArray = new MouseFactory[this.mouseFactories.length - 1];
        System.arraycopy(this.mouseFactories, 0, newArray, 0, index);
        System.arraycopy(this.mouseFactories, index + 1, newArray, index, this.mouseFactories.length - index - 1);
        this.mouseFactories = newArray;
    }

    public void registerControllerFactory(ControllerFactory factory) throws InputSystemException {
        if (this.controllerFactories == null) {
            this.controllerFactories = new ControllerFactory[]{factory};
        } else {
            if (ArrayUtils.contains(this.controllerFactories, factory, true)) {
                throw new InputSystemException("This factory is already registered.");
            }
            ControllerFactory[] newArray = new ControllerFactory[this.controllerFactories.length + 1];
            System.arraycopy(this.controllerFactories, 0, newArray, 0, this.controllerFactories.length);
            newArray[newArray.length - 1] = factory;
            this.controllerFactories = newArray;
        }
    }

    public void deregisterControllerFactory(ControllerFactory factory) throws InputSystemException {
        if (this.controllerFactories == null || !ArrayUtils.contains(this.controllerFactories, factory, true)) {
            throw new InputSystemException("This factory is not registered.");
        }
        int index = ArrayUtils.indexOf(this.controllerFactories, factory, true);
        ControllerFactory[] newArray = new ControllerFactory[this.controllerFactories.length - 1];
        System.arraycopy(this.controllerFactories, 0, newArray, 0, index);
        System.arraycopy(this.controllerFactories, index + 1, newArray, index, this.controllerFactories.length - index - 1);
        this.controllerFactories = newArray;
    }

    public void registerDeviceFactory(InputDeviceFactory factory) throws InputSystemException {
        this.registerKeyboardFactory(factory);
        this.registerMouseFactory(factory);
        this.registerControllerFactory(factory);
    }

    public void deregisterDeviceFactory(InputDeviceFactory factory) throws InputSystemException {
        this.deregisterKeyboardFactory(factory);
        this.deregisterMouseFactory(factory);
        this.deregisterControllerFactory(factory);
    }

    public void addHotPlugListener(InputHotPlugListener l) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) == l) {
                return;
            }
            ++i;
        }
        this.listeners.add(l);
    }

    public void removeHotPlugListener(InputHotPlugListener l) {
        this.listeners.remove(l);
    }

    protected void notifyListeners(InputDevice[] devices0, InputDevice[] devices1) {
        int j;
        int i = 0;
        while (i < devices1.length) {
            InputDevice device1 = devices1[i];
            if (!ArrayUtils.contains(devices0, device1, true)) {
                j = 0;
                while (j < this.listeners.size()) {
                    this.listeners.get(j).onInputDevicePluggedIn(device1);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < devices0.length) {
            InputDevice device0 = devices0[i];
            if (!ArrayUtils.contains(devices1, device0, true)) {
                j = 0;
                while (j < this.listeners.size()) {
                    this.listeners.get(j).onInputDevicePluggedOut(device0);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run() {
        this.running = true;
        while (this.thread != null) {
            try {
                Object factory;
                int i;
                if (this.keyboardFactories != null) {
                    i = 0;
                    while (i < this.keyboardFactories.length) {
                        InputDevice[] cachedKeyboards1;
                        factory = this.keyboardFactories[i];
                        InputDevice[] cachedKeyboards0 = this.cachedKeyboardsMap.get(factory);
                        this.refreshCachedKeyboards((KeyboardFactory)factory);
                        if (cachedKeyboards0 != null && cachedKeyboards0.length != (cachedKeyboards1 = this.cachedKeyboardsMap.get(factory)).length) {
                            this.notifyListeners(cachedKeyboards0, cachedKeyboards1);
                        }
                        ++i;
                    }
                }
                if (this.mouseFactories != null) {
                    i = 0;
                    while (i < this.mouseFactories.length) {
                        InputDevice[] cachedMouses1;
                        factory = this.mouseFactories[i];
                        InputDevice[] cachedMouses0 = this.cachedMousesMap.get(factory);
                        this.refreshCachedMouses((MouseFactory)factory);
                        if (cachedMouses0 != null && cachedMouses0.length != (cachedMouses1 = this.cachedMousesMap.get(factory)).length) {
                            this.notifyListeners(cachedMouses0, cachedMouses1);
                        }
                        ++i;
                    }
                }
                if (this.controllerFactories != null) {
                    i = 0;
                    while (i < this.controllerFactories.length) {
                        InputDevice[] cachedControllers1;
                        factory = this.controllerFactories[i];
                        InputDevice[] cachedControllers0 = this.cachedControllersMap.get(factory);
                        this.refreshCachedControllers((ControllerFactory)factory);
                        if (cachedControllers0 != null && cachedControllers0.length != (cachedControllers1 = this.cachedControllersMap.get(factory)).length) {
                            this.notifyListeners(cachedControllers0, cachedControllers1);
                        }
                        ++i;
                    }
                }
            }
            catch (InputSystemException e) {
                Log.print(InputSystem.LOG_CHANNEL, e);
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.print(InputSystem.LOG_CHANNEL, e);
                e.printStackTrace();
            }
        }
        this.running = false;
    }

    public final boolean isRunning() {
        return this.thread != null || this.running;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop(boolean wait) {
        this.thread = null;
        if (wait) {
            while (this.running) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Log.print(InputSystem.LOG_CHANNEL, e);
                    e.printStackTrace();
                }
            }
        }
    }
}

