/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.jagatoo.datatypes.NamableObject;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.ase.AseFile;
import org.jagatoo.loaders.models.ase.AseGeom;
import org.jagatoo.loaders.models.ase.AseGroup;
import org.jagatoo.loaders.models.ase.AseMap;
import org.jagatoo.loaders.models.ase.AseMaterial;
import org.jagatoo.loaders.models.ase.AseMesh;
import org.jagatoo.loaders.models.ase.AseNode;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.ShadeModel;
import org.jagatoo.opengl.enums.TestFunction;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.MatrixUtils;

public class AseConverter {
    private static final GeometryFactory.GeometryType GEOM_TYPE = GeometryFactory.GeometryType.TRIANGLE_ARRAY;
    private static boolean TGT_GROUPS_ONLY = false;
    private static boolean TGT_NO_GROUPS = false;
    private static boolean TGT_NO_TRANSLATE_TG = false;
    private final HashMap<String, NamedObject> appearanceCache = new HashMap();

    private NamedObject getTriangleArray(AseMesh aseMesh, int matID, AseMap map, Tuple3f pivotPoint, GeometryFactory geomFactory) {
        try {
            int v;
            int f;
            int nFaces = matID < 0 ? aseMesh.numFaces : aseMesh.totals[matID];
            JAGTLog.debug("Getting mesh for sub-material ", matID, " with ", nFaces, " faces");
            NamedObject geom = geomFactory.createGeometry("", GEOM_TYPE, 3, nFaces * 3, 0, null);
            float[] coords = new float[nFaces * 3 * 3];
            int n = 0;
            int f2 = 0;
            while (f2 < aseMesh.numFaces) {
                if (aseMesh.faceMat[f2] == matID || matID < 0) {
                    int v2 = 0;
                    while (v2 < 3) {
                        if (aseMesh.convertMeshCoordinates) {
                            coords[(n * 3 + v2) * 3 + 0] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 1] - pivotPoint.getX();
                            coords[(n * 3 + v2) * 3 + 1] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 2] - pivotPoint.getY();
                            coords[(n * 3 + v2) * 3 + 2] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 0] - pivotPoint.getZ();
                        } else {
                            coords[(n * 3 + v2) * 3 + 0] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 0] - pivotPoint.getX();
                            coords[(n * 3 + v2) * 3 + 1] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 1] - pivotPoint.getY();
                            coords[(n * 3 + v2) * 3 + 2] = aseMesh.vertices[aseMesh.faces[f2 * 3 + v2] * 3 + 2] - pivotPoint.getZ();
                        }
                        ++v2;
                    }
                    ++n;
                }
                ++f2;
            }
            if (n != nFaces) {
                throw new Error("Invalid number of vertices initialized");
            }
            geomFactory.setCoordinates(geom, GEOM_TYPE, 0, coords, 0, nFaces * 3);
            if (aseMesh.normals != null) {
                n = 0;
                float[] norms = new float[nFaces * 3 * 3];
                f = 0;
                while (f < aseMesh.numFaces) {
                    if (aseMesh.faceMat[f] == matID || matID < 0) {
                        v = 0;
                        while (v < 3) {
                            if (aseMesh.convertMeshCoordinates) {
                                norms[(n * 3 + v) * 3 + 0] = -aseMesh.normals[(f * 3 + v) * 3 + 2];
                                norms[(n * 3 + v) * 3 + 1] = aseMesh.normals[(f * 3 + v) * 3 + 1];
                                norms[(n * 3 + v) * 3 + 2] = aseMesh.normals[(f * 3 + v) * 3 + 0];
                            } else {
                                norms[(n * 3 + v) * 3 + 0] = aseMesh.normals[(f * 3 + v) * 3 + 0];
                                norms[(n * 3 + v) * 3 + 1] = aseMesh.normals[(f * 3 + v) * 3 + 1];
                                norms[(n * 3 + v) * 3 + 2] = aseMesh.normals[(f * 3 + v) * 3 + 2];
                            }
                            ++v;
                        }
                        ++n;
                    }
                    ++f;
                }
                geomFactory.setNormals(geom, GEOM_TYPE, 0, norms, 0, nFaces * 3);
            }
            if (aseMesh.texVertices != null && aseMesh.texFaces != null && map != null) {
                n = 0;
                float[] texcoords = new float[nFaces * 3 * 2];
                f = 0;
                while (f < aseMesh.numFaces) {
                    if (aseMesh.faceMat[f] == matID || matID < 0) {
                        v = 0;
                        while (v < 3) {
                            texcoords[(n * 3 + v) * 2 + 0] = aseMesh.texVertices[aseMesh.texFaces[f * 3 + v] * 2 + 0] / map.uTiling;
                            texcoords[(n * 3 + v) * 2 + 1] = aseMesh.texVertices[aseMesh.texFaces[f * 3 + v] * 2 + 1] / map.vTiling;
                            ++v;
                        }
                        ++n;
                    }
                    ++f;
                }
                geomFactory.setTexCoords(geom, GEOM_TYPE, 0, 2, 0, texcoords, 0, nFaces * 3);
            }
            return geom;
        }
        catch (Exception e) {
            JAGTLog.print(e);
            throw new Error(e);
        }
    }

    private NamedObject getAppearance(AseGeom geom, AseMaterial aseMat, AppearanceFactory appFactory, URL baseURL) {
        String texName;
        NamedObject app = null;
        if (aseMat.name != null && aseMat.name.length() > 0 && (app = this.appearanceCache.get(aseMat.name)) != null) {
            return app;
        }
        app = appFactory.createAppearance(aseMat.name, 0);
        boolean hasTexture = false;
        NamedObject ra = appFactory.createRenderingAttributesAttributes("");
        appFactory.setRenderingAttribsDepthBufferEnabled(ra, true);
        appFactory.setRenderingAttribsDepthBufferWriteEnabled(ra, true);
        NamedObject mat = appFactory.createMaterial("");
        appFactory.setMaterialAmbientColor(mat, 0.75f, 0.75f, 0.75f);
        appFactory.setMaterialDiffuseColor(mat, 0.75f, 0.75f, 0.75f);
        appFactory.setMaterialSpecularColor(mat, 0.0f, 0.0f, 0.0f);
        appFactory.setMaterialLightingEnabled(mat, false);
        appFactory.applyMaterial(mat, app);
        NamedObject polyAttribs = appFactory.createPolygonAttributes("");
        appFactory.setPolygonAttribsDrawMode(polyAttribs, DrawMode.FILL);
        appFactory.setPolygonAttribsFaceCullMode(polyAttribs, FaceCullMode.BACK);
        if (aseMat.opacityMap != null) {
            texName = aseMat.opacityMap.bitmap;
            if (texName.startsWith("\\\\")) {
                texName = texName.substring(2);
            }
            texName = texName.replace('\\', '/');
            JAGTLog.debug("opacity texture name is ", texName);
            AbstractTexture tex = appFactory.loadOrGetTexture(texName, baseURL, true, true, true, true, true);
            JAGTLog.debug("setting name to ", texName);
            JAGTLog.debug("checked name is ", tex.getName());
            appFactory.applyTexture(tex, 0, app);
            appFactory.setRenderingAttribsAlphaTestFunction(ra, TestFunction.GREATER);
            appFactory.setRenderingAttribsAlphaTestValue(ra, 0.05f);
            appFactory.setPolygonAttribsFaceCullMode(polyAttribs, FaceCullMode.NONE);
            if (tex.getFormat().hasAlpha() || aseMat.opacityMap.amount != 1.0f) {
                NamedObject transpAttribs = appFactory.createTransparencyAttributes("");
                appFactory.setTransparencyAttribsBlendMode(transpAttribs, BlendMode.BLENDED);
                appFactory.setTransparencyAttribsTransparency(transpAttribs, aseMat.opacityMap.amount);
                appFactory.applyTransparancyAttributes(transpAttribs, app);
            }
            hasTexture = true;
        } else if (aseMat.diffuseMap != null && aseMat.diffuseMap.bitmap != null) {
            texName = aseMat.diffuseMap.bitmap;
            if (texName.startsWith("\\\\")) {
                texName = texName.substring(2);
            }
            texName = texName.replace('\\', '/');
            JAGTLog.debug("texture name is ", texName);
            AbstractTexture tex = appFactory.loadOrGetTexture(texName, baseURL, true, false, true, true, true);
            appFactory.applyTexture(tex, 0, app);
            hasTexture = true;
        }
        appFactory.applyRenderingAttributes(ra, app);
        appFactory.applyPolygonAttributes(polyAttribs, app);
        if (!hasTexture) {
            NamedObject colorAttribs = appFactory.createColoringAttributes("");
            appFactory.setColoringAttribsColor(colorAttribs, new float[]{geom.wireframeColor.getRed(), geom.wireframeColor.getGreen(), geom.wireframeColor.getBlue()}, 0, 3);
            appFactory.setColoringAttribsShadeModel(colorAttribs, ShadeModel.GOURAUD);
            appFactory.applyColoringAttributes(colorAttribs, app);
        } else {
            NamedObject texAttribs = appFactory.createTextureAttributes("");
            appFactory.setTextureAttribsTextureMode(texAttribs, TextureMode.MODULATE);
            appFactory.setTextureAttribsTextureBlendColor(texAttribs, new float[]{1.0f, 0.5f, 0.5f, 0.1f}, 0, 4);
            appFactory.applyTextureAttributes(texAttribs, 0, app);
        }
        if (aseMat.name != null && aseMat.name.length() > 0) {
            this.appearanceCache.put(app.getName(), app);
        }
        return app;
    }

    private NamedObject getShape(AseFile file, AseGeom aseGeom, Tuple3f geomOffset, AppearanceFactory appFactory, URL baseURL, GeometryFactory geomFactory, NodeFactory nodeFactory) {
        JAGTLog.debug("Shape ", aseGeom.name, " using material ref ", aseGeom.materialRef);
        AseMaterial m = file.materials.size() > 0 ? file.materials.get(aseGeom.materialRef) : new AseMaterial();
        if (m.subMaterials.size() > 0) {
            NamedObject group = nodeFactory.createSimpleGroup(aseGeom.name, BoundsType.SPHERE);
            JAGTLog.debug("   Shape ", aseGeom.name, " has sub-materials, building multiple objects");
            int i = 0;
            while (i < m.subMaterials.size()) {
                try {
                    AseMaterial mat = m.subMaterials.get(i);
                    NamedObject app = this.getAppearance(aseGeom, mat, appFactory, baseURL);
                    NamedObject geom = this.getTriangleArray(aseGeom.mesh, i, mat.diffuseMap, geomOffset, geomFactory);
                    NamedObject shape = nodeFactory.createShape("", geom, app, BoundsType.SPHERE);
                    nodeFactory.addNodeToGroup(shape, group);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
            return group;
        }
        try {
            NamedObject app = this.getAppearance(aseGeom, m, appFactory, baseURL);
            NamedObject geom = this.getTriangleArray(aseGeom.mesh, -1, m.diffuseMap, geomOffset, geomFactory);
            NamedObject shape = nodeFactory.createShape("", geom, app, BoundsType.SPHERE);
            return shape;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return nodeFactory.createDummyNode();
        }
    }

    private void applyPivotTranslation(AseGeom aseGeom, Tuple3f pivotOffset, NamedObject tg, NodeFactory nodeFactory) {
        Tuple3f pivot = aseGeom.getPivot();
        nodeFactory.setTransformGroupTranslation(tg, pivot.getX() - pivotOffset.getX(), pivot.getY() - pivotOffset.getY(), pivot.getZ() - pivotOffset.getZ());
    }

    private void addGeometry(NamedObject tg, AseFile file, AseGeom aseGeom, Tuple3f geomPivot, AppearanceFactory appFactory, URL baseURL, GeometryFactory geomFactory, NodeFactory nodeFactory, SpecialItemsHandler siHandler) {
        if (aseGeom instanceof AseGroup) {
            AseGroup aseGroup = (AseGroup)aseGeom;
            ((NamableObject)tg).setName(aseGroup.name);
            for (AseGeom aseGeom2 : aseGroup.objects.values()) {
                this.createTransformGroupTree(tg, file, aseGeom2, geomPivot, appFactory, baseURL, geomFactory, nodeFactory, siHandler);
            }
        } else {
            nodeFactory.addNodeToGroup(this.getShape(file, aseGeom, geomPivot, appFactory, baseURL, geomFactory, nodeFactory), tg);
        }
    }

    private void createTransformGroupTree(NamedObject parentGroup, AseFile file, AseGeom aseGeom, Tuple3f pivotOffset, AppearanceFactory appFactory, URL baseURL, GeometryFactory geomFactory, NodeFactory nodeFactory, SpecialItemsHandler siHandler) {
        Tuple3f pivot;
        NamedObject group;
        if (TGT_GROUPS_ONLY && TGT_NO_GROUPS) {
            throw new IllegalArgumentException("Can't use both AseFile.TGT_GROUPS_ONLY and AseFile.TGT_NOGROUPS together.  Perhaps you want the AseFile.getModel() method");
        }
        if (!TGT_GROUPS_ONLY || aseGeom instanceof AseGroup && !TGT_NO_GROUPS) {
            NamedObject translation;
            group = !"".equals(aseGeom.name) ? nodeFactory.createTransformGroup(aseGeom.name, BoundsType.SPHERE) : nodeFactory.createTransformGroup("", BoundsType.SPHERE);
            if (group.getName().length() > 0) {
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NESTED_TRANSFORM, group.getName(), group);
            }
            if (TGT_NO_TRANSLATE_TG) {
                translation = group;
            } else {
                translation = aseGeom.name != null && aseGeom.name.length() > 0 ? nodeFactory.createTransformGroup(String.valueOf(aseGeom.name) + "Translation", BoundsType.SPHERE) : nodeFactory.createTransformGroup("", BoundsType.SPHERE);
                nodeFactory.addNodeToGroup(group, translation);
                if (translation.getName().length() > 0) {
                    siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NESTED_TRANSFORM, translation.getName(), translation);
                }
            }
            pivot = aseGeom.getPivot();
            this.applyPivotTranslation(aseGeom, pivotOffset, translation, nodeFactory);
            nodeFactory.addNodeToGroup(translation, parentGroup);
        } else {
            group = parentGroup;
            pivot = pivotOffset;
        }
        this.addGeometry(group, file, aseGeom, pivot, appFactory, baseURL, geomFactory, nodeFactory, siHandler);
    }

    private void getTransformGroupTree(AseFile aseFile, Tuple3f orientationAngle, AppearanceFactory appFactory, URL baseURL, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, SpecialItemsHandler siHandler, NamedObject modelRootGroup) {
        if (TGT_GROUPS_ONLY && TGT_NO_GROUPS) {
            throw new IllegalArgumentException("Can't use both AseFile.TGT_GROUPS_ONLY and AseFile.TGT_NOGROUPS together.  Perhaps you want the AseFile.getModel() method");
        }
        if (convertZup2Yup) {
            orientationAngle.addX(1.5707964f);
        }
        Matrix4f transform = MatrixUtils.eulerToMatrix4f(orientationAngle);
        if (scale != 1.0f) {
            Matrix4f scaleMat = new Matrix4f();
            scaleMat.setIdentity();
            scaleMat.m00(scale);
            scaleMat.m11(scale);
            scaleMat.m22(scale);
            transform.mul(scaleMat);
        }
        NamedObject treeRoot = nodeFactory.createTransformGroup("MasterRoot", transform, BoundsType.SPHERE);
        siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NESTED_TRANSFORM, treeRoot.getName(), treeRoot);
        siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.MAIN_GROUP, treeRoot.getName(), treeRoot);
        Collection<AseNode> c = aseFile.objects.values();
        for (AseGeom aseGeom : c) {
            this.createTransformGroupTree(treeRoot, aseFile, aseGeom, new Tuple3f(0.0f, 0.0f, 0.0f), appFactory, baseURL, geomFactory, nodeFactory, siHandler);
        }
        nodeFactory.addNodeToGroup(treeRoot, modelRootGroup);
    }

    public static void getTransformGroupTree(AseFile aseFile, AppearanceFactory appFactory, URL baseURL, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, SpecialItemsHandler siHandler, NamedObject modelRootGroup) {
        AseConverter converter = new AseConverter();
        converter.getTransformGroupTree(aseFile, new Tuple3f(0.0f, 0.0f, 0.0f), appFactory, baseURL, geomFactory, convertZup2Yup, scale, nodeFactory, siHandler, modelRootGroup);
    }
}

