/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.GroupType;
import org.jagatoo.loaders.models._util.LoaderUtils;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.bsp.BSPConverter;
import org.jagatoo.loaders.models.bsp.BSPEntitiesParser;
import org.jagatoo.loaders.models.bsp.BSPFile;
import org.jagatoo.loaders.models.bsp.BSPScenePrototype;
import org.jagatoo.loaders.models.bsp.BSPVersionDataLoader;
import org.jagatoo.loaders.models.bsp.BSPVersionDataLoader30;
import org.jagatoo.loaders.models.bsp.WADFile;
import org.jagatoo.loaders.models.bsp.lumps.BSP30Model;
import org.jagatoo.loaders.models.bsp.lumps.BSP46Model;
import org.jagatoo.loaders.models.bsp.lumps.BSPBrush;
import org.jagatoo.loaders.models.bsp.lumps.BSPBrushSide;
import org.jagatoo.loaders.models.bsp.lumps.BSPDirectory;
import org.jagatoo.loaders.models.bsp.lumps.BSPDirectory30;
import org.jagatoo.loaders.models.bsp.lumps.BSPDirectory46;
import org.jagatoo.loaders.models.bsp.lumps.BSPEdge;
import org.jagatoo.loaders.models.bsp.lumps.BSPFace;
import org.jagatoo.loaders.models.bsp.lumps.BSPLeaf;
import org.jagatoo.loaders.models.bsp.lumps.BSPModel;
import org.jagatoo.loaders.models.bsp.lumps.BSPNode;
import org.jagatoo.loaders.models.bsp.lumps.BSPPlane;
import org.jagatoo.loaders.models.bsp.lumps.BSPTexInfo;
import org.jagatoo.loaders.models.bsp.lumps.BSPVertex;
import org.jagatoo.loaders.models.bsp.lumps.BSPVisData;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSPPrototypeLoader {
    public static boolean loadNormals = true;
    protected static final Boolean DEBUG = null;

    protected static BSPEntitiesParser.BSPEntity[] readEntities(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kEntities < 0) {
            return null;
        }
        file.seek(bspDir.kEntities);
        int num = file.lumps[bspDir.kEntities].length;
        byte[] bytes = file.readFully(num);
        BSPEntitiesParser.BSPEntity[] entities = BSPEntitiesParser.parseEntites(bytes);
        return entities;
    }

    /*
     * Loose catch block
     */
    private static final boolean urlExists(URL url) {
        boolean bl;
        InputStream in;
        block12: {
            in = null;
            in = url.openStream();
            boolean bl2 = bl = in != null;
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable t) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static final boolean addStandardWAD(URL baseURL, String filenameBase, ArrayList<WADFile> wadFiles) throws MalformedURLException {
        String filename = filenameBase.concat(".wad");
        URL url = new URL(baseURL, filename);
        if (BSPPrototypeLoader.urlExists(url)) {
            int i = 0;
            while (i < wadFiles.size()) {
                if (wadFiles.get(i).getWADFilename().equals(filename)) {
                    return false;
                }
                ++i;
            }
            try {
                WADFile wadFile = new WADFile(url);
                wadFiles.add(wadFile);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static WADFile[] readWADFiles(BSPFile file, BSPEntitiesParser.BSPEntity[] entities) throws IOException {
        if (entities == null) {
            throw new Error("entities must be read before WADFiles can be read.");
        }
        if (file.getBaseURL() == null) {
            return new WADFile[0];
        }
        ArrayList<WADFile> wadFiles = new ArrayList<WADFile>();
        int i = 0;
        while (i < entities.length) {
            BSPEntitiesParser.BSPEntity entity = entities[i];
            if (entity.className.equals("worldspawn")) {
                BSPEntitiesParser.BSPEntity_worldspawn worldSpawn = (BSPEntitiesParser.BSPEntity_worldspawn)entity;
                if (worldSpawn.wads != null) {
                    int j = 0;
                    while (j < worldSpawn.wads.length) {
                        URL url = new URL(file.getBaseURL(), worldSpawn.wads[j]);
                        try {
                            WADFile wadFile = new WADFile(url);
                            wadFiles.add(wadFile);
                        }
                        catch (IOException e) {
                            System.err.println("WAD file not found \"" + url + "\".");
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        BSPPrototypeLoader.addStandardWAD(file.getBaseURL(), file.getName(), wadFiles);
        return wadFiles.toArray(new WADFile[wadFiles.size()]);
    }

    private static void setupTexture(AbstractTexture texture, String textureName, AppearanceFactory appFactory) {
        if (appFactory.isFallbackTexture(texture)) {
            JAGTLog.printlnEx("texture not found: ", textureName, " (WAD / .tga / .jpg)");
            System.err.println("missing texture: " + textureName);
        }
    }

    private static AbstractTexture[] loadTexture(BSPFile file, String textureName, WADFile[] wadFiles, BSPEntitiesParser.BSPEntity[] entities, AppearanceFactory appFactory) {
        URL baseURL;
        if (wadFiles != null && wadFiles.length > 0) {
            int i = 0;
            while (i < wadFiles.length) {
                WADFile wadFile = wadFiles[i];
                if (wadFile.containsResource(textureName)) {
                    try {
                        AbstractTexture[] textures = file.getVersion() == 30 && textureName.startsWith("sky") ? wadFile.readSkyTextures(textureName, appFactory, file.getBaseURL(), entities) : wadFile.readTexture(textureName, appFactory);
                        if (textures != null) {
                            BSPPrototypeLoader.setupTexture(textures[0], textureName, appFactory);
                            return textures;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if ((baseURL = file.getBaseURL()) == null) {
            AbstractTexture texture = appFactory.loadOrGetTexture(String.valueOf(textureName) + ".tga", false, true, true, true, false);
            if (texture == null) {
                texture = appFactory.loadOrGetTexture(String.valueOf(textureName) + ".jpg", false, true, true, true, true);
            }
            BSPPrototypeLoader.setupTexture(texture, textureName, appFactory);
            return new AbstractTexture[]{texture};
        }
        String texNameForURL = textureName;
        if (texNameForURL.startsWith("{")) {
            texNameForURL = texNameForURL.substring(1);
        }
        AbstractTexture texture = null;
        try {
            texture = appFactory.loadTexture(new URL(baseURL, String.valueOf(texNameForURL) + ".tga"), false, true, true, true, false);
            if (texture == null) {
                texture = appFactory.loadTexture(new URL(baseURL, String.valueOf(texNameForURL) + ".jpg"), false, true, true, true, true);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            texture = appFactory.getFallbackTexture();
        }
        BSPPrototypeLoader.setupTexture(texture, textureName, appFactory);
        return new AbstractTexture[]{texture};
    }

    protected static AbstractTexture[][] readTextures(BSPFile file, BSPDirectory bspDir, WADFile[] wadFiles, BSPEntitiesParser.BSPEntity[] entities, AppearanceFactory appFactory) throws IOException {
        AbstractTexture[][] textures;
        block10: {
            int textureCount;
            block9: {
                if (bspDir.kTextures < 0) {
                    return null;
                }
                file.seek(bspDir.kTextures);
                textureCount = 0;
                textures = null;
                if (file.getVersion() == 30) {
                    textureCount = file.readInt();
                    textures = new AbstractTexture[textureCount][];
                } else if (file.getVersion() == 46) {
                    textureCount = file.lumps[bspDir.kTextures].length / 72;
                    textures = new AbstractTexture[textureCount][1];
                }
                if (file.getVersion() != 30) break block9;
                int i = 0;
                while (i < textureCount) {
                    file.seek(bspDir.kTextures);
                    file.skipBytes(4 * i + 4);
                    int ofs = file.readInt();
                    file.skipBytes(ofs - (4 * i + 8));
                    byte[] texNameBytes = file.readFully(16);
                    String textureName = null;
                    int b = 0;
                    while (b < texNameBytes.length) {
                        if (texNameBytes[b] == 0) {
                            textureName = new String(texNameBytes, 0, b);
                            break;
                        }
                        ++b;
                    }
                    if (textureName == null) {
                        textureName = new String(texNameBytes);
                    }
                    file.readInt();
                    file.readInt();
                    file.readInt();
                    file.readInt();
                    file.readInt();
                    file.readInt();
                    textures[i] = BSPPrototypeLoader.loadTexture(file, textureName, wadFiles, entities, appFactory);
                    ++i;
                }
                break block10;
            }
            if (file.getVersion() != 46) break block10;
            byte[] ca = new byte[64];
            int i = 0;
            while (i < textureCount) {
                file.readFully(ca);
                file.readInt();
                file.readInt();
                String textureName = new String(ca);
                textureName = textureName.substring(0, textureName.indexOf(0));
                textures[i] = BSPPrototypeLoader.loadTexture(file, textureName, wadFiles, entities, appFactory);
                ++i;
            }
        }
        return textures;
    }

    private static void changeGamma(AbstractTextureImage img, float factor) {
        ByteBuffer imgData = img.getDataBuffer();
        int pixelSize = img.getPixelSize();
        byte[] gtable = new byte[256];
        int i = 0;
        while (i < 256) {
            gtable[i] = (byte)Math.floor(255.0 * Math.pow((double)i / 255.0, 1.0 / (double)factor) + 0.5);
            ++i;
        }
        int size = img.getWidth() * img.getHeight();
        int i2 = 0;
        while (i2 < size) {
            int tmp = imgData.get(i2 * pixelSize + 0) & 0xFF;
            imgData.put(i2 * pixelSize + 0, gtable[tmp]);
            tmp = imgData.get(i2 * pixelSize + 1) & 0xFF;
            imgData.put(i2 * pixelSize + 1, gtable[tmp]);
            tmp = imgData.get(i2 * pixelSize + 2) & 0xFF;
            imgData.put(i2 * pixelSize + 2, gtable[tmp]);
            ++i2;
        }
    }

    protected static AbstractTexture[] readLightmaps(BSPFile file, BSPDirectory bspDir, AppearanceFactory appFactory) throws IOException {
        if (bspDir.kLightmaps < 0) {
            return null;
        }
        int w = 128;
        int h = 128;
        file.seek(bspDir.kLightmaps);
        int sizePerImage = w * h * 3;
        int num = file.lumps[bspDir.kLightmaps].length / sizePerImage;
        AbstractTexture[] lightMaps = new AbstractTexture[num];
        byte[] buffer = new byte[1024];
        int i = 0;
        while (i < num) {
            AbstractTextureImage texImg0 = appFactory.createTextureImage(TextureImageFormat.RGB, w, h);
            ByteBuffer bb = texImg0.getDataBuffer();
            bb.position(0);
            bb.limit(bb.capacity());
            int j = 0;
            while (j < sizePerImage) {
                int rest = sizePerImage - j;
                int length = rest >= buffer.length ? buffer.length : rest;
                file.readFully(buffer, 0, length);
                bb.put(buffer, 0, length);
                j += buffer.length;
            }
            bb.flip();
            int pos = bb.position();
            int limit = bb.limit();
            BSPPrototypeLoader.changeGamma(texImg0, 1.2f);
            bb.position(pos);
            bb.limit(limit);
            lightMaps[i] = appFactory.createTexture(texImg0, true);
            ++i;
        }
        return lightMaps;
    }

    protected static byte[] readLightmapData(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kLightmaps < 0) {
            return null;
        }
        file.seek(bspDir.kLightmaps);
        return file.readFully(file.lumps[bspDir.kLightmaps].length);
    }

    protected static BSPTexInfo[] readTexInfos(BSPFile file, BSPDirectory bspDir) throws IOException {
        int kTexInfo = bspDir.kLeafFaces;
        if (kTexInfo < 0) {
            return null;
        }
        file.seek(kTexInfo);
        int num = file.lumps[kTexInfo].length / 40;
        BSPTexInfo[] texInfos = new BSPTexInfo[num];
        int i = 0;
        while (i < num) {
            BSPTexInfo texInfo;
            texInfos[i] = texInfo = new BSPTexInfo();
            texInfo.s[0] = file.readFloat();
            texInfo.s[1] = file.readFloat();
            texInfo.s[2] = file.readFloat();
            texInfo.s[3] = file.readFloat();
            texInfo.t[0] = file.readFloat();
            texInfo.t[1] = file.readFloat();
            texInfo.t[2] = file.readFloat();
            texInfo.t[3] = file.readFloat();
            texInfo.textureID = file.readInt();
            texInfo.flags = file.readInt();
            ++i;
        }
        return texInfos;
    }

    protected static BSPVertex[] readVertices(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kVertices < 0) {
            return null;
        }
        file.seek(bspDir.kVertices);
        int num = 0;
        if (bspDir.getVersion() == 30) {
            num = file.lumps[bspDir.kVertices].length / 12;
        } else if (bspDir.getVersion() == 46) {
            num = file.lumps[bspDir.kVertices].length / 44;
        }
        BSPVertex[] vertices = new BSPVertex[num];
        int i = 0;
        while (i < num) {
            BSPVertex vertex;
            vertices[i] = vertex = new BSPVertex();
            vertex.position.setX(file.readFloat());
            vertex.position.setY(file.readFloat());
            vertex.position.setZ(file.readFloat());
            if (bspDir.getVersion() == 46) {
                int a;
                int b;
                int g;
                vertex.texCoord.setS(file.readFloat());
                vertex.texCoord.setT(file.readFloat());
                vertex.lightTexCoord.setS(file.readFloat());
                vertex.lightTexCoord.setT(file.readFloat());
                vertex.normal.setX(file.readFloat());
                vertex.normal.setY(file.readFloat());
                vertex.normal.setZ(file.readFloat());
                int r = file.readByte();
                if (r < 0) {
                    r = -r + 127;
                }
                if ((g = file.readByte()) < 0) {
                    g = -g + 127;
                }
                if ((b = file.readByte()) < 0) {
                    b = -b + 127;
                }
                if ((a = file.readByte()) < 0) {
                    a = -a + 127;
                }
                vertex.color.setRed((float)r / 255.0f);
                vertex.color.setGreen((float)g / 255.0f);
                vertex.color.setBlue((float)b / 255.0f);
                vertex.color.setAlpha((float)a / 255.0f);
            }
            ++i;
        }
        return vertices;
    }

    protected static int[] readMeshVertices(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kMeshVerts < 0) {
            return null;
        }
        file.seek(bspDir.kMeshVerts);
        int num = file.lumps[bspDir.kMeshVerts].length / 4;
        int[] meshVertices = new int[num];
        int i = 0;
        while (i < num) {
            meshVertices[i] = file.readInt();
            ++i;
        }
        return meshVertices;
    }

    protected static BSPEdge[] readEdges(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kBrushSides < 0) {
            return null;
        }
        file.seek(bspDir.kBrushSides);
        int num = file.lumps[bspDir.kBrushSides].length / 4;
        BSPEdge[] edges = new BSPEdge[num];
        int i = 0;
        while (i < num) {
            BSPEdge edge;
            edges[i] = edge = new BSPEdge();
            edge.vindices[0] = file.readUnsignedShort();
            edge.vindices[1] = file.readUnsignedShort();
            ++i;
        }
        return edges;
    }

    protected static int[] readSurfEdges(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kSurfEdges < 0) {
            return null;
        }
        file.seek(bspDir.kSurfEdges);
        int num = file.lumps[bspDir.kSurfEdges].length / 4;
        int[] surfEdges = new int[num];
        int i = 0;
        while (i < num) {
            surfEdges[i] = file.readInt();
            ++i;
        }
        return surfEdges;
    }

    protected static BSPFace[] readFaces(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kFaces < 0) {
            return null;
        }
        file.seek(bspDir.kFaces);
        if (file.getVersion() == 30) {
            int num = file.lumps[bspDir.kFaces].length / 20;
            BSPFace[] faces = new BSPFace[num];
            int i = 0;
            while (i < num) {
                BSPFace face;
                faces[i] = face = new BSPFace();
                face.effect = -1;
                file.readUnsignedShort();
                file.readUnsignedShort();
                face.vertexIndex = file.readInt();
                face.numOfVerts = file.readUnsignedShort();
                face.textureID = file.readUnsignedShort();
                file.readFully(4);
                face.lightmapID = file.readInt();
                ++i;
            }
            return faces;
        }
        if (file.getVersion() == 46) {
            int num = file.lumps[bspDir.kFaces].length / 104;
            BSPFace[] faces = new BSPFace[num];
            int i = 0;
            while (i < num) {
                BSPFace face;
                faces[i] = face = new BSPFace();
                face.textureID = file.readInt();
                face.effect = file.readInt();
                face.type = file.readInt();
                face.vertexIndex = file.readInt();
                face.numOfVerts = file.readInt();
                face.meshVertIndex = file.readInt();
                face.numMeshVerts = file.readInt();
                face.lightmapID = file.readInt();
                face.lMapCorner[0] = file.readInt();
                face.lMapCorner[1] = file.readInt();
                face.lMapSize[0] = file.readInt();
                face.lMapSize[1] = file.readInt();
                face.lMapPos[0] = file.readFloat();
                face.lMapPos[1] = file.readFloat();
                face.lMapPos[2] = file.readFloat();
                face.lMapBitsets[0][0] = file.readFloat();
                face.lMapBitsets[0][1] = file.readFloat();
                face.lMapBitsets[0][2] = file.readFloat();
                face.lMapBitsets[1][0] = file.readFloat();
                face.lMapBitsets[1][1] = file.readFloat();
                face.lMapBitsets[1][2] = file.readFloat();
                face.vNormal[0] = file.readFloat();
                face.vNormal[1] = file.readFloat();
                face.vNormal[2] = file.readFloat();
                face.size[0] = file.readInt();
                face.size[1] = file.readInt();
                ++i;
            }
            return faces;
        }
        return null;
    }

    protected static BSPVisData readVisData(BSPFile file, BSPDirectory bspDir, int leafCount) throws IOException {
        if (bspDir.kVisData < 0) {
            return null;
        }
        file.seek(bspDir.kVisData);
        BSPVisData visData = null;
        if (file.getVersion() == 30) {
            visData = new BSPVisData();
            visData.numOfClusters = leafCount;
            visData.bytesPerCluster = (visData.numOfClusters - 1) / 8;
            byte[] compressed = file.readFully(file.lumps[bspDir.kVisData].length);
            visData.pBitsets = BSPVersionDataLoader30.decompressVis(visData.numOfClusters, compressed);
        } else if (file.getVersion() == 46) {
            visData = new BSPVisData();
            visData.numOfClusters = file.readInt();
            visData.bytesPerCluster = file.readInt();
            visData.pBitsets = file.readFully(visData.bytesPerCluster * visData.numOfClusters);
        }
        return visData;
    }

    protected static BSPPlane[] readPlanes(BSPFile file, BSPDirectory bspDir, float worldScale) throws IOException {
        if (bspDir.kPlanes < 0) {
            return null;
        }
        int entryLength = 0;
        if (bspDir.getVersion() == 30) {
            entryLength = 5;
        } else if (bspDir.getVersion() == 46) {
            entryLength = 4;
        }
        file.seek(bspDir.kPlanes);
        int num = file.lumps[bspDir.kPlanes].length / (entryLength * 4);
        BSPPlane[] planes = new BSPPlane[num];
        int i = 0;
        while (i < num) {
            BSPPlane plane;
            planes[i] = plane = new BSPPlane();
            plane.normal.setX(file.readFloat());
            plane.normal.setY(file.readFloat());
            plane.normal.setZ(file.readFloat());
            plane.d = file.readFloat() * worldScale;
            file.skipBytes((entryLength - 4) * 4);
            ++i;
        }
        return planes;
    }

    protected static BSPNode[] readNodes(BSPFile file, BSPDirectory bspDir) throws IOException {
        BSPNode[] nodes;
        block7: {
            int num;
            block6: {
                if (bspDir.kNodes < 0) {
                    return null;
                }
                file.seek(bspDir.kNodes);
                int length = 0;
                if (file.getVersion() == 30) {
                    length = 24;
                } else if (file.getVersion() == 46) {
                    length = 36;
                }
                num = file.lumps[bspDir.kNodes].length / length;
                nodes = new BSPNode[num];
                if (file.getVersion() != 30) break block6;
                int i = 0;
                while (i < num) {
                    BSPNode node2;
                    nodes[i] = node2 = new BSPNode();
                    node2.plane = file.readInt();
                    short child0 = file.readShort();
                    short child1 = file.readShort();
                    node2.front = child0 > 0 ? (int)child0 : -(child0 + 1);
                    node2.back = child1 > 0 ? (int)child1 : -(child1 + 1);
                    node2.mins[0] = file.readShort();
                    node2.mins[1] = file.readShort();
                    node2.mins[2] = file.readShort();
                    node2.maxs[0] = file.readShort();
                    node2.maxs[1] = file.readShort();
                    node2.maxs[2] = file.readShort();
                    file.readUnsignedShort();
                    file.readUnsignedShort();
                    ++i;
                }
                break block7;
            }
            if (file.getVersion() != 46) break block7;
            int i = 0;
            while (i < num) {
                BSPNode node3;
                nodes[i] = node3 = new BSPNode();
                node3.plane = file.readInt();
                node3.front = file.readInt();
                node3.back = file.readInt();
                node3.mins[0] = file.readInt();
                node3.mins[1] = file.readInt();
                node3.mins[2] = file.readInt();
                node3.maxs[0] = file.readInt();
                node3.maxs[1] = file.readInt();
                node3.maxs[2] = file.readInt();
                ++i;
            }
        }
        return nodes;
    }

    protected static BSPLeaf[] readLeafs(BSPFile file, BSPDirectory bspDir) throws IOException {
        BSPLeaf[] leafs;
        block7: {
            int num;
            block6: {
                if (bspDir.kLeafs < 0) {
                    return null;
                }
                int entryLength = 0;
                if (file.getVersion() == 30) {
                    entryLength = 26;
                } else if (file.getVersion() == 46) {
                    entryLength = 48;
                }
                file.seek(bspDir.kLeafs);
                num = file.lumps[bspDir.kLeafs].length / entryLength;
                leafs = new BSPLeaf[num];
                if (file.getVersion() != 30) break block6;
                int i = 0;
                while (i < num) {
                    BSPLeaf leaf;
                    leafs[i] = leaf = new BSPLeaf();
                    file.readInt();
                    file.readInt();
                    leaf.mins[0] = file.readShort();
                    leaf.mins[1] = file.readShort();
                    leaf.mins[2] = file.readShort();
                    leaf.maxs[0] = file.readShort();
                    leaf.maxs[1] = file.readShort();
                    leaf.maxs[2] = file.readShort();
                    file.readUnsignedShort();
                    file.readUnsignedShort();
                    file.readFully(4);
                    ++i;
                }
                break block7;
            }
            if (file.getVersion() != 46) break block7;
            int i = 0;
            while (i < num) {
                BSPLeaf leaf;
                leafs[i] = leaf = new BSPLeaf();
                leaf.cluster = file.readInt();
                leaf.area = file.readInt();
                leaf.mins[0] = file.readInt();
                leaf.mins[1] = file.readInt();
                leaf.mins[2] = file.readInt();
                leaf.maxs[0] = file.readInt();
                leaf.maxs[1] = file.readInt();
                leaf.maxs[2] = file.readInt();
                leaf.leafFace = file.readInt();
                leaf.numOfLeafFaces = file.readInt();
                leaf.leafBrush = file.readInt();
                leaf.numOfLeafBrushes = file.readInt();
                ++i;
            }
        }
        return leafs;
    }

    protected static int[] readLeafFaces(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kLeafFaces < 0) {
            return null;
        }
        file.seek(bspDir.kLeafFaces);
        int num = file.lumps[bspDir.kLeafFaces].length / 4;
        int[] leafFaces = new int[num];
        int i = 0;
        while (i < num) {
            leafFaces[i] = file.readInt();
            ++i;
        }
        return leafFaces;
    }

    protected static BSPBrush[] readBrushes(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kBrushes < 0) {
            return null;
        }
        file.seek(bspDir.kBrushes);
        int num = file.lumps[bspDir.kBrushes].length / 12;
        BSPBrush[] brushes = new BSPBrush[num];
        int i = 0;
        while (i < num) {
            BSPBrush brush;
            brushes[i] = brush = new BSPBrush();
            brush.brushSide = file.readInt();
            brush.numBrushSides = file.readInt();
            brush.textureID = file.readInt();
            ++i;
        }
        return brushes;
    }

    protected static BSPBrushSide[] readBrushSides(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kBrushSides < 0) {
            return null;
        }
        file.seek(bspDir.kBrushSides);
        int num = file.lumps[bspDir.kBrushSides].length / 12;
        BSPBrushSide[] brushSides = new BSPBrushSide[num];
        int i = 0;
        while (i < num) {
            BSPBrushSide brushSide;
            brushSides[i] = brushSide = new BSPBrushSide();
            brushSide.plane = file.readInt();
            brushSide.textureID = file.readInt();
            ++i;
        }
        return brushSides;
    }

    protected static BSPModel[] readModels(BSPFile file, BSPDirectory bspDir) throws IOException {
        if (bspDir.kModels < 0) {
            return null;
        }
        file.seek(bspDir.kModels);
        if (file.getVersion() == 30) {
            int num = file.lumps[bspDir.kModels].length / 64;
            BSPModel[] models = new BSP30Model[num];
            int i = 0;
            while (i < num) {
                BSP30Model model = new BSP30Model();
                models[i] = model;
                model.min[0] = file.readFloat();
                model.min[1] = file.readFloat();
                model.min[2] = file.readFloat();
                model.max[0] = file.readFloat();
                model.max[1] = file.readFloat();
                model.max[2] = file.readFloat();
                model.origin[0] = file.readFloat();
                model.origin[1] = file.readFloat();
                model.origin[2] = file.readFloat();
                model.headNode[0] = file.readInt();
                model.headNode[1] = file.readInt();
                model.headNode[2] = file.readInt();
                model.headNode[3] = file.readInt();
                model.visLeaves = file.readInt();
                model.faceIndex = file.readInt();
                model.numOfFaces = file.readInt();
                ++i;
            }
            return models;
        }
        if (file.getVersion() == 46) {
            int num = file.lumps[bspDir.kModels].length / 40;
            BSPModel[] models = new BSP46Model[num];
            int i = 0;
            while (i < num) {
                BSP46Model model = new BSP46Model();
                models[i] = model;
                model.min[0] = file.readFloat();
                model.min[1] = file.readFloat();
                model.min[2] = file.readFloat();
                model.max[0] = file.readFloat();
                model.max[1] = file.readFloat();
                model.max[2] = file.readFloat();
                model.faceIndex = file.readInt();
                model.numOfFaces = file.readInt();
                model.brushIndex = file.readInt();
                model.numOfBrushes = file.readInt();
                ++i;
            }
            return models;
        }
        return null;
    }

    private static BSPScenePrototype load(BSPFile bspFile, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale, AppearanceFactory appFactory, NodeFactory nodeFactory, NamedObject sceneGroup, GroupType mainGroupType, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        BSPDirectory bspDir;
        switch (bspFile.getVersion()) {
            case 30: {
                bspDir = new BSPDirectory30();
                break;
            }
            case 46: {
                bspDir = new BSPDirectory46();
                break;
            }
            default: {
                throw new Error("Cannot find a matching implementation of BSPDirectory for format version " + bspFile.getVersion() + ".");
            }
        }
        BSPVersionDataLoader loader = bspDir.getDataLoader();
        BSPScenePrototype prototype = loader.loadPrototypeData(bspFile, bspDir, worldScale, appFactory);
        loader.convertFacesToGeometries(prototype, appFactory, geomFactory, convertZup2Yup, worldScale);
        BSPConverter.convert(prototype, appFactory, nodeFactory, sceneGroup, mainGroupType, worldScale, bspFile.getBaseURL(), siHandler);
        return prototype;
    }

    public static BSPScenePrototype load(InputStream in, String filename, URL baseURL, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale, AppearanceFactory appFactory, NodeFactory nodeFactory, NamedObject sceneGroup, GroupType mainGroupType, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if (filename.endsWith(".bsp")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        BSPFile bspFile = new BSPFile(in, filename, baseURL);
        return BSPPrototypeLoader.load(bspFile, geomFactory, convertZup2Yup, worldScale, appFactory, nodeFactory, sceneGroup, mainGroupType, siHandler);
    }

    public static BSPScenePrototype load(URL url, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale, AppearanceFactory appFactory, NodeFactory nodeFactory, NamedObject sceneGroup, GroupType mainGroupType, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        return BSPPrototypeLoader.load(url.openStream(), LoaderUtils.extractFilenameWithoutExt(url), LoaderUtils.extractBaseURL(url), geomFactory, convertZup2Yup, worldScale, appFactory, nodeFactory, sceneGroup, mainGroupType, siHandler);
    }
}

