/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp.util;

import org.jagatoo.loaders.models.bsp.lumps.BSPVertex;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;

public class PatchSurface {
    private static final int MAXMESHLEVEL = 2;
    private static final float MINDIST = 0.25f;
    private int mCount;
    public BSPVertex[] mPoints;
    public int[] mIndices;
    private int sizex = 0;
    private int sizey = 0;
    private static Point3f a = new Point3f();
    private static Point3f b = new Point3f();
    private static Point3f v0 = new Point3f();
    private static Point3f v1 = new Point3f();
    private static Point3f v2 = new Point3f();

    private int getLevelWidth(int lvl) {
        return (1 << lvl + 1) + 1;
    }

    private boolean findSize(int controlx, int controly, BSPVertex[] cp) {
        int u;
        boolean found = false;
        BSPVertex a = null;
        BSPVertex b = null;
        int ai = 0;
        int bi = 0;
        int v = 0;
        while (v < controly) {
            u = 0;
            while (u < controlx) {
                ai = v * controlx + u;
                bi = v * controlx + u + 2;
                a = cp[ai];
                b = cp[bi];
                if (!((TupleNf)a.position).equals(b.position)) {
                    found = true;
                    break;
                }
                u += 2;
            }
            if (found) break;
            ++v;
        }
        if (!found) {
            System.out.println("bad mesh control points\n");
            return false;
        }
        int levelx = this.findLevel(cp[ai].position, cp[ai + 1].position, cp[bi].position);
        this.sizex = (this.getLevelWidth(levelx) - 1) * ((controlx - 1) / 2) + 1;
        u = 0;
        while (u < controlx) {
            int v2 = 0;
            while (v2 < controly) {
                ai = v2 * controlx + u;
                bi = (v2 + 2) * controlx + u;
                a = cp[ai];
                b = cp[bi];
                if (!((TupleNf)a.position).equals(b.position)) {
                    found = true;
                    break;
                }
                v2 += 2;
            }
            if (found) break;
            ++u;
        }
        if (!found) {
            return false;
        }
        int levely = this.findLevel(cp[ai].position, cp[ai + 1].position, cp[bi].position);
        this.sizey = (this.getLevelWidth(levely) - 1) * ((controly - 1) / 2) + 1;
        return true;
    }

    private int findLevel(Point3f cv0, Point3f cv1, Point3f cv2) {
        a.set(0.0f, 0.0f, 0.0f);
        b.set(0.0f, 0.0f, 0.0f);
        v0.set((TupleNf)cv0);
        v1.set((TupleNf)cv1);
        v2.set((TupleNf)cv2);
        int level = 0;
        while (level < 1) {
            a.interpolate(v0, v1, 0.5f);
            b.interpolate(v1, v2, 0.5f);
            v2.interpolate(a, b, 0.5f);
            if (v2.distanceSquared(v1) < 0.25f) break;
            v1.set((TupleNf)a);
            ++level;
        }
        return level;
    }

    private void fillPatch(int controlx, int controly, BSPVertex[] p) {
        int stepx = (this.sizex - 1) / (controlx - 1);
        int u = 0;
        while (u < this.sizex) {
            this.fillCurve(controly, this.sizey, this.sizex, p, u);
            u += stepx;
        }
        int v = 0;
        while (v < this.sizey) {
            this.fillCurve(controlx, this.sizex, 1, p, v * this.sizex);
            ++v;
        }
    }

    private void fillCurve(int numcp, int size, int stride, BSPVertex[] p, int start) {
        BSPVertex a = new BSPVertex();
        BSPVertex b = new BSPVertex();
        int step = (size - 1) / (numcp - 1);
        while (step > 0) {
            int halfstep = step / 2;
            int i = 0;
            while (i < size - 1) {
                int mid = (i + step) * stride;
                a.avg(p[start + i * stride], p[start + mid]);
                b.avg(p[start + mid], p[start + (i + step * 2) * stride]);
                p[mid + start].avg(a, b);
                if (halfstep > 0) {
                    p[start + (i + halfstep) * stride] = a.copy();
                    p[start + (i + 3 * halfstep) * stride] = b.copy();
                }
                i += step * 2;
            }
            step /= 2;
        }
    }

    public PatchSurface(BSPVertex[] cp, int controlx, int controly) {
        this.findSize(controlx, controly, cp);
        int size = this.sizex * this.sizey;
        this.mPoints = new BSPVertex[size];
        int i = 0;
        while (i < size) {
            this.mPoints[i] = new BSPVertex();
            ++i;
        }
        int stepx = (this.sizex - 1) / (controlx - 1);
        int stepy = (this.sizey - 1) / (controly - 1);
        int cv = 0;
        int y = 0;
        while (y < this.sizey) {
            int x = 0;
            while (x < this.sizex) {
                int p = y * this.sizex + x;
                this.mPoints[p] = cp[cv++].copy();
                x += stepx;
            }
            y += stepy;
        }
        this.fillPatch(controlx, controly, this.mPoints);
        this.mCount = (this.sizex - 1) * (this.sizey - 1) * 6;
        this.mIndices = new int[this.mCount];
        int ii = 0;
        int y2 = 0;
        while (y2 < this.sizey - 1) {
            int x = 0;
            while (x < this.sizex - 1) {
                this.mIndices[ii++] = y2 * this.sizex + x;
                this.mIndices[ii++] = (y2 + 1) * this.sizex + x;
                this.mIndices[ii++] = y2 * this.sizex + x + 1;
                this.mIndices[ii++] = y2 * this.sizex + x + 1;
                this.mIndices[ii++] = (y2 + 1) * this.sizex + x;
                this.mIndices[ii++] = (y2 + 1) * this.sizex + x + 1;
                ++x;
            }
            ++y2;
        }
    }
}

