/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

public class IndexBuffer {
    private final int[] intBuffer;
    private final int length;
    private int pos;

    public IndexBuffer(int length) {
        this.length = length;
        this.intBuffer = new int[length];
        this.pos = 0;
    }

    public void put(int n, int x) {
        this.intBuffer[n] = x;
        this.pos = n + 1;
    }

    public int get(int n) {
        return this.intBuffer[n];
    }

    public void put(int[] x) {
        System.arraycopy(x, 0, this.intBuffer, this.pos, x.length);
        this.pos += x.length;
    }

    public void put(int n, int[] x) {
        System.arraycopy(x, 0, this.intBuffer, n, x.length);
        this.pos = n + x.length;
    }

    public void putTri(int n, int a, int b, int c) {
        this.intBuffer[3 * n + 0] = a;
        this.intBuffer[3 * n + 1] = b;
        this.intBuffer[3 * n + 2] = c;
        this.pos = 3 * n + 3;
    }

    public void putQuad(int n, int a, int b, int c, int d) {
        this.intBuffer[4 * n + 0] = a;
        this.intBuffer[4 * n + 1] = b;
        this.intBuffer[4 * n + 2] = c;
        this.intBuffer[4 * n + 3] = d;
        this.pos = 4 * n + 4;
    }

    public final int size() {
        return this.length;
    }

    public final int[] getBuffer() {
        return this.intBuffer;
    }
}

