/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

import java.nio.FloatBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.vecmath2.Vector2f;

public class TexCoord2fBuffer {
    FloatBuffer floatBuffer;
    int length;

    public TexCoord2fBuffer(int length) {
        this.floatBuffer = BufferUtils.createFloatBuffer(length * 2);
        this.length = length;
    }

    public void put(int n, float x, float y) {
        this.floatBuffer.put(2 * n + 0, x);
        this.floatBuffer.put(2 * n + 1, y);
    }

    public void put(int n, Vector2f v) {
        this.floatBuffer.put(2 * n + 0, v.getX());
        this.floatBuffer.put(2 * n + 1, v.getY());
    }

    public void putX(int n, float x) {
        this.floatBuffer.put(2 * n + 0, x);
    }

    public void putY(int n, float y) {
        this.floatBuffer.put(2 * n + 1, y);
    }

    public Vector2f get(int n) {
        return new Vector2f(this.floatBuffer.get(2 * n + 0), this.floatBuffer.get(2 * n + 1));
    }

    public float getX(int n) {
        return this.floatBuffer.get(2 * n + 0);
    }

    public float getY(int n) {
        return this.floatBuffer.get(2 * n + 1);
    }

    public FloatBuffer getBuffer() {
        return this.floatBuffer;
    }
}

