/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

import java.nio.FloatBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.vecmath2.Vector3f;

public class Vector3fBuffer {
    public static final int STRIDE = 3;
    protected FloatBuffer floatBuffer;
    public int length;

    public Vector3fBuffer(FloatBuffer floatBuffer, int length) {
        this.floatBuffer = floatBuffer;
        this.length = length;
    }

    public Vector3fBuffer(int length) {
        this.length = length;
        this.floatBuffer = BufferUtils.createFloatBuffer(length * 3);
    }

    public void set(Vector3fBuffer v) {
        int n = 0;
        while (n < this.length * 3) {
            this.floatBuffer.put(n, v.floatBuffer.get(n));
            ++n;
        }
    }

    public void put(int n, float x, float y, float z) {
        this.floatBuffer.put(3 * n + 0, x);
        this.floatBuffer.put(3 * n + 1, y);
        this.floatBuffer.put(3 * n + 2, z);
    }

    public void put(int n, Vector3f v) {
        this.floatBuffer.put(3 * n + 0, v.getX());
        this.floatBuffer.put(3 * n + 1, v.getY());
        this.floatBuffer.put(3 * n + 2, v.getZ());
    }

    public void putX(int n, float x) {
        this.floatBuffer.put(3 * n + 0, x);
    }

    public void putY(int n, float y) {
        this.floatBuffer.put(3 * n + 1, y);
    }

    public void putZ(int n, float z) {
        this.floatBuffer.put(3 * n + 2, z);
    }

    public Vector3f get(int n) {
        return new Vector3f(this.floatBuffer.get(3 * n + 0), this.floatBuffer.get(3 * n + 1), this.floatBuffer.get(3 * n + 2));
    }

    public Vector3f get(int n, Vector3f v) {
        v.setX(this.floatBuffer.get(3 * n + 0));
        v.setY(this.floatBuffer.get(3 * n + 1));
        v.setZ(this.floatBuffer.get(3 * n + 2));
        return v;
    }

    public float getX(int n) {
        return this.floatBuffer.get(3 * n + 0);
    }

    public float getY(int n) {
        return this.floatBuffer.get(3 * n + 1);
    }

    public float getZ(int n) {
        return this.floatBuffer.get(3 * n + 2);
    }

    public void add(int n, Vector3f v) {
        this.floatBuffer.put(3 * n + 0, this.floatBuffer.get(3 * n + 0) + v.getX());
        this.floatBuffer.put(3 * n + 1, this.floatBuffer.get(3 * n + 1) + v.getY());
        this.floatBuffer.put(3 * n + 2, this.floatBuffer.get(3 * n + 2) + v.getZ());
    }

    public void sub(int n, Vector3f v) {
        this.floatBuffer.put(3 * n + 0, this.floatBuffer.get(3 * n + 0) - v.getX());
        this.floatBuffer.put(3 * n + 1, this.floatBuffer.get(3 * n + 1) - v.getY());
        this.floatBuffer.put(3 * n + 2, this.floatBuffer.get(3 * n + 2) - v.getZ());
    }

    public void scale(int n, float v) {
        this.floatBuffer.put(3 * n + 0, this.floatBuffer.get(3 * n + 0) * v);
        this.floatBuffer.put(3 * n + 1, this.floatBuffer.get(3 * n + 1) * v);
        this.floatBuffer.put(3 * n + 2, this.floatBuffer.get(3 * n + 2) * v);
    }

    public Vector3fBuffer slice(int offset, int length) {
        this.floatBuffer.position(3 * offset);
        FloatBuffer sliced = this.floatBuffer.slice();
        if (length > sliced.remaining() / 3) {
            throw new IllegalArgumentException("Insufficient elements for slice: " + length + " > " + sliced.remaining() / 3);
        }
        return new Vector3fBuffer(sliced, length);
    }

    public FloatBuffer getBuffer() {
        return this.floatBuffer;
    }

    public void clear() {
        int n = 0;
        while (n < this.length) {
            this.floatBuffer.put(n, 0.0f);
            ++n;
        }
    }

    public int size() {
        return this.length;
    }

    public void translate(float x, float y, float z) {
        int n = 0;
        while (n < this.length) {
            this.floatBuffer.put(3 * n + 0, x + this.floatBuffer.get(3 * n + 0));
            this.floatBuffer.put(3 * n + 1, y + this.floatBuffer.get(3 * n + 1));
            this.floatBuffer.put(3 * n + 2, z + this.floatBuffer.get(3 * n + 2));
            ++n;
        }
    }

    public void scale(float xs, float ys, float zs) {
        int n = 0;
        while (n < this.length) {
            this.floatBuffer.put(3 * n + 0, xs * this.floatBuffer.get(3 * n + 0));
            this.floatBuffer.put(3 * n + 1, ys * this.floatBuffer.get(3 * n + 1));
            this.floatBuffer.put(3 * n + 2, zs * this.floatBuffer.get(3 * n + 2));
            ++n;
        }
    }
}

