/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMorphAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.openmali.vecmath2.Colorf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreModel {
    protected String name;
    protected CalCoreSkeleton coreSkeleton;
    protected Map<String, CalCoreAnimation> mapCoreAnimation = new HashMap<String, CalCoreAnimation>();
    protected Map<String, CalCoreMorphAnimation> mapCoreMorphAnimation = new HashMap<String, CalCoreMorphAnimation>();
    protected Map<String, CalCoreMesh> mapCoreMesh = new HashMap<String, CalCoreMesh>();
    protected Map<String, CalCoreMaterial> mapCoreMaterial = new HashMap<String, CalCoreMaterial>();
    protected Vector<Map<String, CalCoreMaterial>> mapCoreMaterialThread = new Vector();
    protected Object userData;
    protected Properties properties;
    CalCoreMaterial defaultMaterial = new CalCoreMaterial();

    public CalCoreModel(String name) {
        this.defaultMaterial.setAmbientColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.defaultMaterial.setDiffuseColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.defaultMaterial.setSpecularColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.name = name;
        this.coreSkeleton = null;
        this.userData = null;
    }

    public CalCoreModel(String name, CalCoreSkeleton skeleton) {
        this.defaultMaterial.setAmbientColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.defaultMaterial.setDiffuseColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.defaultMaterial.setSpecularColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        this.name = name;
        this.coreSkeleton = skeleton;
        this.userData = null;
    }

    public void addCoreMesh(String tag, CalCoreMesh coreMesh) {
        this.mapCoreMesh.put(tag, coreMesh);
    }

    public Map<String, CalCoreMesh> getCoreMeshes() {
        return this.mapCoreMesh;
    }

    public Collection<String> getCoreMeshIds() {
        return this.mapCoreMesh.keySet();
    }

    public void addCoreAnimation(String tag, CalCoreAnimation coreAnimation) {
        this.mapCoreAnimation.put(tag, coreAnimation);
    }

    public void removeCoreAnimation(String tag) {
        this.mapCoreAnimation.remove(tag);
    }

    public Map<String, CalCoreAnimation> getCoreAnimations() {
        return this.mapCoreAnimation;
    }

    public Collection<String> getCoreAnimationIds() {
        return this.mapCoreAnimation.keySet();
    }

    public void addCoreMorphAnimation(String tag, CalCoreMorphAnimation coreAnimation) {
        this.mapCoreMorphAnimation.put(tag, coreAnimation);
    }

    public void removeCoreMorphAnimation(String tag) {
        this.mapCoreMorphAnimation.remove(tag);
    }

    public void addCoreMaterial(String tag, CalCoreMaterial coreMaterial) {
        this.mapCoreMaterial.put(tag, coreMaterial);
    }

    public Collection<String> getCoreMaterialIds() {
        return this.mapCoreMaterial.keySet();
    }

    public CalCoreAnimation getCoreAnimation(String coreAnimationId) {
        return this.mapCoreAnimation.get(coreAnimationId);
    }

    public int getCoreAnimationCount() {
        return this.mapCoreAnimation.size();
    }

    public CalCoreMorphAnimation getCoreMorphAnimation(String coreAnimationId) {
        return this.mapCoreMorphAnimation.get(coreAnimationId);
    }

    public Map<String, CalCoreMorphAnimation> getCoreMorphAnimations() {
        return this.mapCoreMorphAnimation;
    }

    public int getCoreMorphAnimationCount() {
        return this.mapCoreMorphAnimation.size();
    }

    public CalCoreMaterial getCoreMaterial(String coreMaterialId) {
        return this.mapCoreMaterial.get(coreMaterialId);
    }

    public Map<String, CalCoreMaterial> getCoreMaterials() {
        return this.mapCoreMaterial;
    }

    public int getCoreMaterialCount() {
        return this.mapCoreMaterial.size();
    }

    public int countMaterialThreadsNeeded() {
        int maxThreadId = 0;
        for (CalCoreMesh mesh : this.mapCoreMesh.values()) {
            for (CalCoreSubmesh submesh : mesh.vectorCoreSubmesh) {
                maxThreadId = Math.max(maxThreadId, submesh.coreMaterialThreadId);
            }
        }
        return 1 + maxThreadId;
    }

    public CalCoreMaterial getCoreMaterial(int coreMaterialThreadId, String coreMaterialSetId) {
        if (coreMaterialThreadId < 0 || coreMaterialThreadId >= this.mapCoreMaterialThread.size()) {
            return this.defaultMaterial;
        }
        Map<String, CalCoreMaterial> coreMaterialThread = this.mapCoreMaterialThread.elementAt(coreMaterialThreadId);
        if (coreMaterialThread == null) {
            return this.defaultMaterial;
        }
        CalCoreMaterial coreMaterial = coreMaterialThread.get(coreMaterialSetId);
        if (coreMaterial == null) {
            return this.defaultMaterial;
        }
        return coreMaterial;
    }

    public CalCoreMesh getCoreMesh(String coreMeshId) {
        return this.mapCoreMesh.get(coreMeshId);
    }

    public int getCoreMeshCount() {
        return this.mapCoreMesh.size();
    }

    public CalCoreSkeleton getCoreSkeleton() {
        return this.coreSkeleton;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setCoreMaterial(int coreMaterialThreadId, String coreMaterialSetId, String coreMaterialId) {
        CalCoreMaterial coreMaterial;
        Map<String, CalCoreMaterial> coreMaterialThread;
        if (coreMaterialThreadId >= this.mapCoreMaterialThread.size()) {
            this.mapCoreMaterialThread.setSize(coreMaterialThreadId + 1);
        }
        if ((coreMaterialThread = this.mapCoreMaterialThread.elementAt(coreMaterialThreadId)) == null) {
            coreMaterialThread = new HashMap<String, CalCoreMaterial>();
            this.mapCoreMaterialThread.set(coreMaterialThreadId, coreMaterialThread);
        }
        if ((coreMaterial = this.mapCoreMaterial.get(coreMaterialId)) == null) {
            throw new IllegalArgumentException();
        }
        coreMaterialThread.remove(coreMaterialSetId);
        coreMaterialThread.put(coreMaterialSetId, coreMaterial);
    }

    public int getNumCoreMaterialThreads() {
        return this.mapCoreMaterialThread.size();
    }

    public Vector<Map<String, CalCoreMaterial>> getCoreMaterialThreadMaps() {
        return this.mapCoreMaterialThread;
    }

    public void setCoreSkeleton(CalCoreSkeleton coreSkeleton) {
        this.coreSkeleton = coreSkeleton;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        return this.properties != null ? this.properties.getProperty(property) : null;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }
}

