/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.List;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSubmesh;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalMesh {
    protected CalModel model = null;
    protected CalCoreMesh coreMesh;
    protected List<CalSubmesh> submeshes = new Vector<CalSubmesh>();

    public CalMesh(CalCoreMesh coreMesh) {
        if (coreMesh == null) {
            throw new IllegalArgumentException();
        }
        this.coreMesh = coreMesh;
        for (CalCoreSubmesh coreSubmesh : coreMesh.getVectorCoreSubmesh()) {
            CalSubmesh submesh = new CalSubmesh(coreSubmesh);
            this.submeshes.add(submesh);
        }
    }

    public CalCoreMesh getCoreMesh() {
        return this.coreMesh;
    }

    public CalSubmesh getSubmesh(int id) {
        return this.submeshes.get(id);
    }

    public int getSubmeshCount() {
        return this.submeshes.size();
    }

    public List<CalSubmesh> getSubmeshes() {
        return this.submeshes;
    }

    public void setLodLevel(float lodLevel) {
        for (CalSubmesh submesh : this.submeshes) {
            submesh.setLodLevel(lodLevel);
        }
    }

    public void setMaterialSet(String setId) {
        for (CalSubmesh submesh : this.submeshes) {
            try {
                int coreMaterialThreadId = submesh.getCoreSubmesh().getCoreMaterialThreadId();
                CalCoreMaterial coreMaterial = this.model.getCoreModel().getCoreMaterial(coreMaterialThreadId, setId);
                submesh.setCoreMaterial(coreMaterial);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMaterialSet(List<CalCoreMaterial> materials) {
        for (CalSubmesh submesh : this.submeshes) {
            try {
                int coreMaterialThreadId = submesh.getCoreSubmesh().getCoreMaterialThreadId();
                CalCoreMaterial coreMaterial = materials.get(Math.max(0, Math.min(coreMaterialThreadId, materials.size() - 1)));
                submesh.setCoreMaterial(coreMaterial);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                System.err.println("Size was = " + materials.size());
            }
        }
    }

    public void setModel(CalModel model) {
        this.model = model;
    }
}

