/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubMorphTarget;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalMesh;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSubmesh;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class CalPhysique {
    protected CalModel model;
    protected boolean normalize = true;

    public CalPhysique(CalModel model) {
        this.model = model;
        if (model.getCoreModel() == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setNormalization(boolean normalize) {
        this.normalize = normalize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateVertices(CalSubmesh submesh, Vector3fBuffer vertexBuffer) {
        CalModel calModel = this.model;
        synchronized (calModel) {
            CalBone[] vectorBone = this.model.getSkeleton().getBones();
            Vector3fBuffer vertexPositions = submesh.getCoreSubmesh().getVertexPositions();
            CalCoreSubmesh.VertexInfo[] vectorVertex = submesh.getCoreSubmesh().getVectorVertexInfo();
            float[] vectorPhysicalProperty = submesh.getCoreSubmesh().getVectorPhysicalProperty();
            int vertexCount = submesh.getVertexCount();
            Vector<CalCoreSubMorphTarget> vectorSubMorphTarget = submesh.getCoreSubmesh().getCoreSubMorphTargets();
            float baseWeight = submesh.getBaseWeight();
            int morphTargetCount = submesh.getMorphTargetWeightCount();
            Vector3f v = new Vector3f();
            Vector3f position = new Vector3f();
            int vertexId = 0;
            while (vertexId < vertexCount) {
                CalCoreSubmesh.VertexInfo vertex = vectorVertex[vertexId];
                vertexPositions.get(vertexId, v);
                if (baseWeight == 1.0f) {
                    position.set((TupleNf)v);
                } else {
                    position.setX(baseWeight * v.getX());
                    position.setY(baseWeight * v.getY());
                    position.setZ(baseWeight * v.getZ());
                    int morphTargetId = 0;
                    while (morphTargetId < morphTargetCount) {
                        vectorSubMorphTarget.get(morphTargetId).getBlendVertexPosition(vertexId, v);
                        float currentWeight = submesh.getMorphTargetWeight(morphTargetId);
                        position.addX(currentWeight * v.getX());
                        position.addY(currentWeight * v.getY());
                        position.addZ(currentWeight * v.getZ());
                        ++morphTargetId;
                    }
                }
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                int influenceCount = vertex.influenceBoneIds.length;
                if (influenceCount == 0) {
                    x = position.getX();
                    y = position.getY();
                    z = position.getZ();
                } else {
                    int influenceId = 0;
                    while (influenceId < influenceCount) {
                        int boneId = vertex.influenceBoneIds[influenceId];
                        float weight = vertex.influenceWeights[influenceId];
                        CalBone bone = vectorBone[boneId];
                        v.set((TupleNf)position);
                        CalCoreBone.transform(v, bone.getRotationBoneSpace());
                        v.add(bone.getTranslationBoneSpace());
                        x += weight * v.getX();
                        y += weight * v.getY();
                        z += weight * v.getZ();
                        ++influenceId;
                    }
                }
                if (submesh.getCoreSubmesh().getSpringCount() > 0 && submesh.hasInternalData()) {
                    float physicalProperty = vectorPhysicalProperty[vertexId];
                    if (physicalProperty == 0.0f) {
                        vertexBuffer.put(vertexId, x, y, z);
                    }
                } else {
                    vertexBuffer.put(vertexId, x, y, z);
                }
                ++vertexId;
            }
            return vertexCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateNormals(CalSubmesh submesh, Vector3fBuffer normalBuffer) {
        CalModel calModel = this.model;
        synchronized (calModel) {
            CalBone[] vectorBone = this.model.getSkeleton().getBones();
            Vector3fBuffer vertexNormals = submesh.getCoreSubmesh().getVertexNormals();
            CalCoreSubmesh.VertexInfo[] vectorVertex = submesh.getCoreSubmesh().getVectorVertexInfo();
            int vertexCount = submesh.getVertexCount();
            Vector<CalCoreSubMorphTarget> vectorSubMorphTarget = submesh.getCoreSubmesh().getCoreSubMorphTargets();
            float baseWeight = submesh.getBaseWeight();
            int morphTargetCount = submesh.getMorphTargetWeightCount();
            Vector3f v = new Vector3f();
            Vector3f normal = new Vector3f();
            int vertexId = 0;
            while (vertexId < vertexCount) {
                CalCoreSubmesh.VertexInfo vertex = vectorVertex[vertexId];
                vertexNormals.get(vertexId, v);
                if (baseWeight == 1.0f) {
                    normal.set((TupleNf)v);
                } else {
                    normal.setX(baseWeight * v.getX());
                    normal.setY(baseWeight * v.getY());
                    normal.setZ(baseWeight * v.getZ());
                    int morphTargetId = 0;
                    while (morphTargetId < morphTargetCount) {
                        vectorSubMorphTarget.get(morphTargetId).getBlendVertexNormal(vertexId, v);
                        float currentWeight = submesh.getMorphTargetWeight(morphTargetId);
                        normal.addX(currentWeight * v.getX());
                        normal.addY(currentWeight * v.getY());
                        normal.addZ(currentWeight * v.getZ());
                        ++morphTargetId;
                    }
                }
                float nx = 0.0f;
                float ny = 0.0f;
                float nz = 0.0f;
                int influenceCount = vertex.influenceBoneIds.length;
                int influenceId = 0;
                while (influenceId < influenceCount) {
                    int boneId = vertex.influenceBoneIds[influenceId];
                    float weight = vertex.influenceWeights[influenceId];
                    CalBone bone = vectorBone[boneId];
                    v.set((TupleNf)normal);
                    CalCoreBone.transform(v, bone.getRotationBoneSpace());
                    nx += weight * v.getX();
                    ny += weight * v.getY();
                    nz += weight * v.getZ();
                    ++influenceId;
                }
                if (this.normalize) {
                    float scale = 1.0f / (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
                    normalBuffer.put(vertexId, nx * scale, ny * scale, nz * scale);
                } else {
                    normalBuffer.put(vertexId, nx, ny, nz);
                }
                ++vertexId;
            }
            return vertexCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateTangents(CalSubmesh submesh, int mapId, Vector3fBuffer tangentBuffer) {
        CalModel calModel = this.model;
        synchronized (calModel) {
            CalBone[] vectorBone = this.model.getSkeleton().getBones();
            CalCoreSubmesh.VertexInfo[] vectorVertex = submesh.getCoreSubmesh().getVectorVertexInfo();
            Vector3fBuffer vertexTangents = submesh.getCoreSubmesh().getVertexTangents(mapId);
            int vertexCount = submesh.getVertexCount();
            Vector<CalCoreSubMorphTarget> vectorSubMorphTarget = submesh.getCoreSubmesh().getCoreSubMorphTargets();
            float baseWeight = submesh.getBaseWeight();
            int morphTargetCount = submesh.getMorphTargetWeightCount();
            Vector3f v = new Vector3f();
            Vector3f tangent = new Vector3f();
            int vertexId = 0;
            while (vertexId < vertexCount) {
                CalCoreSubmesh.VertexInfo vertex = vectorVertex[vertexId];
                vertexTangents.get(vertexId, tangent);
                float tx = 0.0f;
                float ty = 0.0f;
                float tz = 0.0f;
                int influenceCount = vertex.influenceBoneIds.length;
                int influenceId = 0;
                while (influenceId < influenceCount) {
                    int boneId = vertex.influenceBoneIds[influenceId];
                    float weight = vertex.influenceWeights[influenceId];
                    CalBone bone = vectorBone[boneId];
                    v.set((TupleNf)tangent);
                    CalCoreBone.transform(v, bone.getRotationBoneSpace());
                    tx += weight * v.getX();
                    ty += weight * v.getY();
                    tz += weight * v.getZ();
                    ++influenceId;
                }
                if (this.normalize) {
                    float scale = 1.0f / (float)Math.sqrt(tx * tx + ty * ty + tz * tz);
                    tangentBuffer.put(vertexId, tx * scale, ty * scale, tz * scale);
                } else {
                    tangentBuffer.put(vertexId, tx, ty, tz);
                }
                ++vertexId;
            }
            return vertexCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        CalModel calModel = this.model;
        synchronized (calModel) {
            for (CalMesh mesh : this.model.getMeshes()) {
                for (CalSubmesh submesh : mesh.getSubmeshes()) {
                    if (!submesh.hasInternalData()) continue;
                    Vector3fBuffer vectorVertex = submesh.getVertexPositions();
                    this.calculateVertices(submesh, vectorVertex);
                    Vector3fBuffer vectorNormal = submesh.getVertexNormals();
                    this.calculateNormals(submesh, vectorNormal);
                    int mapId = 0;
                    while (mapId < submesh.getVertexTangentsMapCount()) {
                        if (submesh.isTangentsEnabled(mapId)) {
                            this.calculateTangents(submesh, mapId, submesh.getVertexTangents(mapId));
                        }
                        ++mapId;
                    }
                }
            }
        }
    }
}

