/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jagatoo.loaders.models.collada.COLLADAAction;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameQuat4f;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameTuple3f;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Controller;
import org.jagatoo.loaders.models.collada.datastructs.controllers.SkeletalController;
import org.jagatoo.loaders.models.collada.stax.XMLAnimation;
import org.jagatoo.loaders.models.collada.stax.XMLChannel;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryAnimations;
import org.jagatoo.logging.JAGTLog;

public class LibraryAnimationsLoader {
    private static final int MAX_ANIMATIONS_PER_BONE = 4;

    private static void compressRotationKeyFrames(Bone bone) {
    }

    public static void loadLibraryAnimations(AssetFolder colladaFile, XMLLibraryAnimations libAnim) {
        Collection<XMLAnimation> anims = libAnim.animations.values();
        JAGTLog.debug("There ", anims.size() > 1 ? "are" : "is", " ", anims.size(), " animation", anims.size() > 1 ? "s" : "", " in this file.");
        HashMap<String, COLLADAAction> colAnims = colladaFile.getLibraryAnimations().getAnimations();
        for (Skeleton skeleton : colladaFile.getLibraryVisualsScenes().getSkeletons().values()) {
            skeleton.resetIterator();
            JAGTLog.debug("Creating new COLLADAAction with ID of ", skeleton.getRootBone().getName(), "-action.");
            COLLADAAction currAction = new COLLADAAction(String.valueOf(skeleton.getRootBone().getName()) + "-action");
            currAction.setSkeleton(skeleton);
            for (Bone bone : currAction.getSkeleton()) {
                JAGTLog.debug("Loading animations for bone ", bone.getName());
                JAGTLog.increaseIndentation();
                int animCount = 0;
                ArrayList<KeyFrameQuat4f> rotAnims = new ArrayList<KeyFrameQuat4f>();
                for (XMLAnimation animation : anims) {
                    if (animCount >= 4 || !animation.getTargetBone().equals(bone.getName())) continue;
                    JAGTLog.debug(new Object[]{"Loading animation ", animation.name, " of type ", animation.getType(), animation.getType() == XMLChannel.ChannelType.ROTATE ? " and of axis " + (Object)((Object)animation.getRotationAxis()) : ""});
                    if (animation.getType() == null) {
                        animation.channels.get((int)0).type = XMLChannel.ChannelType.SCALE;
                    }
                    switch (animation.getType()) {
                        case TRANSLATE: {
                            KeyFrame keyFrame;
                            JAGTLog.debug("Translation key frame...");
                            int j = 0;
                            int k = 0;
                            while (j < animation.getInput().length) {
                                keyFrame = KeyFrame.buildPoint3fKeyFrame(animation.getInput()[j], animation.getOutput(), k);
                                ++j;
                                k += 3;
                            }
                            break;
                        }
                        case ROTATE: {
                            KeyFrame keyFrame;
                            int j = 0;
                            while (j < animation.getInput().length) {
                                keyFrame = KeyFrame.buildQuaternion4fKeyFrame(animation.getInput()[j], animation.getOutput()[j], animation.getRotationAxis());
                                rotAnims.add((KeyFrameQuat4f)keyFrame);
                                ++j;
                            }
                            break;
                        }
                        case SCALE: {
                            KeyFrame keyFrame;
                            int j = 0;
                            int k = 0;
                            while (j < animation.getInput().length) {
                                keyFrame = KeyFrame.buildPoint3fKeyFrame(animation.getInput()[j], animation.getOutput(), k);
                                bone.scaleKeyFrames.add((KeyFrameTuple3f)keyFrame);
                                ++j;
                                k += 3;
                            }
                            break;
                        }
                    }
                    ++animCount;
                }
                LibraryAnimationsLoader.compressRotationKeyFrames(bone);
                currAction.rotKeyFrames.put(bone, rotAnims);
            }
            currAction.setSkeleton(skeleton);
            colAnims.put(currAction.getId(), currAction);
            JAGTLog.decreaseIndentation();
        }
        for (Controller name : colladaFile.getLibraryControllers().getControllers().values()) {
            if (!(name instanceof SkeletalController)) continue;
            ((SkeletalController)name).libAnims = colladaFile.getLibraryAnimations();
        }
    }
}

