/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;

public class Rotations {
    public static Quaternion4f toQuaternion(float rotX, float rotY, float rotZ, Quaternion4f quat) {
        Matrix3f matrix = MatrixUtils.eulerToMatrix3f(rotX, rotY, rotZ);
        quat.set(matrix);
        quat.normalize();
        return quat;
    }

    public static Quaternion4f toQuaternion(float rotX, float rotY, float rotZ) {
        return Rotations.toQuaternion(rotX, rotY, rotZ, new Quaternion4f());
    }

    public static Quaternion4f toQuaternion(Tuple3f tup) {
        return Rotations.toQuaternion(tup.getX(), tup.getY(), tup.getZ(), new Quaternion4f());
    }

    public static Quaternion4f toQuaternion(Tuple3f tup, Quaternion4f quat) {
        return Rotations.toQuaternion(tup.getX(), tup.getY(), tup.getZ(), quat);
    }

    public static Tuple3f toEuler(Quaternion4f quaternion) {
        Matrix3f matrix = new Matrix3f();
        matrix.set(quaternion);
        Tuple3f euler = MatrixUtils.matrixToEuler(matrix);
        euler.setX(euler.getX());
        euler.setY(euler.getY());
        euler.setZ(euler.getZ());
        return euler;
    }

    public static Quaternion4f toQuaternion(Vector3f axis, float angle) {
        float sinHalfHangle = FastMath.sin(angle / 2.0f);
        float cosHalfHangle = FastMath.cos(angle / 2.0f);
        Quaternion4f quat = new Quaternion4f(axis.getX() * sinHalfHangle, axis.getY() * sinHalfHangle, axis.getZ() * sinHalfHangle, cosHalfHangle);
        return quat;
    }

    private Rotations() {
    }
}

