/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.ArrayList;
import org.jagatoo.loaders.models.collada.Rotations;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.jagatoo.loaders.models.collada.stax.XMLNode;
import org.jagatoo.logging.JAGTLog;
import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonLoader {
    private static void loadJoint(Matrix4f localToWorld, XMLNode node2, Vector3f upVector, Point3f parentRoot, Point3f parentTip, Bone bone, ArrayList<Bone> boneList) {
        boneList.add(bone);
        if (node2.childrenList == null || node2.childrenList != null && node2.childrenList.isEmpty()) {
            JAGTLog.debug("=====================================");
            JAGTLog.debug("[[Bone]] " + bone.getName());
        } else {
            Matrix4f colMatrix = node2.childrenList.get((int)0).matrix.matrix4f;
            JAGTLog.debug("ColMatrix = ", colMatrix);
            Point3f nodeTip = new Point3f(parentTip.getX() + colMatrix.get(0, 3), parentTip.getY() + colMatrix.get(1, 3), parentTip.getZ() + colMatrix.get(2, 3));
            Point3f parentRootW = new Point3f(parentRoot);
            localToWorld.transform(parentRootW);
            Point3f parentTipW = new Point3f(parentTip);
            localToWorld.transform(parentTipW);
            Point3f nodeTipW = new Point3f(nodeTip);
            localToWorld.transform(nodeTipW);
            Vector3f nodeVecW = new Vector3f();
            nodeVecW.sub(nodeTipW, parentTipW);
            Vector3f parentVecW = new Vector3f();
            parentVecW.sub(parentTipW, parentRootW);
            JAGTLog.debug("=====================================");
            JAGTLog.debug("[[Bone]] ", bone.getName());
            JAGTLog.debug("parentRoot = ", parentRoot);
            JAGTLog.debug("parentTip = ", parentTip);
            JAGTLog.debug("nodeTip = ", nodeTip);
            JAGTLog.debug("---");
            JAGTLog.debug("parentRootW = ", parentRootW);
            JAGTLog.debug("parentTipW = ", parentTipW);
            JAGTLog.debug("nodeTipW = ", nodeTipW);
            JAGTLog.debug("---");
            JAGTLog.debug("parentVecW = ", parentVecW);
            JAGTLog.debug("nodeVecW = ", nodeVecW);
            float length = nodeVecW.length();
            parentVecW.normalize();
            nodeVecW.normalize();
            float angle = FastMath.acos(parentVecW.dot(nodeVecW));
            if (Float.isNaN(angle)) {
                angle = 0.0f;
            }
            Vector3f axis = new Vector3f();
            axis.cross(parentVecW, nodeVecW);
            if (Float.isNaN(axis.getX()) | Float.isNaN(axis.getY()) | Float.isNaN(axis.getZ())) {
                axis.set((TupleNf)upVector);
            }
            if (axis.lengthSquared() == 0.0f) {
                axis.set(parentVecW.getZ(), parentVecW.getX(), parentVecW.getY());
                axis.normalize();
                axis.negate();
            } else {
                axis.normalize();
                axis.negate();
            }
            Quaternion4f quat = Rotations.toQuaternion(axis, angle);
            bone.setBindRotation(quat);
            bone.setLength(length);
            JAGTLog.debug("---");
            JAGTLog.debug("angle = ", Float.valueOf(FastMath.toDeg(angle)));
            JAGTLog.debug("axis = ", axis);
            JAGTLog.debug("length = ", Float.valueOf(length));
            JAGTLog.debug("quat = ", quat);
            for (XMLNode child : node2.childrenList) {
                Bone newBone = new Bone(child.sid, child.name, child.matrix.matrix4f, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f));
                bone.addChild(newBone);
                SkeletonLoader.loadJoint(localToWorld, child, upVector, parentTip, nodeTip, newBone, boneList);
            }
        }
    }

    public static Skeleton loadSkeleton(XMLNode rootNode, Vector3f upVector) {
        Matrix4f localToWorld = rootNode.matrix.matrix4f;
        JAGTLog.debug("LocalToWorld = ", localToWorld);
        Point3f skeletonPos = new Point3f(localToWorld.m03(), localToWorld.m13(), localToWorld.m23());
        Bone rootBone = new Bone(rootNode.sid, rootNode.name, localToWorld, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f));
        ArrayList<Bone> boneList = new ArrayList<Bone>();
        SkeletonLoader.loadJoint(localToWorld, rootNode, upVector, Point3f.ZERO, Point3f.ZERO, rootBone, boneList);
        return new Skeleton(rootBone, skeletonPos, boneList);
    }
}

