/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.animation;

import java.util.ArrayList;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameQuat4f;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameTuple3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.FloatUtils;

public class Bone {
    private final String sid;
    private final String name;
    private float length;
    private final Quaternion4f bindRotation;
    public final Matrix4f bindMatrix;
    public final Matrix4f invBindMatrix;
    public final Quaternion4f relativeRotation;
    public final Tuple3f relativeScaling;
    Quaternion4f absoluteRotation;
    Vector3f absoluteTranslation;
    Tuple3f absoluteScaling;
    Matrix4f absoluteTransformation;
    public ArrayList<KeyFrameQuat4f> rotKeyFrames = new ArrayList();
    public ArrayList<KeyFrameTuple3f> scaleKeyFrames = new ArrayList();
    private ArrayList<Bone> children;

    public final String getSourceId() {
        return this.sid;
    }

    public final String getName() {
        return this.name;
    }

    public void setLength(float length) {
        this.length = length;
        this.bindMatrix.m23(length);
        this.invBindMatrix.invert(this.bindMatrix);
    }

    public final float getLength() {
        return this.length;
    }

    public void setBindRotation(Quaternion4f quat) {
        this.bindRotation.set((TupleNf)quat);
        this.bindMatrix.set(this.bindRotation);
    }

    public final Quaternion4f getBindRotation() {
        return this.bindRotation;
    }

    public final Vector3f getAbsoluteTranslation() {
        return this.absoluteTranslation;
    }

    public final Quaternion4f getAbsoluteRotation() {
        return this.absoluteRotation;
    }

    public final Tuple3f getAbsoluteScaling() {
        return this.absoluteScaling;
    }

    public final Matrix4f getAbsoluteTransformation() {
        return this.absoluteTransformation;
    }

    public final boolean hasKeyFrames() {
        int total = 0;
        if (this.rotKeyFrames != null) {
            total += this.rotKeyFrames.size();
        }
        if (this.scaleKeyFrames != null) {
            total += this.scaleKeyFrames.size();
        }
        return total > 0;
    }

    public void setNoRelativeMovement() {
        this.relativeRotation.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.relativeScaling.set(1.0f, 1.0f, 1.0f);
    }

    public int selectCurrentRotFrame(long currentTime) {
        return KeyFrame.searchNextFrame(this.rotKeyFrames, currentTime);
    }

    public int selectCurrentScaleFrame(long currentTime) {
        return KeyFrame.searchNextFrame(this.scaleKeyFrames, currentTime);
    }

    public void addChild(Bone bone) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(bone);
    }

    public void removeChild(Bone bone) {
        if (this.children != null) {
            this.children.remove(bone);
        }
    }

    public final int numChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public final Bone getChild(int i) {
        return this.children == null ? null : this.children.get(i);
    }

    public String toString() {
        return String.valueOf(this.name) + "] Bind rotation : " + this.bindRotation + ", length : " + this.length;
    }

    public Bone(String sid, String name, Matrix4f matrix, Quaternion4f bindRotation) {
        this.sid = sid;
        this.name = name;
        this.bindMatrix = matrix;
        this.invBindMatrix = new Matrix4f();
        this.invBindMatrix.invert(this.bindMatrix);
        this.length = FloatUtils.vectorLength(matrix.m03(), matrix.m13(), matrix.m23());
        this.bindRotation = bindRotation;
        this.relativeRotation = new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.relativeScaling = new Tuple3f(1.0f, 1.0f, 1.0f);
        this.absoluteRotation = new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.absoluteTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        this.absoluteScaling = new Tuple3f(1.0f, 1.0f, 1.0f);
        this.absoluteTransformation = new Matrix4f(this.bindMatrix);
    }
}

