/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameTuple3f;
import org.jagatoo.loaders.models.collada.datastructs.animation.SkeletonIterator;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Skeleton
implements Iterable<Bone> {
    private final Bone rootBone;
    private final HashMap<String, Bone> boneMap = new HashMap();
    private final Matrix3f tempMatrix = new Matrix3f();
    private final Point3f tempPoint = new Point3f();
    public final Point3f relativeTranslation;
    public ArrayList<KeyFrameTuple3f> transKeyFrames = new ArrayList();
    private SkeletonIterator iterator = new SkeletonIterator(this);

    public final Bone getRootBone() {
        return this.rootBone;
    }

    public final Bone getBoneBySourceId(String sourceId) {
        return this.boneMap.get(sourceId);
    }

    public int selectCurrentTransFrame(long currentTime) {
        return KeyFrame.searchNextFrame(this.transKeyFrames, currentTime);
    }

    private void updateBone(Bone parentBone, Bone bone) {
        if (parentBone == null) {
            bone.absoluteRotation.set((TupleNf)bone.getBindRotation());
            bone.absoluteRotation.mul(bone.relativeRotation);
            bone.absoluteTranslation.set((TupleNf)this.relativeTranslation);
            bone.absoluteTranslation.normalize();
            bone.absoluteTranslation.mul(bone.getLength());
            bone.absoluteScaling.set((TupleNf)bone.relativeScaling);
            bone.absoluteTransformation.setIdentity();
        } else {
            bone.absoluteRotation.set((TupleNf)parentBone.absoluteRotation);
            bone.absoluteRotation.mul(bone.getBindRotation());
            bone.absoluteRotation.mul(bone.relativeRotation);
            bone.absoluteTranslation.set((TupleNf)parentBone.absoluteTranslation);
            this.tempMatrix.set(bone.absoluteRotation);
            this.tempPoint.set(0.0f, 0.0f, bone.getLength());
            this.tempMatrix.transform(this.tempPoint);
            bone.absoluteTranslation.add(this.tempPoint);
            bone.absoluteScaling.set((TupleNf)parentBone.absoluteScaling);
            bone.absoluteScaling.set(bone.absoluteScaling.getX() * bone.relativeScaling.getX(), bone.absoluteScaling.getY() * bone.relativeScaling.getY(), bone.absoluteScaling.getZ() * bone.relativeScaling.getZ());
            bone.absoluteTransformation.set(parentBone.absoluteTransformation);
            bone.absoluteTransformation.mul(bone.bindMatrix);
        }
        bone.absoluteTranslation.set(bone.absoluteTranslation.getX() * bone.absoluteScaling.getX(), bone.absoluteTranslation.getY() * bone.absoluteScaling.getY(), bone.absoluteTranslation.getZ() * bone.absoluteScaling.getZ());
        int i = 0;
        while (i < bone.numChildren()) {
            this.updateBone(bone, bone.getChild(i));
            ++i;
        }
    }

    public void updateAbsolutes() {
        this.updateBone(null, this.rootBone);
    }

    @Override
    public Iterator<Bone> iterator() {
        if (this.iterator == null) {
            this.iterator = new SkeletonIterator(this);
        }
        if (!this.iterator.hasNext()) {
            this.resetIterator();
        }
        return this.iterator;
    }

    public void resetIterator() {
        this.iterator = new SkeletonIterator(this);
        this.iterator.reset();
    }

    public Skeleton(Bone rootBone, Point3f relativeTranslation, ArrayList<Bone> boneList) {
        this.rootBone = rootBone;
        int i = 0;
        while (i < boneList.size()) {
            Bone bone = boneList.get(i);
            this.boneMap.put(bone.getSourceId(), bone);
            ++i;
        }
        this.relativeTranslation = relativeTranslation;
        this.transKeyFrames = new ArrayList();
    }
}

