/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.loaders.models.collada.stax.XMLContributor;
import org.jagatoo.loaders.models.collada.stax.XMLUnit;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Vector3f;

public class XMLAsset {
    public List<XMLContributor> contributors = new ArrayList<XMLContributor>();
    public String created = null;
    public String modified = null;
    public XMLUnit unit = null;
    public UpAxis upAxis = null;

    public final Vector3f getUpVector() {
        if (this.upAxis == null) {
            return Vector3f.POSITIVE_Y_AXIS;
        }
        switch (this.upAxis) {
            case X_UP: {
                return Vector3f.POSITIVE_X_AXIS;
            }
            case Y_UP: {
                return Vector3f.POSITIVE_Y_AXIS;
            }
            case Z_UP: {
                return Vector3f.POSITIVE_Z_AXIS;
            }
        }
        return null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.created == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing created.");
        }
        if (this.modified == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing modified.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("contributor")) {
                        XMLContributor contributor = new XMLContributor();
                        contributor.parse(parser);
                        this.contributors.add(contributor);
                        break;
                    }
                    if (parser.getLocalName().equals("created")) {
                        if (this.created != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), ": already has created.");
                        }
                        this.created = StAXHelper.parseText(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("modified")) {
                        if (this.modified != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), ": already has modified.");
                        }
                        this.modified = StAXHelper.parseText(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("unit")) {
                        if (this.unit != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), ": already has unit.");
                        }
                        this.unit = new XMLUnit();
                        this.unit.parse(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("up_axis")) {
                        if (this.upAxis != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), ": already has upAxis.");
                        }
                        String axis = StAXHelper.parseText(parser);
                        this.upAxis = UpAxis.valueOf(axis);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("asset")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpAxis {
        X_UP,
        Y_UP,
        Z_UP;

    }
}

