/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryAnimations;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryControllers;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryEffects;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryGeometries;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryImages;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryMaterials;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryVisualScenes;
import org.jagatoo.logging.JAGTLog;

public class XMLCOLLADA {
    public String version = null;
    public XMLAsset asset = null;
    public ArrayList<XMLLibraryAnimations> libraryAnimations = new ArrayList();
    public ArrayList<XMLLibraryControllers> libraryControllers = new ArrayList();
    public ArrayList<XMLLibraryEffects> libraryEffects = new ArrayList();
    public ArrayList<XMLLibraryImages> libraryImages = new ArrayList();
    public ArrayList<XMLLibraryMaterials> libraryMaterials = new ArrayList();
    public ArrayList<XMLLibraryGeometries> libraryGeometries = new ArrayList();
    public ArrayList<XMLLibraryVisualScenes> libraryVisualScenes = new ArrayList();

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("COLLADA")) break;
                    if (parser.getLocalName().equals("asset")) {
                        if (this.asset != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), ": already has asset tag.");
                        }
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (parser.getLocalName().equals("library_geometries")) {
                        XMLLibraryGeometries geomLib = new XMLLibraryGeometries();
                        geomLib.parse(parser);
                        this.libraryGeometries.add(geomLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_visual_scenes")) {
                        XMLLibraryVisualScenes visSceneLib = new XMLLibraryVisualScenes();
                        visSceneLib.parse(parser);
                        this.libraryVisualScenes.add(visSceneLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_materials")) {
                        XMLLibraryMaterials matLib = new XMLLibraryMaterials();
                        matLib.parse(parser);
                        this.libraryMaterials.add(matLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_images")) {
                        XMLLibraryImages imageLib = new XMLLibraryImages();
                        imageLib.parse(parser);
                        this.libraryImages.add(imageLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_controllers")) {
                        XMLLibraryControllers contrLib = new XMLLibraryControllers();
                        contrLib.parse(parser);
                        this.libraryControllers.add(contrLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_effects")) {
                        XMLLibraryEffects effectLib = new XMLLibraryEffects();
                        effectLib.parse(parser);
                        this.libraryEffects.add(effectLib);
                        break;
                    }
                    if (parser.getLocalName().equals("library_animations")) {
                        XMLLibraryAnimations animationLib = new XMLLibraryAnimations();
                        animationLib.parse(parser);
                        this.libraryAnimations.add(animationLib);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                }
            }
            event = parser.next();
        }
        if (this.asset == null) {
            JAGTLog.exception(this.getClass().getSimpleName(), ": missing asset.");
        }
    }
}

