/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLGeometry;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryGeometries {
    private ArrayList<XMLGeometry> geometriesList = new ArrayList();
    public HashMap<String, XMLGeometry> geometries = null;

    public void readGeometries() {
        this.geometries = new HashMap();
        for (XMLGeometry geometry : this.geometriesList) {
            this.geometries.put(geometry.id, geometry);
        }
        this.geometriesList = null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.geometriesList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing geometry.");
        }
        this.readGeometries();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("geometry")) {
                        XMLGeometry geom = new XMLGeometry();
                        geom.parse(parser);
                        this.geometriesList.add(geom);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_geometries")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

