/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.loaders.models.collada.stax.XMLSampler2D;
import org.jagatoo.loaders.models.collada.stax.XMLSurface;
import org.jagatoo.logging.JAGTLog;

public class XMLProfileCOMMON_NewParam {
    public String sid = null;
    public String semantic = null;
    public XMLSurface surface = null;
    public XMLSampler2D sampler2D = null;

    private void checkVars(String name) {
        if (this.semantic != null || this.sampler2D != null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", name, " tags.");
        }
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.semantic == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing semantic.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("sid")) {
                this.sid = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("semantic")) {
                        if (this.semantic != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", localName, " tags.");
                        }
                        this.semantic = StAXHelper.parseText(parser);
                        break;
                    }
                    if (localName.equals("surface")) {
                        this.checkVars(localName);
                        this.surface = new XMLSurface();
                        this.surface.parse(parser);
                        break;
                    }
                    if (localName.equals("sampler2D")) {
                        this.checkVars(localName);
                        this.sampler2D = new XMLSampler2D();
                        this.sampler2D.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("newparam")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

